// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Graphic3d_StructureManager_HeaderFile
#define _Graphic3d_StructureManager_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_Graphic3d_StructureManager_HeaderFile
#include <Handle_Graphic3d_StructureManager.hxx>
#endif

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Aspect_TypeOfUpdate_HeaderFile
#include <Aspect_TypeOfUpdate.hxx>
#endif
#ifndef _Handle_Graphic3d_AspectLine3d_HeaderFile
#include <Handle_Graphic3d_AspectLine3d.hxx>
#endif
#ifndef _Handle_Graphic3d_AspectText3d_HeaderFile
#include <Handle_Graphic3d_AspectText3d.hxx>
#endif
#ifndef _Handle_Graphic3d_AspectMarker3d_HeaderFile
#include <Handle_Graphic3d_AspectMarker3d.hxx>
#endif
#ifndef _Handle_Graphic3d_AspectFillArea3d_HeaderFile
#include <Handle_Graphic3d_AspectFillArea3d.hxx>
#endif
#ifndef _Graphic3d_MapOfStructure_HeaderFile
#include <Graphic3d_MapOfStructure.hxx>
#endif
#ifndef _Aspect_GenId_HeaderFile
#include <Aspect_GenId.hxx>
#endif
#ifndef _Handle_Aspect_GraphicDevice_HeaderFile
#include <Handle_Aspect_GraphicDevice.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Graphic3d_Structure_HeaderFile
#include <Handle_Graphic3d_Structure.hxx>
#endif
#ifndef _Handle_Graphic3d_DataStructureManager_HeaderFile
#include <Handle_Graphic3d_DataStructureManager.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Aspect_TypeOfHighlightMethod_HeaderFile
#include <Aspect_TypeOfHighlightMethod.hxx>
#endif
class Graphic3d_AspectLine3d;
class Graphic3d_AspectText3d;
class Graphic3d_AspectMarker3d;
class Graphic3d_AspectFillArea3d;
class Aspect_GraphicDevice;
class Graphic3d_InitialisationError;
class Graphic3d_Structure;
class Graphic3d_MapOfStructure;
class Graphic3d_DataStructureManager;
class TColStd_Array2OfReal;


//! This class allows the definition of a manager to <br>
//!	    which the graphic objects are associated. <br>
//!	    It allows them to be globally manipulated. <br>
//!	    It defines the global attributes. <br>
//!  Keywords: Structure, Structure Manager, Update Mode, <br>
//!     Destroy, Highlight, Visible, Detectable <br>
class Graphic3d_StructureManager : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Deletes the manager <me>. <br>
Standard_EXPORT virtual  void Destroy() ;
~Graphic3d_StructureManager()
{
  Destroy();
}


//! Modifies the default attributes for lines <br>
//!	    in the visualiser. <br>
Standard_EXPORT   void SetPrimitivesAspect(const Handle(Graphic3d_AspectLine3d)& CTX) ;

//! Modifies the default attributes for faces <br>
//!	    in the visualiser. <br>
Standard_EXPORT   void SetPrimitivesAspect(const Handle(Graphic3d_AspectFillArea3d)& CTX) ;

//! Modifies the default attributes for text <br>
//!	    in the visualiser. <br>
Standard_EXPORT   void SetPrimitivesAspect(const Handle(Graphic3d_AspectText3d)& CTX) ;

//! Modifies the default attributes for markers <br>
//!	    in the visualiser. <br>
Standard_EXPORT   void SetPrimitivesAspect(const Handle(Graphic3d_AspectMarker3d)& CTX) ;

//! Modifies the screen update mode. <br>
Standard_EXPORT   void SetUpdateMode(const Aspect_TypeOfUpdate AType) ;

//! Updates screen in function of modifications of <br>
//!	    the structures. <br>
//! Warning: Not necessary if the update mode is TOU_ASAP. <br>
Standard_EXPORT virtual  void Update() const = 0;

//! Returns the set of structures displayed in <br>
//!	    visualiser <me>. <br>
Standard_EXPORT   void DisplayedStructures(Graphic3d_MapOfStructure& SG) const;

//! Returns the set of highlighted structures <br>
//!	    in a visualiser <me>. <br>
Standard_EXPORT   void HighlightedStructures(Graphic3d_MapOfStructure& SG) const;

//! Returns the set of detectable structures <br>
//!	    in a visualiser <me>. <br>
Standard_EXPORT   void PickStructures(Graphic3d_MapOfStructure& SG) const;

//! Returns the set of visible structures <br>
//!	    in a visualiser <me>. <br>
Standard_EXPORT   void VisibleStructures(Graphic3d_MapOfStructure& SG) const;

//! Returns the values of the current default attributes. <br>
Standard_EXPORT   Handle_Graphic3d_AspectFillArea3d FillArea3dAspect() const;

//! Returns maximum number of managers defineable. <br>
Standard_EXPORT static  Standard_Integer Limit() ;

//! Returns the values of the current default attributes. <br>
Standard_EXPORT   Handle_Graphic3d_AspectLine3d Line3dAspect() const;

//! Returns the values of the current default attributes. <br>
Standard_EXPORT   Handle_Graphic3d_AspectMarker3d Marker3dAspect() const;

//! Returns the coordinates of the boundary box of all <br>
//!	    structures displayed in the manager <me>. <br>
Standard_EXPORT   void MinMaxValues(Standard_Real& XMin,Standard_Real& YMin,Standard_Real& ZMin,Standard_Real& XMax,Standard_Real& YMax,Standard_Real& ZMax) const;

//! Returns the values of the current default attributes. <br>
Standard_EXPORT   void PrimitivesAspect(Handle(Graphic3d_AspectLine3d)& CTXL,Handle(Graphic3d_AspectText3d)& CTXT,Handle(Graphic3d_AspectMarker3d)& CTXM,Handle(Graphic3d_AspectFillArea3d)& CTXF) const;

//! Returns the values of the current default attributes. <br>
Standard_EXPORT   Handle_Graphic3d_AspectText3d Text3dAspect() const;

//! Returns the screen update mode. <br>
Standard_EXPORT   Aspect_TypeOfUpdate UpdateMode() const;

//! Changes the display priority of the structure <AStructure>. <br>
Standard_EXPORT virtual  void ChangeDisplayPriority(const Handle(Graphic3d_Structure)& AStructure,const Standard_Integer OldPriority,const Standard_Integer NewPriority)  = 0;

//! Returns a current identifier available. <br>
Standard_EXPORT static  Standard_Integer CurrentId() ;

//! Forces a new construction of the structure <AStructure> <br>
//!	    if <AStructure> is displayed and TOS_COMPUTED. <br>
Standard_EXPORT virtual  void ReCompute(const Handle(Graphic3d_Structure)& AStructure)  = 0;

//! Forces a new construction of the structure <AStructure> <br>
//!	    if <AStructure> is displayed in <AProjector> and TOS_COMPUTED. <br>
Standard_EXPORT virtual  void ReCompute(const Handle(Graphic3d_Structure)& AStructure,const Handle(Graphic3d_DataStructureManager)& AProjector)  = 0;

//! Clears the structure <AStructure>. <br>
Standard_EXPORT virtual  void Clear(const Handle(Graphic3d_Structure)& AStructure,const Standard_Boolean WithDestruction)  = 0;

//! Connects the structures <AMother> and <ADaughter>. <br>
Standard_EXPORT virtual  void Connect(const Handle(Graphic3d_Structure)& AMother,const Handle(Graphic3d_Structure)& ADaughter)  = 0;

//! Disconnects the structures <AMother> and <ADaughter>. <br>
Standard_EXPORT virtual  void Disconnect(const Handle(Graphic3d_Structure)& AMother,const Handle(Graphic3d_Structure)& ADaughter)  = 0;

//! Display the structure <AStructure>. <br>
Standard_EXPORT virtual  void Display(const Handle(Graphic3d_Structure)& AStructure)  = 0;

//! Erases the structure <AStructure>. <br>
Standard_EXPORT virtual  void Erase(const Handle(Graphic3d_Structure)& AStructure)  = 0;

//! Highlights the structure <AStructure>. <br>
Standard_EXPORT virtual  void Highlight(const Handle(Graphic3d_Structure)& AStructure,const Aspect_TypeOfHighlightMethod AMethod)  = 0;

//! Transforms the structure <AStructure>. <br>
Standard_EXPORT virtual  void SetTransform(const Handle(Graphic3d_Structure)& AStructure,const TColStd_Array2OfReal& ATrsf)  = 0;

//! Returns the graphic device of <me>. <br>
Standard_EXPORT   Handle_Aspect_GraphicDevice GraphicDevice() const;

//! Returns the identification number of the manager. <br>
Standard_EXPORT virtual  Standard_Integer Identification() const;

//! Returns the structure with the identification number <AId>. <br>
Standard_EXPORT virtual  Handle_Graphic3d_Structure Identification(const Standard_Integer AId) const;

//! Suppresses the highlighting on all the structures in <me>. <br>
Standard_EXPORT virtual  void UnHighlight()  = 0;

//! Suppress the highlighting on the structure <AStructure>. <br>
Standard_EXPORT virtual  void UnHighlight(const Handle(Graphic3d_Structure)& AStructure)  = 0;


friend class Graphic3d_Structure;


 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! Initialise the constructor of the ViewManager. <br>
//!  Warning: Raises InitialisationError if the initialisation <br>
//!	    of the ViewManager failed. <br>
Standard_EXPORT Graphic3d_StructureManager(const Handle(Aspect_GraphicDevice)& aDevice);

//! Returns the number of structures displayed in <br>
//!	    visualiser <me>. <br>//! Returns the structure displayed in visualiser <me>. <br>
Standard_EXPORT   Standard_Integer NumberOfDisplayedStructures() const;


 // Fields PROTECTED
 //
Standard_Integer MyId;
Aspect_TypeOfUpdate MyUpdateMode;
Handle_Graphic3d_AspectLine3d MyAspectLine3d;
Handle_Graphic3d_AspectText3d MyAspectText3d;
Handle_Graphic3d_AspectMarker3d MyAspectMarker3d;
Handle_Graphic3d_AspectFillArea3d MyAspectFillArea3d;
Graphic3d_MapOfStructure MyDisplayedStructure;
Graphic3d_MapOfStructure MyHighlightedStructure;
Graphic3d_MapOfStructure MyVisibleStructure;
Graphic3d_MapOfStructure MyPickStructure;
Aspect_GenId MyStructGenId;
Handle_Aspect_GraphicDevice MyGraphicDevice;


private: 

 // Methods PRIVATE
 // 

//! Sets detectable the structure <AStructure>. <br>
Standard_EXPORT   void Detectable(const Handle(Graphic3d_Structure)& AStructure) ;

//! Sets invisible the structure <AStructure>. <br>
Standard_EXPORT   void Invisible(const Handle(Graphic3d_Structure)& AStructure) ;

//! Returns a new identification number for a new structure <br>
//!	    in the manager. <br>
Standard_EXPORT   Standard_Integer NewIdentification() ;

//! Frees the identifieur <AnId>. <br>
Standard_EXPORT   void Remove(const Standard_Integer AnId) ;

//! Sets no detectable the structure <AStructure>. <br>
Standard_EXPORT   void Undetectable(const Handle(Graphic3d_Structure)& AStructure) ;

//! Sets visible the structure <AStructure>. <br>
//!	    in the manager. <br>
Standard_EXPORT   void Visible(const Handle(Graphic3d_Structure)& AStructure) ;


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
