// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _HLRTopoBRep_DSFiller_HeaderFile
#define _HLRTopoBRep_DSFiller_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class TopoDS_Shape;
class Contap_Contour;
class HLRTopoBRep_Data;
class BRepTopAdaptor_MapOfShapeTool;
class TopoDS_Face;
class TopoDS_Vertex;
class Contap_ThePointOfContour;
class TopoDS_Edge;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Provides methods  to  fill a HLRTopoBRep_Data. <br>
class HLRTopoBRep_DSFiller  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Stores in <DS> the outlines of  <S> using the current <br>
//!          outliner and stores the isolines in <DS> using a Hatcher. <br>
Standard_EXPORT static  void Insert(const TopoDS_Shape& S,Contap_Contour& FO,HLRTopoBRep_Data& DS,BRepTopAdaptor_MapOfShapeTool& MST,const Standard_Integer nbIso) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 

//! Stores in <DS> the outlines of  <F> using the current <br>
//!          outliner. <br>
Standard_EXPORT static  void InsertFace(const Standard_Integer FI,const TopoDS_Face& F,Contap_Contour& FO,HLRTopoBRep_Data& DS,const Standard_Boolean withPCurve) ;

//! Make a  vertex  from an intersection  point <P>and <br>
//!          store it in the data structure <DS>. <br>
Standard_EXPORT static  TopoDS_Vertex MakeVertex(const Contap_ThePointOfContour& P,const Standard_Real tol,HLRTopoBRep_Data& DS) ;

//! Insert a vertex    from an internal   intersection <br>
//!          point <P> on restriction <E>  and store it in  the <br>
//!          data structure <DS>. <br>
Standard_EXPORT static  void InsertVertex(const Contap_ThePointOfContour& P,const Standard_Real tol,const TopoDS_Edge& E,HLRTopoBRep_Data& DS) ;

//! Split all  the edges  with  vertices in   the data <br>
//!          structure. <br>
Standard_EXPORT static  void ProcessEdges(HLRTopoBRep_Data& DS) ;


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
