// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_SelectSignature_HeaderFile
#define _IFSelect_SelectSignature_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IFSelect_SelectSignature_HeaderFile
#include <Handle_IFSelect_SelectSignature.hxx>
#endif

#ifndef _Handle_IFSelect_Signature_HeaderFile
#include <Handle_IFSelect_Signature.hxx>
#endif
#ifndef _Handle_IFSelect_SignCounter_HeaderFile
#include <Handle_IFSelect_SignCounter.hxx>
#endif
#ifndef _TCollection_AsciiString_HeaderFile
#include <TCollection_AsciiString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _TColStd_SequenceOfAsciiString_HeaderFile
#include <TColStd_SequenceOfAsciiString.hxx>
#endif
#ifndef _TColStd_SequenceOfInteger_HeaderFile
#include <TColStd_SequenceOfInteger.hxx>
#endif
#ifndef _IFSelect_SelectExtract_HeaderFile
#include <IFSelect_SelectExtract.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_Interface_InterfaceModel_HeaderFile
#include <Handle_Interface_InterfaceModel.hxx>
#endif
class IFSelect_Signature;
class IFSelect_SignCounter;
class TCollection_AsciiString;
class Standard_Transient;
class Interface_Graph;
class Interface_InterfaceModel;


//! A SelectSignature sorts the Entities on a Signature Matching. <br>
//!           The signature to match is given at creation time. Also, the <br>
//!           required match is given at creation time : exact (IsEqual) or <br>
//!           contains (the Type's Name must contain the criterium Text) <br>
//! <br>
//!           Remark that no more interpretation is done, it is an <br>
//!           alpha-numeric signature : for instance, DynamicType is matched <br>
//!           as such, super-types are not considered <br>
//! <br>
//!           Also, numeric (integer) comparisons are supported : an item <br>
//!           can be <val ou <=val or >val or >=val , val being an Integer <br>
//! <br>
//!           A SelectSignature may also be created from a SignCounter, <br>
//!           which then just gives its LastValue as SignatureValue <br>
class IFSelect_SelectSignature : public IFSelect_SelectExtract {

public:
 // Methods PUBLIC
 // 

//! Creates a SelectSignature with its Signature and its Text to <br>
//!           Match. <br>
//!           <exact> if True requires exact match, <br>
//!           if False requires <signtext> to be contained in the Signature <br>
//!           of the entity (default is "exact") <br>
Standard_EXPORT IFSelect_SelectSignature(const Handle(IFSelect_Signature)& matcher,const Standard_CString signtext,const Standard_Boolean exact = Standard_True);

//! As above with an AsciiString <br>
Standard_EXPORT IFSelect_SelectSignature(const Handle(IFSelect_Signature)& matcher,const TCollection_AsciiString& signtext,const Standard_Boolean exact = Standard_True);

//! Creates a SelectSignature with a Counter, more precisely a <br>
//!           SelectSignature. Which is used here to just give a Signature <br>
//!           Value (by SignOnly Mode) <br>
//!           Matching is the default provided by the class Signature <br>
Standard_EXPORT IFSelect_SelectSignature(const Handle(IFSelect_SignCounter)& matcher,const Standard_CString signtext,const Standard_Boolean exact = Standard_True);

//! Returns the used Signature, then it is possible to access it, <br>
//!           modify it as required. Can be null, hence see Counter <br>
Standard_EXPORT   Handle_IFSelect_Signature Signature() const;

//! Returns the used SignCounter. Can be used as alternative for <br>
//!           Signature <br>
Standard_EXPORT   Handle_IFSelect_SignCounter Counter() const;

//! Returns True for an Entity (model->Value(num)) of which the <br>
//!           signature matches the text given as creation time <br>
//!           May also work with a Counter from the Graph <br>
Standard_EXPORT virtual  Standard_Boolean SortInGraph(const Standard_Integer rank,const Handle(Standard_Transient)& ent,const Interface_Graph& G) const;

//! Not called, defined only to remove a deferred method here <br>
Standard_EXPORT   Standard_Boolean Sort(const Standard_Integer rank,const Handle(Standard_Transient)& ent,const Handle(Interface_InterfaceModel)& model) const;

//! Returns Text used to Sort Entity on its Signature or SignCounter <br>
Standard_EXPORT  const TCollection_AsciiString& SignatureText() const;

//! Returns True if match must be exact <br>
Standard_EXPORT   Standard_Boolean IsExact() const;

//! Returns a text defining the criterium. <br>
//!           (it refers to the text and exact flag to be matched, and is <br>
//!           qualified by the Name provided by the Signature) <br>
Standard_EXPORT   TCollection_AsciiString ExtractLabel() const;
//Standard_EXPORT ~IFSelect_SelectSignature();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_IFSelect_Signature thematcher;
Handle_IFSelect_SignCounter thecounter;
TCollection_AsciiString thesigntext;
Standard_Integer theexact;
TColStd_SequenceOfAsciiString thesignlist;
TColStd_SequenceOfInteger thesignmode;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
