// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IGESSolid_RightAngularWedge_HeaderFile
#define _IGESSolid_RightAngularWedge_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_IGESSolid_RightAngularWedge_HeaderFile
#include <Handle_IGESSolid_RightAngularWedge.hxx>
#endif

#ifndef _gp_XYZ_HeaderFile
#include <gp_XYZ.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _IGESData_IGESEntity_HeaderFile
#include <IGESData_IGESEntity.hxx>
#endif
class gp_XYZ;
class gp_Pnt;
class gp_Dir;


//! defines RightAngularWedge, Type <152> Form Number <0> <br>
//!          in package IGESSolid <br>
//!          A right angular wedge is a triangular/trapezoidal prism <br>
class IGESSolid_RightAngularWedge : public IGESData_IGESEntity {

public:
 // Methods PUBLIC
 // 


Standard_EXPORT IGESSolid_RightAngularWedge();

//! This method is used to set the fields of the class <br>
//!           RightAngularWedge <br>
//!       - aSize    : the lengths along the local axes <br>
//!       - lowX     : the length at the smaller X-side <br>
//!       - aCorner  : the corner point coordinates <br>
//!                    default (0,0,0) <br>
//!       - anXAxis  : the unit vector defining local X-axis <br>
//!                    default (1,0,0) <br>
//!       - anZAxis  : the unit vector defining local Z-axis <br>
//!                    default (0,0,1) <br>
Standard_EXPORT   void Init(const gp_XYZ& aSize,const Standard_Real lowX,const gp_XYZ& aCorner,const gp_XYZ& anXAxis,const gp_XYZ& anZAxis) ;

//! returns the size <br>
Standard_EXPORT   gp_XYZ Size() const;

//! returns the length along the local X-axis <br>
Standard_EXPORT   Standard_Real XBigLength() const;

//! returns the smaller length along the local X-direction at Y=LY <br>
Standard_EXPORT   Standard_Real XSmallLength() const;

//! returns the length along the local Y-axis <br>
Standard_EXPORT   Standard_Real YLength() const;

//! returns the length along the local Z-axis <br>
Standard_EXPORT   Standard_Real ZLength() const;

//! returns the corner point coordinates <br>
Standard_EXPORT   gp_Pnt Corner() const;

//! returns the corner point coordinates after applying <br>
//! TransformationMatrix <br>
Standard_EXPORT   gp_Pnt TransformedCorner() const;

//! returns the direction defining the local X-axis <br>
Standard_EXPORT   gp_Dir XAxis() const;

//! returns the direction defining the local X-axis <br>
//! after applying the TransformationMatrix <br>
Standard_EXPORT   gp_Dir TransformedXAxis() const;

//! returns the direction defining the local Y-axis <br>
//! it is got by taking the cross product of ZAxis and XAxis <br>
Standard_EXPORT   gp_Dir YAxis() const;

//! returns the direction defining the local Y-axis <br>
//! after applying the TransformationMatrix <br>
Standard_EXPORT   gp_Dir TransformedYAxis() const;

//! returns the direction defining the local Z-axis <br>
Standard_EXPORT   gp_Dir ZAxis() const;

//! returns the direction defining the local Z-axis <br>
//! after applying the TransformationMatrix <br>
Standard_EXPORT   gp_Dir TransformedZAxis() const;
//Standard_EXPORT ~IGESSolid_RightAngularWedge();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_XYZ theSize;
Standard_Real theXSmallLength;
gp_XYZ theCorner;
gp_XYZ theXAxis;
gp_XYZ theZAxis;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
