// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ImageUtility_XPR_HeaderFile
#define _ImageUtility_XPR_HeaderFile

#ifndef _Handle_Image_Image_HeaderFile
#include <Handle_Image_Image.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_AlienImage_AlienUserImage_HeaderFile
#include <Handle_AlienImage_AlienUserImage.hxx>
#endif
#ifndef _Handle_AlienImage_XAlienImage_HeaderFile
#include <Handle_AlienImage_XAlienImage.hxx>
#endif
class Standard_TypeMismatch;
class Image_Image;
class AlienImage_AlienUserImage;
class AlienImage_XAlienImage;
class OSD_File;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Performs a "xpr" with a XAlienImage build <br>
//! 		 from any Image , any AlienImage . <br>
class ImageUtility_XPR  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Write content of a Image object to aTmpFile and <br>
//!          execute a Spawn "xpr xprOptions aTmpFile | lpr &" . <br>
Standard_EXPORT static  void XPR(const Handle(Image_Image)& aImage,const Standard_CString aName,const Standard_CString xprOptions = "") ;

//! Write content of a  AlienImage object to aTmpFile and <br>
//!          execute a Spawn "xpr xprOptions aTmpFile| lpr  &" . <br>
Standard_EXPORT static  void XPR(const Handle(AlienImage_AlienUserImage)& aAlienUserImage,const Standard_CString aName,const Standard_CString xprOptions = "") ;

//! Write content of a  XAlienImage object to aTmpFile and <br>
//!          execute a Spawn "xpr xprOptions aTmpFile| lpr  &" . <br>
Standard_EXPORT static  void XPR(const Handle(AlienImage_XAlienImage)& aXAlienImage,const Standard_CString xprOptions = "") ;

//! execute a Spawn <br>
//!	"xpr xprOptions /aFile.SystemName()/ | lpr &" . <br>
Standard_EXPORT static  void XPR(const OSD_File& aFile,const Standard_CString xprOptions = "") ;

//! execute a Spawn "xpr xprOptions aFileName | lpr &" . <br>
Standard_EXPORT static  void XPR(const Standard_CString aFileName,const Standard_CString xprOptions = "") ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
