// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IntTools_EdgeFace_HeaderFile
#define _IntTools_EdgeFace_HeaderFile

#ifndef _TopoDS_Edge_HeaderFile
#include <TopoDS_Edge.hxx>
#endif
#ifndef _TopoDS_Face_HeaderFile
#include <TopoDS_Face.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _BRepAdaptor_Curve_HeaderFile
#include <BRepAdaptor_Curve.hxx>
#endif
#ifndef _BRepAdaptor_Surface_HeaderFile
#include <BRepAdaptor_Surface.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _IntTools_PContext_HeaderFile
#include <IntTools_PContext.hxx>
#endif
#ifndef _IntTools_SequenceOfRanges_HeaderFile
#include <IntTools_SequenceOfRanges.hxx>
#endif
#ifndef _IntTools_FClass2d_HeaderFile
#include <IntTools_FClass2d.hxx>
#endif
#ifndef _IntTools_CArray1OfReal_HeaderFile
#include <IntTools_CArray1OfReal.hxx>
#endif
#ifndef _IntTools_SequenceOfRoots_HeaderFile
#include <IntTools_SequenceOfRoots.hxx>
#endif
#ifndef _IntTools_SequenceOfCommonPrts_HeaderFile
#include <IntTools_SequenceOfCommonPrts.hxx>
#endif
#ifndef _IntTools_Range_HeaderFile
#include <IntTools_Range.hxx>
#endif
class TopoDS_Edge;
class TopoDS_Face;
class IntTools_Range;
class IntTools_SequenceOfCommonPrts;
class gp_Pnt;
class BRepAdaptor_Surface;
class IntTools_CArray1OfReal;
class IntTools_CommonPrt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The  class  provides  Edge/Face  algorithm  to  determine <br>
//!         common  parts  between edge and face in  3-d space. <br>
//!          Common  parts can be :  Vertices  or Edges. <br>
//! <br>
class IntTools_EdgeFace  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Empty Constructor <br>
Standard_EXPORT IntTools_EdgeFace();


//! Initializes algorithm by the edge anEdge <br>
Standard_EXPORT   void SetEdge(const TopoDS_Edge& anEdge) ;


//! Initializes algorithm by edge tolerance <br>
Standard_EXPORT   void SetTolE(const Standard_Real aTolEdge1) ;


//! Initializes algorithm by the face aFace <br>
Standard_EXPORT   void SetFace(const TopoDS_Face& aFace) ;


//! Initializes algorithm by face tolerance <br>
Standard_EXPORT   void SetTolF(const Standard_Real aTolFace) ;


//! Initializes algorithm by discretization value <br>
Standard_EXPORT   void SetDiscretize(const Standard_Integer aDiscret) ;


//! Initializes algorithm by deflection value <br>
Standard_EXPORT   void SetDeflection(const Standard_Real aDeflection) ;


//! Initializes algorithm by parameter tolerance <br>
Standard_EXPORT   void SetEpsilonT(const Standard_Real anEpsT) ;


//! Initializes algorithm by distance tolerance <br>
Standard_EXPORT   void SetEpsilonNull(const Standard_Real anEpsNull) ;


//! Sets boundaries for edge. <br>
//! The algorithm processes edge inside these boundaries. <br>
Standard_EXPORT   void SetRange(const IntTools_Range& aRange) ;


//! Sets boundaries for edge. <br>
//! The algorithm processes edge inside these boundaries. <br>
Standard_EXPORT   void SetRange(const Standard_Real aFirst,const Standard_Real aLast) ;


//! Set container of projection algorithms <br>
Standard_EXPORT   void SetContext(const IntTools_PContext& theContext) ;


//! Launches the process <br>
Standard_EXPORT   void Perform() ;


//! Returns true if computation was done <br>
//! successfully, otherwise returns false <br>
Standard_EXPORT   Standard_Boolean IsDone() const;


//! Returns code of completion <br>
//! 0 - means successful completion <br>
//! 1 - the process was not started <br>
//! 2,3,4,5 - invalid source data for the algorithm <br>
//! 6 - discretization failed <br>
//! 7 - no projectable ranges found <br>
//! 11 - distance computing error <br>
Standard_EXPORT   Standard_Integer ErrorStatus() const;


//! Returns results <br>
Standard_EXPORT  const IntTools_SequenceOfCommonPrts& CommonParts() const;


//! Returns boundaries for edge <br>
Standard_EXPORT  const IntTools_Range& Range() const;


//! <br>
Standard_EXPORT static  Standard_Boolean IsEqDistance(const gp_Pnt& aP,const BRepAdaptor_Surface& aS,const Standard_Real aT,Standard_Real& aD) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void CheckData() ;


Standard_EXPORT   void Prepare() ;


Standard_EXPORT   Standard_Boolean IsProjectable(const Standard_Real t) const;


Standard_EXPORT   void FindProjectableRoot(const Standard_Real t1,const Standard_Real t2,const Standard_Integer f1,const Standard_Integer f2,Standard_Real& tRoot) ;


Standard_EXPORT   Standard_Real DistanceFunction(const Standard_Real t) ;


Standard_EXPORT   Standard_Real DerivativeFunction(const Standard_Real t) ;


Standard_EXPORT   void PrepareArgsFuncArrays(const Standard_Real t1,const Standard_Real t2) ;


Standard_EXPORT   void AddDerivativePoints(const IntTools_CArray1OfReal& t,const IntTools_CArray1OfReal& f) ;


Standard_EXPORT   Standard_Real FindSimpleRoot(const Standard_Integer IP,const Standard_Real ta,const Standard_Real tb,const Standard_Real fA) ;


Standard_EXPORT   Standard_Real FindGoldRoot(const Standard_Real ta,const Standard_Real tb,const Standard_Real coeff) ;


Standard_EXPORT   Standard_Integer MakeType(IntTools_CommonPrt& aCP) ;


Standard_EXPORT   void IsIntersection(const Standard_Real ta,const Standard_Real tb) ;


Standard_EXPORT   void FindDerivativeRoot(const IntTools_CArray1OfReal& t,const IntTools_CArray1OfReal& f) ;


Standard_EXPORT   void RemoveIdenticalRoots() ;


Standard_EXPORT   Standard_Boolean CheckTouch(const IntTools_CommonPrt& aCP,Standard_Real& aTX) ;


Standard_EXPORT   Standard_Boolean CheckTouchVertex(const IntTools_CommonPrt& aCP,Standard_Real& aTX) ;


 // Fields PRIVATE
 //
TopoDS_Edge myEdge;
TopoDS_Face myFace;
Standard_Real myTolE;
Standard_Real myTolF;
Standard_Integer myDiscret;
Standard_Real myEpsT;
Standard_Real myEpsNull;
Standard_Real myDeflection;
BRepAdaptor_Curve myC;
Standard_Real myTmin;
Standard_Real myTmax;
BRepAdaptor_Surface myS;
Standard_Real myCriteria;
Standard_Boolean myIsDone;
Standard_Integer myErrorStatus;
IntTools_PContext myContext;
IntTools_SequenceOfRanges myProjectableRanges;
IntTools_FClass2d myFClass2d;
IntTools_CArray1OfReal myFuncArray;
IntTools_CArray1OfReal myArgsArray;
IntTools_SequenceOfRoots mySequenceOfRoots;
IntTools_SequenceOfCommonPrts mySeqOfCommonPrts;
Standard_Real myPar1;
Standard_Boolean myParallel;
Standard_Boolean myAllNullFlag;
IntTools_Range myRange;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
