// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TFunction_Driver_HeaderFile
#define _TFunction_Driver_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TFunction_Driver_HeaderFile
#include <Handle_TFunction_Driver.hxx>
#endif

#ifndef _TDF_Label_HeaderFile
#include <TDF_Label.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TDF_Label;
class TFunction_Logbook;
class TDF_LabelList;


//! This  driver  class provide  services  around function <br>
//!          execution.   One instance of  this class is  built for <br>
//!          the whole  session.    The driver  is bound   to   the <br>
//!          DriverGUID in the DriverTable class. <br>
//!          It allows you to create classes which inherit from <br>
//!          this abstract class. <br>
//!          These subclasses identify the various algorithms <br>
//!          which can be applied to the data contained in the <br>
//!          attributes of sub-labels of a model. <br>
//!          A single instance of this class and each of its <br>
//!          subclasses is built for the whole session. <br>
class TFunction_Driver : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Initializes the label L for this function prior to its  execution. <br>
Standard_EXPORT   void Init(const TDF_Label& L) ;
//! Returns the label of the driver for this function. <br>
  TDF_Label Label() const;

//! Validates labels of a function  in <log>. <br>
//! This function is the one initialized in this function driver. <br>
//! Warning <br>
//! In regeneration mode, the solver must call this <br>
//! method even if the function is not executed. <br>//! execution of function <br>
//!          ===================== <br>
Standard_EXPORT virtual  void Validate(TFunction_Logbook& log) const;

//! Analyzes the labels in the logbook log. <br>
//! Returns true if attributes have been modified. <br>
//! If the function label itself has been modified, the function must be executed. <br>
Standard_EXPORT virtual  Standard_Boolean MustExecute(const TFunction_Logbook& log) const;

//! Executes the function in this function driver and <br>
//! puts the impacted labels in the logbook log. <br>//! arguments & results of functions <br>
//!          ================================ <br>
Standard_EXPORT virtual  Standard_Integer Execute(TFunction_Logbook& log) const = 0;

//! The method fills-in the list by labels, <br>
//!          where the arguments of the function are located. <br>
Standard_EXPORT virtual  void Arguments(TDF_LabelList& args) const;

//! The method fills-in the list by labels, <br>
//!          where the results of the function are located. <br>
Standard_EXPORT virtual  void Results(TDF_LabelList& res) const;
//Standard_EXPORT ~TFunction_Driver();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 

//! initialisation of the driver <br>
//!          ============================ <br>
Standard_EXPORT TFunction_Driver();


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TDF_Label myLabel;


};


#include <TFunction_Driver.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
