// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Units_HeaderFile
#define _Units_HeaderFile

#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Handle_Units_UnitsDictionary_HeaderFile
#include <Handle_Units_UnitsDictionary.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Units_Quantity_HeaderFile
#include <Handle_Units_Quantity.hxx>
#endif
#ifndef _Handle_Units_Lexicon_HeaderFile
#include <Handle_Units_Lexicon.hxx>
#endif
#ifndef _Handle_Units_Dimensions_HeaderFile
#include <Handle_Units_Dimensions.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class Units_UnitsDictionary;
class Units_Quantity;
class Units_Lexicon;
class Units_Dimensions;
class Units_StrgSequence;
class Units_StringsSequence;
class Units_Dimensions;
class Units_Unit;
class Units_UtsSequence;
class Units_UnitsSequence;
class Units_ShiftedUnit;
class Units_Token;
class Units_ShiftedToken;
class Units_TksSequence;
class Units_TokensSequence;
class Units_Quantity;
class Units_QtsSequence;
class Units_QuantitiesSequence;
class Units_UnitsDictionary;
class Units_UnitsSystem;
class Units_Explorer;
class Units_Sentence;
class Units_MathSentence;
class Units_UnitSentence;
class Units_Lexicon;
class Units_UnitsLexicon;
class Units_Measurement;
class Units_SequenceNodeOfStrgSequence;
class Units_SequenceNodeOfUtsSequence;
class Units_SequenceNodeOfTksSequence;
class Units_SequenceNodeOfQtsSequence;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This  package provides all the  facilities  to create <br>
//!          and question a dictionary of  units,  and also  to <br>
//!          manipulate measurements which are real values with <br>
//!          units. <br>
class Units  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Defines the location of the file containing all the <br>
//!          information useful in creating the dictionary of all <br>
//!          the units known to the system. <br>
Standard_EXPORT static  void UnitsFile(const Standard_CString afile) ;

//! Defines the location of the file containing the lexicon <br>
//!          useful in manipulating composite units. <br>
Standard_EXPORT static  void LexiconFile(const Standard_CString afile) ;

//! Returns a unique instance of the dictionary of units. <br>
//!          If <amode> is True, then it forces the recomputation of <br>
//!          the dictionary of units. <br>
Standard_EXPORT static  Handle_Units_UnitsDictionary DictionaryOfUnits(const Standard_Boolean amode = Standard_False) ;

//! Returns a unique quantity instance corresponding to <aquantity>. <br>
Standard_EXPORT static  Handle_Units_Quantity Quantity(const Standard_CString aquantity) ;

//! Returns the first quantity string founded from the unit <aUnit>. <br>
Standard_EXPORT static  Standard_CString FirstQuantity(const Standard_CString aunit) ;

//! Returns a unique instance of the Units_Lexicon. <br>
//!          If <amode> is True, it forces the recomputation of <br>
//!          the dictionary of units, and by consequence the <br>
//!          completion of the Units_Lexicon. <br>
Standard_EXPORT static  Handle_Units_Lexicon LexiconUnits(const Standard_Boolean amode = Standard_True) ;

//! Return a unique instance of LexiconFormula. <br>
Standard_EXPORT static  Handle_Units_Lexicon LexiconFormula() ;

//! Returns always the same instance of Dimensions. <br>
Standard_EXPORT static  Handle_Units_Dimensions NullDimensions() ;

//! Converts <avalue> expressed in <afirstunit> into the <asecondunit>. <br>
Standard_EXPORT static  Standard_Real Convert(const Standard_Real avalue,const Standard_CString afirstunit,const Standard_CString asecondunit) ;


Standard_EXPORT static  Standard_Real ToSI(const Standard_Real aData,const Standard_CString aUnit) ;


Standard_EXPORT static  Standard_Real ToSI(const Standard_Real aData,const Standard_CString aUnit,Handle(Units_Dimensions)& aDim) ;


Standard_EXPORT static  Standard_Real FromSI(const Standard_Real aData,const Standard_CString aUnit) ;


Standard_EXPORT static  Standard_Real FromSI(const Standard_Real aData,const Standard_CString aUnit,Handle(Units_Dimensions)& aDim) ;

//! return the dimension associated to the Type <br>
Standard_EXPORT static  Handle_Units_Dimensions Dimensions(const Standard_CString aType) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class Units_StrgSequence;
friend class Units_StringsSequence;
friend class Units_Dimensions;
friend class Units_Unit;
friend class Units_UtsSequence;
friend class Units_UnitsSequence;
friend class Units_ShiftedUnit;
friend class Units_Token;
friend class Units_ShiftedToken;
friend class Units_TksSequence;
friend class Units_TokensSequence;
friend class Units_Quantity;
friend class Units_QtsSequence;
friend class Units_QuantitiesSequence;
friend class Units_UnitsDictionary;
friend class Units_UnitsSystem;
friend class Units_Explorer;
friend class Units_Sentence;
friend class Units_MathSentence;
friend class Units_UnitSentence;
friend class Units_Lexicon;
friend class Units_UnitsLexicon;
friend class Units_Measurement;
friend class Units_SequenceNodeOfStrgSequence;
friend class Units_SequenceNodeOfUtsSequence;
friend class Units_SequenceNodeOfTksSequence;
friend class Units_SequenceNodeOfQtsSequence;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
