// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_Gauss_HeaderFile
#define _math_Gauss_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _math_Matrix_HeaderFile
#include <math_Matrix.hxx>
#endif
#ifndef _math_IntegerVector_HeaderFile
#include <math_IntegerVector.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class math_NotSquare;
class Standard_DimensionError;
class StdFail_NotDone;
class math_Matrix;
class math_Vector;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! This class implements the Gauss LU decomposition (Crout algorithm) <br>
//! with partial pivoting (rows interchange) of a square matrix and <br>
//! the different possible derived calculation : <br>
//!    - solution of a set of linear equations. <br>
//!    - inverse of a matrix. <br>
//!    - determinant of a matrix. <br>
class math_Gauss  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


//! Given an input n X n matrix A this constructor performs its LU <br>
//! decomposition with partial pivoting (interchange of rows). <br>
//! This LU decomposition is stored internally and may be used to <br>
//! do subsequent calculation. <br>
//! If the largest pivot found is less than MinPivot the matrix A is <br>
//! considered as singular. <br>
//! Exception NotSquare is raised if A is not a square matrix. <br>
Standard_EXPORT math_Gauss(const math_Matrix& A,const Standard_Real MinPivot = 1.0e-20);
//! Returns true if the computations are successful, otherwise returns false <br>
  Standard_Boolean IsDone() const;


//! Given the input Vector B this routine returns the solution X of the set <br>
//! of linear equations A . X = B. <br>
//! Exception NotDone is raised if the decomposition of A was not done <br>
//! successfully. <br>
//! Exception DimensionError is raised if the range of B is not <br>
//! equal to the number of rows of A. <br>
Standard_EXPORT   void Solve(const math_Vector& B,math_Vector& X) const;


//! Given the input Vector B this routine solves the set of linear <br>
//! equations A . X = B. B is replaced by the vector solution X. <br>
//! Exception NotDone is raised if the decomposition of A was not done <br>
//! successfully. <br>
//! Exception DimensionError is raised if the range of B is not <br>
//! equal to the number of rows of A. <br>
Standard_EXPORT   void Solve(math_Vector& B) const;


//! This routine returns the value of the determinant of the previously LU <br>
//! decomposed matrix A. <br>
//! Exception NotDone may be raised if the decomposition of A was not done <br>
//! successfully, zero is returned if the matrix A was considered as singular. <br>
Standard_EXPORT   Standard_Real Determinant() const;


//! This routine outputs Inv the inverse of the previously LU decomposed <br>
//! matrix A. <br>
//! Exception DimensionError is raised if the ranges of B are not <br>
//! equal to the ranges of A. <br>
Standard_EXPORT   void Invert(math_Matrix& Inv) const;

//! Prints on the stream o information on the current state <br>
//!          of the object. <br>
//!          Is used to redefine the operator <<. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Standard_Boolean Singular;
math_Matrix LU;
math_IntegerVector Index;
Standard_Real D;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean Done;


};


#include <math_Gauss.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
