// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _math_GaussLeastSquare_HeaderFile
#define _math_GaussLeastSquare_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _math_Matrix_HeaderFile
#include <math_Matrix.hxx>
#endif
#ifndef _math_IntegerVector_HeaderFile
#include <math_IntegerVector.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class StdFail_NotDone;
class Standard_DimensionError;
class math_Matrix;
class math_Vector;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! This class implements the least square solution of a set of <br>
//! n linear equations of m unknowns (n >= m) using the gauss LU <br>
//! decomposition algorithm. <br>
//! This algorithm is more likely subject to numerical instability <br>
//!  than math_SVD. <br>
class math_GaussLeastSquare  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Given an input n X m matrix A with n >= m this constructor <br>
//!          performs the LU decomposition with partial pivoting <br>
//!          (interchange of rows) of the matrix AA = A.Transposed() * A; <br>
//! 	        This LU decomposition is stored internally and may be used <br>
//! 	        to do subsequent calculation. <br>
//!          If the largest pivot found is less than MinPivot the matrix <A> <br>
//!          is considered as singular. <br>
Standard_EXPORT math_GaussLeastSquare(const math_Matrix& A,const Standard_Real MinPivot = 1.0e-20);
//! Returns true if the computations are successful, otherwise returns false.e <br>
  Standard_Boolean IsDone() const;

//! Given the input Vector <B> this routine solves the set <br>
//!          of linear equations A . X = B. <br>
//!          Exception NotDone is raised if the decomposition of A was <br>
//!          not done successfully. <br>
//!          Exception DimensionError is raised if the range of B Inv is <br>
//!          not equal to the rowrange of A. <br>
//!          Exception DimensionError is raised if the range of X Inv is <br>
//!          not equal to the colrange of A. <br>
Standard_EXPORT   void Solve(const math_Vector& B,math_Vector& X) const;

//! Prints on the stream o information on the current state <br>
//!          of the object. <br>
//!          Is used to redefine the operator <<. <br>
Standard_EXPORT   void Dump(Standard_OStream& o) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //
Standard_Boolean Singular;
math_Matrix LU;
math_Matrix A2;
math_IntegerVector Index;
Standard_Real D;


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean Done;


};


#include <math_GaussLeastSquare.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
