// File         OpenGl_GraphicDriver_713.cxx
// Created      22-10-01
// Author       SAV


// 09/07/02     SAV  - merged with file	Graphic3d_GraphicDriver_713.cxx created	16/06/2000 by ATS  for G005 study.
//Following routines are entry points for creation of PARRAY primitives for (used for presentation).

#include <Graphic3d_GraphicDriver.jxx>
#include <Aspect_DriverDefinitionError.hxx>

#define VIRTUAL

extern "C" {
#include <InterfaceGraphic_Cextern.hxx>
}

#define  BUC61044    /* 25/10/01 SAV ; added functionality to control gl depth testing
			from higher API */
#define  BUC61045    /* 25/10/01 SAV ; added functionality to control gl lighting 
			from higher API */


#ifdef VIRTUAL
void Graphic3d_GraphicDriver::SetDepthTestEnabled( const Graphic3d_CView&, const Standard_Boolean ) const {
#else
void Graphic3d_GraphicDriver
::SetDepthTestEnabled( const Graphic3d_CView& view,
		       const Standard_Boolean isEnabled ) const
{
#ifdef BUC61044
  call_togl_depthtest( &view, isEnabled );
#endif
#endif
}

#ifdef VIRTUAL
Standard_Boolean Graphic3d_GraphicDriver::IsDepthTestEnabled( const Graphic3d_CView& ) const {
  return Standard_True;
#else
Standard_Boolean Graphic3d_GraphicDriver
::IsDepthTestEnabled( const Graphic3d_CView& view ) const
{
#ifdef BUC61044
  if ( call_togl_isdepthtest( &view ) )
    return Standard_True;
#endif
  return Standard_False;
#endif
}

void Graphic3d_GraphicDriver::ReadDepths( const Graphic3d_CView&,
                                          const Standard_Integer,
                                          const Standard_Integer,
                                          const Standard_Integer,
                                          const Standard_Integer,
                                          const Standard_Address ) const
{
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::SetGLLightEnabled( const Graphic3d_CView&, const Standard_Boolean ) const { 
#else
void Graphic3d_GraphicDriver
:: SetGLLightEnabled( const Graphic3d_CView& view,
		      const Standard_Boolean isEnabled ) const
{
#ifdef BUC61045
  call_togl_gllight( &view, isEnabled );
#endif
#endif
}

#ifdef VIRTUAL
Standard_Boolean Graphic3d_GraphicDriver::IsGLLightEnabled( const Graphic3d_CView& ) const {
  return Standard_True;
#else
Standard_Boolean Graphic3d_GraphicDriver
::IsGLLightEnabled( const Graphic3d_CView& view ) const
{
#ifdef BUC61045
  if ( call_togl_isgllight( &view ) )
    return Standard_True;
#endif
  return Standard_False;
#endif
}


#ifdef VIRTUAL
void Graphic3d_GraphicDriver :: PrimitiveArray ( const Graphic3d_CGroup&,const Graphic3d_PrimitiveArray&,const Standard_Boolean) {
}
#else
void Graphic3d_GraphicDriver :: PrimitiveArray ( const Graphic3d_CGroup& ACGroup,
		const Graphic3d_PrimitiveArray& parray,
		const Standard_Boolean EvalMinMax) {
        Graphic3d_CGroup MyCGroup = ACGroup;

        if( parray ) call_togl_parray (&MyCGroup,parray);
}
#endif


#ifdef VIRTUAL
void Graphic3d_GraphicDriver :: UserDraw ( const Graphic3d_CGroup&,
                                           const Graphic3d_CUserDraw& ) {
}
#else
void Graphic3d_GraphicDriver :: UserDraw ( const Graphic3d_CGroup& ACGroup,
                                           const Graphic3d_CUserDraw& AUserDraw ) {
        Graphic3d_CGroup MyCGroup = ACGroup;
        Graphic3d_CUserDraw MyUserDraw = AUserDraw;

        call_togl_userdraw (&MyCGroup,&MyUserDraw);
}
#endif
