
#define VIRTUAL

// File		Graphic3d_GraphicDriver_Layer.cxx
// Created	Mardi 3 novembre 1998
// Author	CAL
//      02.15.100 : JR : Clutter

//-Copyright	MatraDatavision 1998

//-Version	

//-Design	Declaration des variables specifiques aux Drivers

//-Warning	Un driver encapsule les Pex et OpenGl drivers

//-References	

//-Language	C++ 2.0

//-Declarations

// for the class
#include <Graphic3d_GraphicDriver.jxx>

#include <Aspect_DriverDefinitionError.hxx>

extern "C" {
#include <InterfaceGraphic_Cextern.hxx>
}

//-Aliases

//-Global data definitions

//-Methods, in order

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Layer (Aspect_CLayer2d& ) {
#else
void Graphic3d_GraphicDriver::Layer (Aspect_CLayer2d& ACLayer) {

Aspect_CLayer2d MyCLayer = ACLayer;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_layer2d");
		PrintInteger ("ALayerType", int (ACLayer.layerType));
	}
	call_togl_layer2d (&MyCLayer);
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::RemoveLayer (const Aspect_CLayer2d& ) {
#else
void Graphic3d_GraphicDriver::RemoveLayer (const Aspect_CLayer2d& ACLayer) {

Aspect_CLayer2d MyCLayer = ACLayer;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_removelayer2d");
		PrintInteger ("ALayerType", int (ACLayer.layerType));
	}
	call_togl_removelayer2d (&MyCLayer);
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::BeginLayer (const Aspect_CLayer2d& ) {
#else
void Graphic3d_GraphicDriver::BeginLayer (const Aspect_CLayer2d& ACLayer) {

Aspect_CLayer2d MyCLayer = ACLayer;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_begin_layer2d");
		PrintInteger ("ALayerType", int (ACLayer.layerType));
	}
	call_togl_begin_layer2d (&MyCLayer);
#endif
}

void Graphic3d_GraphicDriver::BeginPolygon2d () {
#ifndef VIRTUAL

	if (MyTraceLevel) {
		PrintFunction ("call_togl_begin_polygon2d");
	}
	call_togl_begin_polygon2d ();
#endif
}

void Graphic3d_GraphicDriver::BeginPolyline2d () {
#ifndef VIRTUAL

	if (MyTraceLevel) {
		PrintFunction ("call_togl_begin_polyline2d");
	}
	call_togl_begin_polyline2d ();
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::ClearLayer (const Aspect_CLayer2d& ) {
#else
void Graphic3d_GraphicDriver::ClearLayer (const Aspect_CLayer2d& ACLayer) {

Aspect_CLayer2d MyCLayer = ACLayer;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_clear_layer2d");
		PrintInteger ("ALayerType", int (ACLayer.layerType));
	}
	call_togl_clear_layer2d (&MyCLayer);
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Draw (const Standard_ShortReal , const Standard_ShortReal ) {
#else
void Graphic3d_GraphicDriver::Draw (const Standard_ShortReal X, const Standard_ShortReal Y) {

	if (MyTraceLevel) {
		PrintFunction ("call_togl_draw2d");
		PrintShortReal ("X", X);
		PrintShortReal ("Y", Y);
	}
	call_togl_draw2d (X, Y);
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Edge (const Standard_ShortReal , const Standard_ShortReal ) {
#else
void Graphic3d_GraphicDriver::Edge (const Standard_ShortReal X, const Standard_ShortReal Y) {

	if (MyTraceLevel) {
		PrintFunction ("call_togl_edge2d");
		PrintShortReal ("X", X);
		PrintShortReal ("Y", Y);
	}
	call_togl_edge2d (X, Y);
#endif
}

void Graphic3d_GraphicDriver::EndLayer () {
#ifndef VIRTUAL

	if (MyTraceLevel) {
		PrintFunction ("call_togl_end_layer2d");
	}
	call_togl_end_layer2d ();
#endif
}

void Graphic3d_GraphicDriver::EndPolygon2d () {
#ifndef VIRTUAL

	if (MyTraceLevel) {
		PrintFunction ("call_togl_end_polygon2d");
	}
	call_togl_end_polygon2d ();
#endif
}

void Graphic3d_GraphicDriver::EndPolyline2d () {
#ifndef VIRTUAL

	if (MyTraceLevel) {
		PrintFunction ("call_togl_end_polyline2d");
	}
	call_togl_end_polyline2d ();
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Move (const Standard_ShortReal , const Standard_ShortReal ) {
#else
void Graphic3d_GraphicDriver::Move (const Standard_ShortReal X, const Standard_ShortReal Y) {

	if (MyTraceLevel) {
		PrintFunction ("call_togl_move2d");
		PrintShortReal ("X", X);
		PrintShortReal ("Y", Y);
	}
	call_togl_move2d (X, Y);
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Rectangle (const Standard_ShortReal , const Standard_ShortReal , const Standard_ShortReal , const Standard_ShortReal ) {
#else
void Graphic3d_GraphicDriver::Rectangle (const Standard_ShortReal X, const Standard_ShortReal Y, const Standard_ShortReal Width, const Standard_ShortReal Height) {

	if (MyTraceLevel) {
		PrintFunction ("call_togl_rectangle2d");
		PrintShortReal ("X", X);
		PrintShortReal ("Y", Y);
		PrintShortReal ("Width", Width);
		PrintShortReal ("Height", Height);
	}
	call_togl_rectangle2d (X, Y, Width, Height);
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::SetColor (const Standard_ShortReal , const Standard_ShortReal , const Standard_ShortReal ) {
#else
void Graphic3d_GraphicDriver::SetColor (const Standard_ShortReal R, const Standard_ShortReal G, const Standard_ShortReal B) {

	if (MyTraceLevel) {
		PrintFunction ("call_togl_set_color");
		PrintShortReal ("R", R);
		PrintShortReal ("G", G);
		PrintShortReal ("B", B);
	}
	call_togl_set_color (R, G, B);
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::SetTransparency (const Standard_ShortReal ) {
#else
void Graphic3d_GraphicDriver::SetTransparency (const Standard_ShortReal aTransparency) {

	if (MyTraceLevel) {
		PrintFunction ("call_togl_set_transparency");
		PrintShortReal ("Transparency", aTransparency);
	}
	call_togl_set_transparency (aTransparency);
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::UnsetTransparency () {
#else
void Graphic3d_GraphicDriver::UnsetTransparency () {

	if (MyTraceLevel) {
		PrintFunction ("call_togl_unset_transparency");
	}
	call_togl_unset_transparency ();
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::SetLineAttributes (const Standard_Integer , const Standard_ShortReal ) {
#else
void Graphic3d_GraphicDriver::SetLineAttributes (const Standard_Integer Type, const Standard_ShortReal Width) {

	if (MyTraceLevel) {
		PrintFunction ("call_togl_set_line_attributes");
		PrintInteger ("Type", Type);
		PrintShortReal ("Width", Width);
	}
	call_togl_set_line_attributes (Type, Width);
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::SetTextAttributes (const Standard_Integer , const Standard_Integer , const Standard_ShortReal , const Standard_ShortReal , const Standard_ShortReal ) {
#else
void Graphic3d_GraphicDriver::SetTextAttributes (const Standard_Integer AFont, const Standard_Integer AType, const Standard_ShortReal R, const Standard_ShortReal G, const Standard_ShortReal B) {

	if (MyTraceLevel) {
		PrintFunction ("call_togl_set_text_attributes");
		PrintInteger ("Font", AFont);
		PrintInteger ("Type", AType);
		PrintShortReal ("R", R);
		PrintShortReal ("G", G);
		PrintShortReal ("B", B);
	}
	call_togl_set_text_attributes (AFont, AType, R, G, B);
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Text (const Standard_CString , const Standard_ShortReal , const Standard_ShortReal , const Standard_ShortReal ) {
#else
void Graphic3d_GraphicDriver::Text (const Standard_CString AText, const Standard_ShortReal X, const Standard_ShortReal Y, const Standard_ShortReal AHeight) {

	if (MyTraceLevel) {
		PrintFunction ("call_togl_text2d");
		PrintString ("Text", AText);
		PrintShortReal ("X", X);
		PrintShortReal ("Y", Y);
		PrintShortReal ("AHeight", AHeight);
	}
	call_togl_text2d ((char *) AText, X, Y, AHeight);
#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::TextSize (const Standard_CString , const Standard_ShortReal , Standard_ShortReal& , Standard_ShortReal& , Standard_ShortReal& ) const {
#else
void Graphic3d_GraphicDriver::TextSize (const Standard_CString AText,  const Standard_ShortReal AHeight, Standard_ShortReal& AWidth, Standard_ShortReal& AnAscent, Standard_ShortReal& ADescent) const {

	call_togl_textsize2d ((char *) AText, AHeight, &AWidth, &AnAscent, &ADescent);
	if (MyTraceLevel) {
		PrintFunction ("call_togl_textsize2d");
		PrintString ("Text", AText);
		PrintShortReal ("AHeight", AHeight);
		PrintShortReal ("AWidth", AWidth);
		PrintShortReal ("AnAscent", AnAscent);
		PrintShortReal ("ADescent", ADescent);
	}
#endif
}
