/************************************************************************/
/* Includes                                                             */
/************************************************************************/

#include <OpenGl_GraphicDriver.jxx>
#include <OpenGl_gl2ps.h>

/************************************************************************/
/* Print Methods                                                        */
/************************************************************************/

#ifdef VIRTUAL
void OpenGl_GraphicDriver::Export( const Standard_CString FileName,
                                   const Graphic3d_ExportFormat Format,
				   const Graphic3d_SortType aSortType,
                                   const Standard_Integer W,
                                   const Standard_Integer H,
                                   const Graphic3d_CView& View,
                                   const Aspect_CLayer2d& Under,
                                   const Aspect_CLayer2d& Over,
                                   const Standard_Real Precision,
                                   const Standard_Address ProgressBarFunc,
                                   const Standard_Address ProgressObject )
{
#else
void OpenGl_GraphicDriver::Export( const Standard_CString FileName,
                                   const Graphic3d_ExportFormat Format,
 				   const Graphic3d_SortType aSortType,
                                   const Standard_Integer W,
                                   const Standard_Integer H,
                                   const Graphic3d_CView& View,
                                   const Aspect_CLayer2d& Under,
                                   const Aspect_CLayer2d& Over,
                                   const Standard_Real Precision,
                                   const Standard_Address ProgressBarFunc,
                                   const Standard_Address ProgressObject )
{
    Standard_Integer mode = -1;
    Standard_Integer sortType = Graphic3d_ST_BSP_Tree;
    switch( Format )
    {
        case Graphic3d_EF_PostScript:
            mode = GL2PS_PS;
            break;
        case Graphic3d_EF_EnhPostScript:
            mode = GL2PS_EPS;
            break;
        case Graphic3d_EF_EnhMetaFile:
            mode = GL2PS_EMF;
            break;
        case Graphic3d_EF_PDF:
            mode = GL2PS_PDF;
            break;
    }

    switch( aSortType )
    {
        case Graphic3d_ST_Simple:
            sortType = GL2PS_SIMPLE_SORT;
            break;
        case Graphic3d_ST_BSP_Tree:
            sortType = GL2PS_BSP_SORT;
            break;
    }     

    GLint viewport[4];
    viewport[0] = 0;
    viewport[1] = 0;
    viewport[2] = W;
    viewport[3] = H;

    GLint buffersize = 1024*1024;

    
    while( buffersize>0 )
    {
        gl2psBeginPage( "", "", viewport, mode, sortType,
                        GL2PS_DRAW_BACKGROUND | GL2PS_OCCLUSION_CULL | GL2PS_BEST_ROOT/* | GL2PS_SIMPLE_LINE_OFFSET*/,
                        GL_RGBA, 0, NULL,
                        0, 0, 0, buffersize, FileName, Precision, ( PB_FUNC )ProgressBarFunc, ProgressObject );

        Redraw( View, Under, Over );

        GLint num = gl2psEndPage();
        if( num==GL2PS_OVERFLOW )
            buffersize *= 2;
        else
            break;
    }

#endif
}
