// File:	TDataStd_Shape.cxx
// Created:	Thu Jul 1 10:39:43 1999
// Author:	Sergey RUIN
//		<s-ruin@nnov.matra-dtv.fr>


#include <TDataStd_Shape.ixx>
#include <TDataStd.hxx>
#include <TDF_Label.hxx>
#include <BRep_Builder.hxx>
#include <TopoDS_Solid.hxx>
#include <TNaming_Builder.hxx>
#include <TNaming_NamedShape.hxx>
#include <TNaming_Tool.hxx>
#include <TNaming.hxx>

#define OCC2932
//=======================================================================
//function : Find
//purpose  : 
//=======================================================================

Standard_Boolean TDataStd_Shape::Find (const TDF_Label& current,
				      Handle(TDataStd_Shape)& S) 
{  
  TDF_Label L = current;
  Handle(TDataStd_Shape) SA;
  if (L.IsNull()) return Standard_False; 
  while (1) {
    if(L.FindAttribute(TDataStd_Shape::GetID(), SA))  break;
    L = L.Father();
    if (L.IsNull()) break; 
  }
  
  
  if (!SA.IsNull()) { 
    S = SA;
    return Standard_True; 
  }
  return Standard_False; 
}


//=======================================================================
//function : New
//purpose  : 
//=======================================================================

Handle(TDataStd_Shape) TDataStd_Shape::New (const TDF_Label& label)
{  
  if (label.HasAttribute()) {
    Standard_DomainError::Raise("TDataStd_Directory::New : not an empty label");
  }
  Handle(TDataStd_Shape) A = new TDataStd_Shape ();  
  label.AddAttribute(A);                     
  return A;
}

//=======================================================================
//function : Set
//purpose  : 
//=======================================================================

Handle(TDataStd_Shape) TDataStd_Shape::Set (const TDF_Label& label, const TopoDS_Shape& shape)
{
  Handle(TDataStd_Shape) A;  
  if (!label.FindAttribute(TDataStd_Shape::GetID(),A)) { 
    A = TDataStd_Shape::New (label);
  }  

#ifdef OCC2932
  Handle(TNaming_NamedShape) aNS;
  if(label.FindAttribute(TNaming_NamedShape::GetID(), aNS)) {
    if(!aNS->Get().IsNull())
      if(aNS->Get() == shape)
	return A;
  }
#endif

  TNaming_Builder B(label);
  B.Generated(shape);
  return A; 
}

//=======================================================================
//function : Get
//purpose  : 
//=======================================================================

TopoDS_Shape TDataStd_Shape::Get (const TDF_Label& label)
{
  TopoDS_Shape shape;

  Handle(TNaming_NamedShape) NS;
  if( label.FindAttribute(TNaming_NamedShape::GetID(), NS)) {
    shape = TNaming_Tool::GetShape(NS);
    return shape;
  }

  shape.Nullify();  
  return shape; 
}

//=======================================================================
//function : GetID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_Shape::GetID() 
{
  static Standard_GUID TDataStd_ShapeID("2a96b620-ec8b-11d0-bee7-080009dc3333");
  return TDataStd_ShapeID;
}

//=======================================================================
//function : TDataStd_Shape
//purpose  : 
//=======================================================================

TDataStd_Shape::TDataStd_Shape()
{
}

//=======================================================================
//function : ID
//purpose  : 
//=======================================================================

const Standard_GUID& TDataStd_Shape::ID() const
{ return GetID(); }


//=======================================================================
//function : NewEmpty
//purpose  : 
//=======================================================================

Handle(TDF_Attribute) TDataStd_Shape::NewEmpty () const
{  
  return new TDataStd_Shape(); 
}

//=======================================================================
//function : Restore
//purpose  : 
//=======================================================================

void TDataStd_Shape::Restore(const Handle(TDF_Attribute)& with) 
{  
}

//=======================================================================
//function : Paste
//purpose  : 
//=======================================================================

void TDataStd_Shape::Paste (const Handle(TDF_Attribute)& into,
			   const Handle(TDF_RelocationTable)& RT) const
{  
}

//=======================================================================
//function : References
//purpose  : 
//=======================================================================

void TDataStd_Shape::References (const Handle(TDF_DataSet)& DS) const
{  
}
 
//=======================================================================
//function : Dump
//purpose  : 
//=======================================================================

Standard_OStream& TDataStd_Shape::Dump (Standard_OStream& anOS) const
{  
  anOS << "Shape";
  return anOS;
}


