// TopologyPrimitivesDoc.cpp : implementation of the CTopologyPrimitivesDoc class
//

#include "stdafx.h"

#include "TopologyPrimitivesDoc.h"

#include "TopologyPrimitivesApp.h"
#include "ResultDialog.h"

#include "..\res\resource.h"

#include <AIS_ListOfInteractive.hxx>
#include <AIS_ListIteratorOfListOfInteractive.hxx>

/////////////////////////////////////////////////////////////////////////////
// CTopologyPrimitivesDoc

IMPLEMENT_DYNCREATE(CTopologyPrimitivesDoc, CDocument)

BEGIN_MESSAGE_MAP(CTopologyPrimitivesDoc, OCC_3dBaseDoc)
	//{{AFX_MSG_MAP(CTopologyPrimitivesDoc)
	ON_COMMAND(ID_BOX, OnBox)
	ON_COMMAND(ID_Cylinder, OnCylinder)
	ON_COMMAND(ID_CONE, OnCone)
	ON_COMMAND(ID_SPHERE, OnSphere)
	ON_COMMAND(ID_TORUS, OnTorus)
	ON_COMMAND(ID_WEDGE, OnWedge)
	ON_COMMAND(ID_PRISM, OnPrism)
	ON_COMMAND(ID_REVOL, OnRevol)
	ON_COMMAND(ID_PIPE, OnPipe)
	ON_COMMAND(ID_THRU, OnThru)
	ON_COMMAND(ID_EVOLVED, OnEvolved)
	ON_COMMAND(ID_DRAFT, OnDraft)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTopologyPrimitivesDoc construction/destruction

CTopologyPrimitivesDoc::CTopologyPrimitivesDoc()
{
	myAISContext->SetDisplayMode(AIS_Shaded,Standard_False);
}

CTopologyPrimitivesDoc::~CTopologyPrimitivesDoc()
{
}

/////////////////////////////////////////////////////////////////////////////
// CTopologyPrimitivesDoc diagnostics

#ifdef _DEBUG
void CTopologyPrimitivesDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CTopologyPrimitivesDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

void CTopologyPrimitivesDoc::OnBox() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	TopoDS_Shape B1 = BRepPrimAPI_MakeBox (200.,150.,100.);
	Handle(AIS_Shape) aBox1 = new AIS_Shape(B1);
	myAISContext->SetMaterial(aBox1,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->SetColor(aBox1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->Display(aBox1,Standard_False);
	TopoDS_Shape B2 = BRepPrimAPI_MakeBox (gp_Ax2(gp_Pnt(-200.,-80.,-70.),
											  gp_Dir(1.,2.,1.)),
										80.,90.,120.);
	Handle(AIS_Shape) aBox2 = new AIS_Shape(B2);
	myAISContext->SetMaterial(aBox2,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->SetColor(aBox2,Quantity_NOC_RED,Standard_False); 
	myAISContext->Display(aBox2,Standard_False);
	Fit();
    TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape B1 = BRepPrimAPI_MakeBox (200.,150.,100.); \n\
TopoDS_Shape B2 = BRepPrimAPI_MakeBox (gp_Ax2(gp_Pnt(-200.,-80.,-70.), \n\
                                          gp_Dir(1.,2.,1.)), \n\
                                   80.,90.,120.); \n\
		\n");
	PocessTextInDialog("Make a topological box", Message);
}

void CTopologyPrimitivesDoc::OnCylinder() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Shape C1 = BRepPrimAPI_MakeCylinder (50.,200.);
	Handle(AIS_Shape) aCyl1 = new AIS_Shape(C1);
	myAISContext->SetMaterial(aCyl1,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->SetColor(aCyl1,Quantity_NOC_RED,Standard_False); 
	myAISContext->Display(aCyl1,Standard_False);
	TopoDS_Shape C2 = BRepPrimAPI_MakeCylinder (gp_Ax2(gp_Pnt(200.,200.,0.),
												   gp_Dir(0.,0.,1.)),
											40.,110.,210.*PI180);
	Handle(AIS_Shape) aCyl2 = new AIS_Shape(C2);
	myAISContext->SetMaterial(aCyl2,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->SetColor(aCyl2,Quantity_NOC_MATRABLUE,Standard_False); 	
	myAISContext->Display(aCyl2,Standard_False);
	Fit();

    TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape C1 = BRepPrimAPI_MakeCylinder (50.,200.); \n\
TopoDS_Shape C2 = BRepPrimAPI_MakeCylinder (gp_Ax2(gp_Pnt(200.,200.,0.), \n\
                                        gp_Dir(0.,0.,1.)), \n\
                                        40.,110.,210.*PI180.); \n\
		\n");
	PocessTextInDialog("Make a cylinder", Message);
}


void CTopologyPrimitivesDoc::OnCone() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}
	TopoDS_Shape C1 = BRepPrimAPI_MakeCone (50.,25.,200.);
	Handle(AIS_Shape) ais1 = new AIS_Shape(C1);
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->SetColor(ais1,Quantity_NOC_MATRABLUE,Standard_False); 		
	myAISContext->Display(ais1,Standard_False);
	TopoDS_Shape C2 = BRepPrimAPI_MakeCone(gp_Ax2(gp_Pnt(100.,100.,0.),
												   gp_Dir(0.,0.,1.)),
											60.,0.,150.,210.*PI180);
	Handle(AIS_Shape) ais2 = new AIS_Shape(C2);
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->SetColor(ais2,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->Display(ais2,Standard_False);
	Fit();

    TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape C1 = BRepPrimAPI_MakeCone (50.,25.,200.); \n\
TopoDS_Shape C2 = BRepPrimAPI_MakeCone(gp_Ax2(gp_Pnt(100.,100.,0.), \n\
                                          gp_Dir(0.,0.,1.)), \n\
                                   605.,0.,150.,210.*PI180); \n\
		\n");
	PocessTextInDialog("Make a cone", Message);
}

void CTopologyPrimitivesDoc::OnSphere() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Shape S1 = BRepPrimAPI_MakeSphere(gp_Pnt(-200.,-250.,0.),80.);
	Handle(AIS_Shape) ais1 = new AIS_Shape(S1);
	myAISContext->SetColor(ais1,Quantity_NOC_AZURE,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais1,Standard_False);
	TopoDS_Shape S2 = BRepPrimAPI_MakeSphere(100.,120.*PI180);
	Handle(AIS_Shape) ais2 = new AIS_Shape(S2);
	myAISContext->SetColor(ais2,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais2,Standard_False);
	TopoDS_Shape S3 = BRepPrimAPI_MakeSphere(gp_Pnt(200.,250.,0.),100.,
										 -60.*PI180, 60.*PI180);
	Handle(AIS_Shape) ais3 = new AIS_Shape(S3);
	myAISContext->SetColor(ais3,Quantity_NOC_RED,Standard_False); 
	myAISContext->SetMaterial(ais3,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais3,Standard_False);
	TopoDS_Shape S4 = BRepPrimAPI_MakeSphere(gp_Pnt(0.,0.,-300.),150.,
										 -45.*PI180, 45.*PI180, 45.*PI180);
	Handle(AIS_Shape) ais4 = new AIS_Shape(S4);
	myAISContext->SetColor(ais4,Quantity_NOC_MATRABLUE,Standard_False); 
	myAISContext->SetMaterial(ais4,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais4,Standard_False);
	Fit();

    TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape S1 = BRepPrimAPI_MakeSphere(gp_Pnt(-200.,-250.,0.),80.); \n\
TopoDS_Shape S2 = BRepPrimAPI_MakeSphere(100.,120.*PI180); \n\
TopoDS_Shape S3 = BRepPrimAPI_MakeSphere(gp_Pnt(200.,250.,0.),100., \n\
                                     -60.*PI180, 60.*PI180); \n\
TopoDS_Shape S4 = BRepPrimAPI_MakeSphere(gp_Pnt(0.,0.,-300.),150., \n\
                                     -45.*PI180, 45.*PI180, 45.*PI180); \n\
		\n");
	PocessTextInDialog("Make a sphere", Message);
}

void CTopologyPrimitivesDoc::OnTorus() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Shape S1 = BRepPrimAPI_MakeTorus(60.,20.);
	Handle(AIS_Shape) ais1 = new AIS_Shape(S1);
	myAISContext->SetColor(ais1,Quantity_NOC_AZURE,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais1,Standard_False);
	TopoDS_Shape S2 = BRepPrimAPI_MakeTorus(gp_Ax2(gp_Pnt(100.,100.,0.),gp_Dir(1.,1.,1.)),
										50.,20.,210.*PI180);
	Handle(AIS_Shape) ais2 = new AIS_Shape(S2);
	myAISContext->SetColor(ais2,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais2,Standard_False);
	TopoDS_Shape S3 = BRepPrimAPI_MakeTorus(gp_Ax2(gp_Pnt(-200.,-150.,-100),gp_Dir(0.,1.,0.)),
										60.,20.,-45.*PI180,45.*PI180,90.*PI180);
	Handle(AIS_Shape) ais3= new AIS_Shape(S3);
	myAISContext->SetColor(ais3,Quantity_NOC_CORAL,Standard_False); 
	myAISContext->SetMaterial(ais3,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais3,Standard_False);
	Fit();

    TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape S1 = BRepPrimAPI_MakeTorus(60.,20.); \n\
TopoDS_Shape S2 = BRepPrimAPI_MakeTorus(gp_Ax2(gp_Pnt(100.,100.,0.),gp_Dir(1.,1.,1.)), \n\
                                    50.,20.,210.*PI180); \n\
TopoDS_Shape S3 = BRepPrimAPI_MakeTorus(gp_Ax2(gp_Pnt(-200.,-150.,-100),gp_Dir(0.,1.,0.)), \n\
                                    60.,20.,-45.*PI180,45.*PI180,90.*PI180); \n\
		\n");
	PocessTextInDialog("Make a torus", Message);
}

void CTopologyPrimitivesDoc::OnWedge() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Shape S1 = BRepPrimAPI_MakeWedge(60.,100.,80.,20.);
	Handle(AIS_Shape) ais1 = new AIS_Shape(S1);
	myAISContext->SetColor(ais1,Quantity_NOC_AZURE,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais1,Standard_False);
	TopoDS_Shape S2 = BRepPrimAPI_MakeWedge(gp_Ax2(gp_Pnt(100.,100.,0.),gp_Dir(0.,0.,1.)),
										60.,50.,80.,25.,-10.,40.,70.);
	Handle(AIS_Shape) ais2 = new AIS_Shape(S2);
	myAISContext->SetColor(ais2,Quantity_NOC_CORAL2,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais2,Standard_False);
	Fit();

    TCollection_AsciiString Message ("\
		\n\
TopoDS_Shape S1 = BRepPrimAPI_MakeWedge(60.,100.,80.,20.); \n\
TopoDS_Shape S2 = BRepPrimAPI_MakeWedge(gp_Ax2(gp_Pnt(100.,100.,0.),gp_Dir(0.,0.,1.)), \n\
                                    60.,50.,80.,25.,-10.,40.,70.); \n\
		\n");
	PocessTextInDialog("Make a wedge", Message);
}

void CTopologyPrimitivesDoc::OnPrism() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Vertex V1 = BRepBuilderAPI_MakeVertex(gp_Pnt(-200.,-200.,0.));
	Handle(AIS_Shape) ais1 = new AIS_Shape(V1);
	myAISContext->Display(ais1,Standard_False);
	TopoDS_Shape S1 = BRepPrimAPI_MakePrism(V1,gp_Vec(0.,0.,100.));
	Handle(AIS_Shape) ais2 = new AIS_Shape(S1);
	myAISContext->Display(ais2,Standard_False);

	TopoDS_Edge E = BRepBuilderAPI_MakeEdge(gp_Pnt(-150.,-150,0.), gp_Pnt(-50.,-50,0.));
	Handle(AIS_Shape) ais3 = new AIS_Shape(E);
	myAISContext->Display(ais3,Standard_False);
	TopoDS_Shape S2 = BRepPrimAPI_MakePrism(E,gp_Vec(0.,0.,100.));
	Handle(AIS_Shape) ais4 = new AIS_Shape(S2);
	myAISContext->SetColor(ais4,Quantity_NOC_CORAL2,Standard_False); 
	myAISContext->SetMaterial(ais4,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais4,Standard_False);

	TopoDS_Edge E1 = BRepBuilderAPI_MakeEdge(gp_Pnt(0.,0.,0.), gp_Pnt(50.,0.,0.));
	TopoDS_Edge E2 = BRepBuilderAPI_MakeEdge(gp_Pnt(50.,0.,0.), gp_Pnt(50.,50.,0.));
	TopoDS_Edge E3 = BRepBuilderAPI_MakeEdge(gp_Pnt(50.,50.,0.), gp_Pnt(0.,0.,0.));
	TopoDS_Wire W = BRepBuilderAPI_MakeWire(E1,E2,E3);
	TopoDS_Shape S3 = BRepPrimAPI_MakePrism(W,gp_Vec(0.,0.,100.));
	Handle(AIS_Shape) ais5 = new AIS_Shape(W);
	myAISContext->Display(ais5,Standard_False);
	Handle(AIS_Shape) ais6 = new AIS_Shape(S3);
	myAISContext->SetColor(ais6,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais6,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais6,Standard_False);

	gp_Circ c = gp_Circ(gp_Ax2(gp_Pnt(200.,200.,0.),gp_Dir(0.,0.,1.)), 80.);
	TopoDS_Edge Ec = BRepBuilderAPI_MakeEdge(c);
	TopoDS_Wire Wc = BRepBuilderAPI_MakeWire(Ec);
	TopoDS_Face F = BRepBuilderAPI_MakeFace(gp_Pln(gp::XOY()),Wc);
	Handle(AIS_Shape) ais7 = new AIS_Shape(F);
	myAISContext->Display(ais7,Standard_False);
	TopoDS_Shape S4 = BRepPrimAPI_MakePrism(F,gp_Vec(0.,0.,100.));
	Handle(AIS_Shape) ais8 = new AIS_Shape(S4);
	myAISContext->SetColor(ais8,Quantity_NOC_MATRABLUE,Standard_False); 
	myAISContext->SetMaterial(ais8,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais8,Standard_False);
	Fit();

    TCollection_AsciiString Message ("\
		\n\
--- Prism a vertex -> result is an edge --- \n\
\n\
TopoDS_Vertex V1 = BRepBuilderAPI_MakeVertex(gp_Pnt(-200.,-200.,0.)); \n\
TopoDS_Shape S1 = BRepBuilderAPI_MakePrism(V1,gp_Vec(0.,0.,100.)); \n\
\n\
--- Prism an edge -> result is a face --- \n\
\n\
TopoDS_Edge E = BRepBuilderAPI_MakeEdge(gp_Pnt(-150.,-150,0.), gp_Pnt(-50.,-50,0.)); \n\
TopoDS_Shape S2 = BRepPrimAPI_MakePrism(E,gp_Vec(0.,0.,100.)); \n\
\n\
--- Prism an wire -> result is a shell --- \n\
\n\
TopoDS_Edge E1 = BREpBuilderAPI_MakeEdge(gp_Pnt(0.,0.,0.), gp_Pnt(50.,0.,0.)); \n\
TopoDS_Edge E2 = BREpBuilderAPI_MakeEdge(gp_Pnt(50.,0.,0.), gp_Pnt(50.,50.,0.)); \n\
TopoDS_Edge E3 = BREpBuilderAPI_MakeEdge(gp_Pnt(50.,50.,0.), gp_Pnt(0.,0.,0.)); \n\
TopoDS_Wire W = BRepBuilderAPI_MakeWire(E1,E2,E3); \n\
TopoDS_Shape S3 = BRepPrimAPI_MakePrism(W,gp_Vec(0.,0.,100.)); \n\
\n\
--- Prism a face or a shell -> result is a solid --- \n\
\n\
gp_Circ c = gp_Circ(gp_Ax2(gp_Pnt(200.,200.,0.gp_Dir(0.,0.,1.)), 80.); \n\
TopoDS_Edge Ec = BRepBuilderAPI_MakeEdge(c); \n\
TopoDS_Wire Wc = BRepBuilderAPI_MakeWire(Ec); \n\
TopoDS_Face F = BRepBuilderAPI_MakeFace(gp::XOY(),Wc); \n\
TopoDS_Shape S4 = BRepBuilderAPI_MakePrism(F,gp_Vec(0.,0.,100.)); \n\
		\n");
	PocessTextInDialog("Make a prism", Message);
}

void CTopologyPrimitivesDoc::OnRevol() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Vertex V1 = BRepBuilderAPI_MakeVertex(gp_Pnt(-200.,-200.,0.));
	Handle(AIS_Shape) ais1 = new AIS_Shape(V1);
	myAISContext->Display(ais1,Standard_False);
	gp_Ax1 axe = gp_Ax1(gp_Pnt(-170.,-170.,0.),gp_Dir(0.,0.,1.));
	Handle(Geom_Axis1Placement) Gax1 = new Geom_Axis1Placement(axe);
	Handle (AIS_Axis) ax1 = new AIS_Axis(Gax1);
	myAISContext->Display(ax1,Standard_False);
	TopoDS_Shape S1 = BRepPrimAPI_MakeRevol(V1,axe);
	Handle(AIS_Shape) ais2 = new AIS_Shape(S1);
	myAISContext->Display(ais2,Standard_False);

	TopoDS_Edge E = BRepBuilderAPI_MakeEdge(gp_Pnt(-120.,-120,0.), gp_Pnt(-120.,-120,100.));
	Handle(AIS_Shape) ais3 = new AIS_Shape(E);
	myAISContext->Display(ais3,Standard_False);
	axe = gp_Ax1(gp_Pnt(-100.,-100.,0.),gp_Dir(0.,0.,1.));
	Handle(Geom_Axis1Placement) Gax2 = new Geom_Axis1Placement(axe);
	Handle (AIS_Axis) ax2 = new AIS_Axis(Gax2);
	myAISContext->Display(ax2,Standard_False);
	TopoDS_Shape S2 = BRepPrimAPI_MakeRevol(E,axe);
	Handle(AIS_Shape) ais4 = new AIS_Shape(S2);
	myAISContext->SetColor(ais4,Quantity_NOC_YELLOW,Standard_False); 
	myAISContext->SetMaterial(ais4,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais4,Standard_False);

	TopoDS_Edge E1 = BRepBuilderAPI_MakeEdge(gp_Pnt(0.,0.,0.), gp_Pnt(50.,0.,0.));
	TopoDS_Edge E2 = BRepBuilderAPI_MakeEdge(gp_Pnt(50.,0.,0.), gp_Pnt(50.,50.,0.));
	TopoDS_Edge E3 = BRepBuilderAPI_MakeEdge(gp_Pnt(50.,50.,0.), gp_Pnt(0.,0.,0.));
	TopoDS_Wire W = BRepBuilderAPI_MakeWire(E1,E2,E3);
	axe = gp_Ax1(gp_Pnt(0.,0.,30.),gp_Dir(0.,1.,0.));
	Handle(Geom_Axis1Placement) Gax3 = new Geom_Axis1Placement(axe);
	Handle (AIS_Axis) ax3 = new AIS_Axis(Gax3);
	myAISContext->Display(ax3,Standard_False);
	TopoDS_Shape S3 = BRepPrimAPI_MakeRevol(W,axe, 210.*PI180);
	Handle(AIS_Shape) ais5 = new AIS_Shape(W);
	myAISContext->Display(ais5,Standard_False);
	Handle(AIS_Shape) ais6 = new AIS_Shape(S3);
	myAISContext->SetColor(ais6,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais6,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais6,Standard_False);

	gp_Circ c = gp_Circ(gp_Ax2(gp_Pnt(200.,200.,0.),gp_Dir(0.,0.,1.)), 80.);
	TopoDS_Edge Ec = BRepBuilderAPI_MakeEdge(c);
	TopoDS_Wire Wc = BRepBuilderAPI_MakeWire(Ec);
	TopoDS_Face F = BRepBuilderAPI_MakeFace(gp_Pln(gp::XOY()),Wc);
	axe = gp_Ax1(gp_Pnt(290,290.,0.),gp_Dir(0.,1,0.));
	Handle(Geom_Axis1Placement) Gax4 = new Geom_Axis1Placement(axe);
	Handle (AIS_Axis) ax4 = new AIS_Axis(Gax4);
	myAISContext->Display(ax4,Standard_False);
	TopoDS_Shape S4 = BRepPrimAPI_MakeRevol(F,axe, 90.*PI180);
	Handle(AIS_Shape) ais8 = new AIS_Shape(S4);
	myAISContext->SetColor(ais8,Quantity_NOC_MATRABLUE,Standard_False); 
	myAISContext->SetMaterial(ais8,Graphic3d_NOM_PLASTIC,Standard_False);    
	myAISContext->Display(ais8,Standard_False);
	Fit();

	TCollection_AsciiString Message ("\
		\n\
--- Revol of a vertex -> result is an edge --- \n\
\n\
TopoDS_Vertex V1 = BRepBuilderAPI_MakeVertex(gp_Pnt(-200.,-200.,0.)); \n\
gp_Ax1 axe = gp_Ax1(gp_Pnt(-170.,-170.,0.),gp_Dir(0.,0.,1.)); \n\
TopoDS_Shape S1 = BRepPrimAPI_MakeRevol(V1,axe); \n\
\n\
--- Revol of an edge -> result is a face --- \n\
\n\
TopoDS_Edge E = BRepBuilderAPI_MakeEdge(gp_Pnt(-120.,-120,0.), gp_Pnt(-120.,-120,100.)); \n\
axe = gp_Ax1(gp_Pnt(-100.,-100.,0.),gp_Dir(0.,0.,1.)); \n\
TopoDS_Shape S2 = BRepPrimAPI_MakeRevol(E,axe); \n\
\n\
--- Revol of a wire -> result is a shell --- \n\
\n\
TopoDS_Edge E1 = BRepBuilderAPI_MakeEdge(gp_Pnt(0.,0.,0.), gp_Pnt(50.,0.,0.)); \n\
TopoDS_Edge E2 = BRepBuilderAPI_MakeEdge(gp_Pnt(50.,0.,0.), gp_Pnt(50.,50.,0.)); \n\
TopoDS_Edge E3 = BRepBuilderAPI_MakeEdge(gp_Pnt(50.,50.,0.), gp_Pnt(0.,0.,0.)); \n\
TopoDS_Wire W = BRepBuilderAPI_MakeWire(E1,E2,E3); \n\
axe = gp_Ax1(gp_Pnt(0.,0.,30.),gp_Dir(0.,1.,0.)); \n\
TopoDS_Shape S3 = BRepPrimAPI_MakeRevol(W,axe, 210.*PI180); \n\
\n\
--- Revol of a face -> result is a solid --- \n\
\n\
gp_Circ c = gp_Circ(gp_Ax2(gp_Pnt(200.,200.,0.),gp_Dir(0.,0.,1.)), 80.); \n\
TopoDS_Edge Ec = BRepBuilderAPI_MakeEdge(c); \n\
TopoDS_Wire Wc = BRepBuilderPI_MakeWire(Ec); \n\
TopoDS_Face F = BRepBuilderAPI_MakeFace(gp_Pln(gp::XOY()),Wc); \n\
axe = gp_Ax1(gp_Pnt(290,290.,0.),gp_Dir(0.,1,0.)); \n\
TopoDS_Shape S4 = BRepPrimAPI_MakeRevol(F,axe, 90.*PI180); \n\
		\n");
	PocessTextInDialog("Make a prism", Message);
}

void CTopologyPrimitivesDoc::OnPipe() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TColgp_Array1OfPnt CurvePoles(1,4);
	gp_Pnt pt = gp_Pnt(0.,0.,0.);
	CurvePoles(1) = pt;
	pt = gp_Pnt(20.,50.,0.);
	CurvePoles(2) = pt;
	pt = gp_Pnt(60.,100.,0.);
	CurvePoles(3) = pt;
	pt = gp_Pnt(150.,0.,0.);
	CurvePoles(4) = pt;
	Handle(Geom_BezierCurve) curve = new Geom_BezierCurve(CurvePoles);
	TopoDS_Edge E = BRepBuilderAPI_MakeEdge(curve);
	TopoDS_Wire W = BRepBuilderAPI_MakeWire(E);
	Handle(AIS_Shape) ais1 = new AIS_Shape(W);
	myAISContext->Display(ais1,Standard_False);
	Fit();
	Sleep(500);
	gp_Circ c = gp_Circ(gp_Ax2(gp_Pnt(0.,0.,0.),gp_Dir(0.,1.,0.)),10.);
	TopoDS_Edge Ec = BRepBuilderAPI_MakeEdge(c);
	TopoDS_Wire Wc = BRepBuilderAPI_MakeWire(Ec);
	Handle(AIS_Shape) ais3 = new AIS_Shape(Wc);
	myAISContext->Display(ais3,Standard_False);
	TopoDS_Face F = BRepBuilderAPI_MakeFace(gp_Pln(gp::ZOX()),Wc);
	TopoDS_Shape S = BRepOffsetAPI_MakePipe(W,F);
	Handle(AIS_Shape) ais2 = new AIS_Shape(S);
	myAISContext->SetColor(ais2,Quantity_NOC_MATRABLUE,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais2,Standard_False);
	Fit();

	TCollection_AsciiString Message ("\
		\n\
TColgp_Array1OfPnt CurvePoles(1,6);\n\
gp_Pnt pt = gp_Pnt(0.,0.,0.);\n\
CurvePoles(1) = pt;\n\
pt = gp_Pnt(20.,50.,0.);\n\
CurvePoles(2) = pt;\n\
pt = gp_Pnt(60.,100.,0.);\n\
CurvePoles(3) = pt;\n\
pt = gp_Pnt(150.,0.,0.);\n\
CurvePoles(4) = pt;\n\
Handle(Geom_BezierCurve) curve = new Geom_BezierCurve(CurvePoles);\n\
TopoDS_Edge E = BRepBuilderAPI_MakeEdge(curve);\n\
TopoDS_Wire W = BRepBuilderAPI_MakeWire(E);\n\
gp_Circ c = gp_Circ(gp_Ax2(gp_Pnt(0.,0.,0.),gp_Dir(0.,1.,0.)),10.);\n\
TopoDS_Edge Ec = BRepBuilderAPI_MakeEdge(c);\n\
TopoDS_Wire Wc = BRepBuilderAPI_MakeWire(Ec);\n\
TopoDS_Face F = BRepBuilderAPI_MakeFace(gp_Pln(gp::ZOX()),Wc);\n\
TopoDS_Shape S = BRepBuilderAPI_MakePipe(W,F);\n\
		\n");
	PocessTextInDialog("Make a pipe", Message);

}

void CTopologyPrimitivesDoc::OnThru() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	gp_Circ c1 = gp_Circ(gp_Ax2(gp_Pnt(-100.,0.,-100.),gp_Dir(0.,0.,1.)),40.);
	TopoDS_Edge E1 = BRepBuilderAPI_MakeEdge(c1);
	TopoDS_Wire W1 = BRepBuilderAPI_MakeWire(E1);
	Handle(AIS_Shape) sec1 = new AIS_Shape(W1);
	myAISContext->Display(sec1,Standard_False);
	gp_Circ c2 = gp_Circ(gp_Ax2(gp_Pnt(-10.,0.,-0.),gp_Dir(0.,0.,1.)),40.);
	TopoDS_Edge E2 = BRepBuilderAPI_MakeEdge(c2);
	TopoDS_Wire W2 = BRepBuilderAPI_MakeWire(E2);
	Handle(AIS_Shape) sec2 = new AIS_Shape(W2);
	myAISContext->Display(sec2,Standard_False);	
	gp_Circ c3 = gp_Circ(gp_Ax2(gp_Pnt(-75.,0.,100.),gp_Dir(0.,0.,1.)),40.);
	TopoDS_Edge E3 = BRepBuilderAPI_MakeEdge(c3);
	TopoDS_Wire W3 = BRepBuilderAPI_MakeWire(E3);
	Handle(AIS_Shape) sec3 = new AIS_Shape(W3);
	myAISContext->Display(sec3,Standard_False);
	gp_Circ c4= gp_Circ(gp_Ax2(gp_Pnt(0.,0.,200.),gp_Dir(0.,0.,1.)),40.);
	TopoDS_Edge E4 = BRepBuilderAPI_MakeEdge(c4);
	TopoDS_Wire W4 = BRepBuilderAPI_MakeWire(E4);
	Handle(AIS_Shape) sec4 = new AIS_Shape(W4);
	myAISContext->Display(sec4,Standard_False);
	BRepOffsetAPI_ThruSections generator(Standard_False,Standard_True);
	generator.AddWire(W1);
	generator.AddWire(W2);
	generator.AddWire(W3);
	generator.AddWire(W4);
	generator.Build();
	TopoDS_Shape S1 = generator.Shape();
	Handle(AIS_Shape) ais1 = new AIS_Shape(S1);
	myAISContext->SetColor(ais1,Quantity_NOC_MATRABLUE,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);

	gp_Circ c1b = gp_Circ(gp_Ax2(gp_Pnt(100.,0.,-100.),gp_Dir(0.,0.,1.)),40.);
	TopoDS_Edge E1b = BRepBuilderAPI_MakeEdge(c1b);
	TopoDS_Wire W1b = BRepBuilderAPI_MakeWire(E1b);
	Handle(AIS_Shape) sec1b = new AIS_Shape(W1b);
	myAISContext->Display(sec1b,Standard_False);
	gp_Circ c2b = gp_Circ(gp_Ax2(gp_Pnt(210.,0.,-0.),gp_Dir(0.,0.,1.)),40.);
	TopoDS_Edge E2b = BRepBuilderAPI_MakeEdge(c2b);
	TopoDS_Wire W2b = BRepBuilderAPI_MakeWire(E2b);
	Handle(AIS_Shape) sec2b = new AIS_Shape(W2b);
	myAISContext->Display(sec2b,Standard_False);	
	gp_Circ c3b = gp_Circ(gp_Ax2(gp_Pnt(275.,0.,100.),gp_Dir(0.,0.,1.)),40.);
	TopoDS_Edge E3b = BRepBuilderAPI_MakeEdge(c3b);
	TopoDS_Wire W3b = BRepBuilderAPI_MakeWire(E3b);
	Handle(AIS_Shape) sec3b = new AIS_Shape(W3b);
	myAISContext->Display(sec3b,Standard_False);
	gp_Circ c4b= gp_Circ(gp_Ax2(gp_Pnt(200.,0.,200.),gp_Dir(0.,0.,1.)),40.);
	TopoDS_Edge E4b = BRepBuilderAPI_MakeEdge(c4b);
	TopoDS_Wire W4b = BRepBuilderAPI_MakeWire(E4b);
	Handle(AIS_Shape) sec4b = new AIS_Shape(W4b);
	myAISContext->Display(sec4b,Standard_False);
	BRepOffsetAPI_ThruSections generatorb(Standard_True,Standard_False);
	generatorb.AddWire(W1b);
	generatorb.AddWire(W2b);
	generatorb.AddWire(W3b);
	generatorb.AddWire(W4b);
	generatorb.Build();
	TopoDS_Shape S2 = generatorb.Shape();
	Handle(AIS_Shape) ais2 = new AIS_Shape(S2);
	myAISContext->SetColor(ais2,Quantity_NOC_ALICEBLUE,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais2,Standard_False);
	Fit();

	TCollection_AsciiString Message ("\
		\n\
---------- ruled -------------- \n\
\n\
gp_Circ c1 = gp_Circ(gp_Ax2(gp_Pnt(-100.,0.,-100.),gp_Dir(0.,0.,1.)),40.);\n\
TopoDS_Edge E1 = BRepBuilderAPI_MakeEdge(c1);\n\
TopoDS_Wire W1 = BRepBuilderAPI_MakeWire(E1);\n\
gp_Circ c2 = gp_Circ(gp_Ax2(gp_Pnt(-10.,0.,-0.),gp_Dir(0.,0.,1.)),40.);\n\
TopoDS_Edge E2 = BRepBuilderAPI_MakeEdge(c2);\n\
TopoDS_Wire W2 = BRepBuilderAPI_MakeWire(E2);\n\
gp_Circ c3 = gp_Circ(gp_Ax2(gp_Pnt(-75.,0.,100.),gp_Dir(0.,0.,1.)),40.);\n\
TopoDS_Edge E3 = BRepBuilderAPI_MakeEdge(c3);\n\
TopoDS_Wire W3 = BRepBuilderAPI_MakeWire(E3);\n\
gp_Circ c4= gp_Circ(gp_Ax2(gp_Pnt(0.,0.,200.),gp_Dir(0.,0.,1.)),40.);\n\
TopoDS_Edge E4 = BRep>BuilderAPI_MakeEdge(c4);\n\
TopoDS_Edge E4 = BRepBuilderAPI_MakeEdge(c4);\n\
TopoDS_Edge E4 = BRepBuilderAPI_MakeEdge(c4);\n\
TopoDS_Wire W4 = BRepBuilderAPI_MakeWire(E4);\n\
BRepOffsetAPI_ThruSections generator(Standard_False,Standard_True);\n\
generator.AddWire(W1);\n\
generator.AddWire(W2);\n\
generator.AddWire(W3);\n\
generator.AddWire(W4);\n\
generator.Build();\n\
TopoDS_Shape S1 = generator.Shape();\n\
\n\
---------- smooth -------------- \n\
\n\
gp_Circ c1b = gp_Circ(gp_Ax2(gp_Pnt(100.,0.,-100.),gp_Dir(0.,0.,1.)),40.); \n\
TopoDS_Edge E1b = BRepBuilderAPI_MakeEdge(c1b); \n\
TopoDS_Wire W1b = BRepBuilderAPI_MakeWire(E1b); \n\
gp_Circ c2b = gp_Circ(gp_Ax2(gp_Pnt(210.,0.,-0.),gp_Dir(0.,0.,1.)),40.); \n\
TopoDS_Edge E2b = BRepBuilderAPI_MakeEdge(c2b);\n\
TopoDS_Wire W2b = BRepBuilderAPI_MakeWire(E2b); \n\
gp_Circ c3b = gp_Circ(gp_Ax2(gp_Pnt(275.,0.,100.),gp_Dir(0.,0.,1.)),40.);\n\
TopoDS_Edge E3b = BRepBuilderAPI_MakeEdge(c3b);\n\
TopoDS_Wire W3b = BRepBuilderAPI_MakeWire(E3b);\n\
gp_Circ c4b= gp_Circ(gp_Ax2(gp_Pnt(200.,0.,200.),gp_Dir(0.,0.,1.)),40.);\n\
TopoDS_Edge E4b = BRepBuilderAPI_MakeEdge(c4b);\n\
TopoDS_Wire W4b = BRepBuilderAPI_MakeWire(E4b);\n\
BRepOffsetAPI_ThruSections generatorb(Standard_True,Standard_False);\n\
generatorb.AddWire(W1b);\n\
generatorb.AddWire(W2b);\n\
generatorb.AddWire(W3b);\n\
generatorb.AddWire(W4b);\n\
generatorb.Build();\n\
TopoDS_Shape S2 = generatorb.Shape();\n\
		\n");
	PocessTextInDialog("Make a Thru sections", Message);

}

void CTopologyPrimitivesDoc::OnEvolved() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	BRepBuilderAPI_MakePolygon P;
	P.Add(gp_Pnt(0.,0.,0.));
	P.Add(gp_Pnt(200.,0.,0.));
	P.Add(gp_Pnt(200.,200.,0.));
	P.Add(gp_Pnt(0.,200.,0.));
	P.Add(gp_Pnt(0.,0.,0.));
	TopoDS_Wire W = P.Wire();
	
	Handle(AIS_Shape) ais1 = new AIS_Shape(W);
	myAISContext->Display(ais1,Standard_False);
	
	TopoDS_Wire wprof = BRepBuilderAPI_MakePolygon(gp_Pnt(0.,0.,0.),gp_Pnt(-60.,-60.,-200.));
	
	Handle(AIS_Shape) ais3 = new AIS_Shape(wprof);
	myAISContext->Display(ais3,Standard_False);
	Fit();
	Sleep(500);
	TopoDS_Shape S = BRepOffsetAPI_MakeEvolved(W,wprof,GeomAbs_Arc,Standard_True,Standard_False,Standard_True,0.0001);
	
	Handle(AIS_Shape) ais2 = new AIS_Shape(S);
	myAISContext->SetColor(ais2,Quantity_NOC_MATRABLUE,Standard_False); 
	myAISContext->SetMaterial(ais2,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais2,Standard_False);
	Fit();
	
	TCollection_AsciiString Message ("\
		\n\
---------- Evolved shape -------------- \n\
\n\
BRepBuilderAPI_MakePolygon P;\n\
P.Add(gp_Pnt(0.,0.,0.));\n\
P.Add(gp_Pnt(200.,0.,0.));\n\
P.Add(gp_Pnt(200.,200.,0.));\n\
P.Add(gp_Pnt(0.,200.,0.));\n\
P.Add(gp_Pnt(0.,0.,0.));\n\
TopoDS_Wire W = P.Wire();\n\
TopoDS_Wire wprof = BRepBuilderAPI_MakePolygon(gp_Pnt(0.,0.,0.),gp_Pnt(-60.,-60.,-200.));\n\
TopoDS_Shape S = BRepBuilderAPI_MakeEvolved(W,wprof,GeomAbs_Arc,Standard_True,Standard_False,Standard_True,0.0001);\n\
		\n");
  PocessTextInDialog("Make an evolved shape", Message);

}

void CTopologyPrimitivesDoc::OnDraft() 
{
	AIS_ListOfInteractive aList;
	myAISContext->DisplayedObjects(aList);
	AIS_ListIteratorOfListOfInteractive aListIterator;
	for(aListIterator.Initialize(aList);aListIterator.More();aListIterator.Next()){
		myAISContext->Remove(aListIterator.Value());
	}

	TopoDS_Shape S = BRepPrimAPI_MakeBox(200.,300.,150.);
	Handle(AIS_Shape) ais1 = new AIS_Shape(S);
	myAISContext->SetColor(ais1,Quantity_NOC_GREEN,Standard_False); 
	myAISContext->SetMaterial(ais1,Graphic3d_NOM_PLASTIC,Standard_False);   
	myAISContext->Display(ais1,Standard_False);
	Fit();
	Sleep(500);
	BRepOffsetAPI_DraftAngle adraft(S);
	TopExp_Explorer Ex;
	for (Ex.Init(S,TopAbs_FACE); Ex.More(); Ex.Next()) {
		TopoDS_Face F = TopoDS::Face(Ex.Current());
		Handle(Geom_Plane) surf = Handle(Geom_Plane)::DownCast(BRep_Tool::Surface(F));
		gp_Pln apln = surf->Pln();
		gp_Dir dirF = apln.Axis().Direction();
		if (dirF.IsNormal(gp_Dir(0.,0.,1.),Precision::Angular()))
			adraft.Add(F, gp_Dir(0.,0.,1.), 15.*PI180, gp_Pln(gp::XOY()));
	}
	ais1->Set(adraft.Shape());
	myAISContext->Redisplay(ais1,Standard_False);
	Fit();

	TCollection_AsciiString Message ("\
		\n\
---------- Tapered shape -------------- \n\
\n\
TopoDS_Shape S = BRepPrimAPI_MakeBox(200.,300.,150.);\n\
BRepOffsetAPI_DraftAngle adraft(S);\n\
TopExp_Explorer Ex;\n\
for (Ex.Init(S,TopAbs_FACE); Ex.More(); Ex.Next()) {\n\
	TopoDS_Face F = TopoDS::Face(Ex.Current());\n\
	Handle(Geom_Plane) surf = Handle(Geom_Plane)::DownCast(BRep_Tool::Surface(F));\n\
	gp_Pln apln = surf->Pln();\n\
	gp_Dir dirF = apln.Axis().Direction();\n\
	if (dirF.IsNormal(gp_Dir(0.,0.,1.),Precision::Angular()))\n\
		adraft.Add(F, gp_Dir(0.,0.,1.), 15.*PI180, gp_Pln(gp::XOY()));\n\
}\n\
		\n");
	PocessTextInDialog("Make a tapered shape", Message);

}

