// WalkthroughView.h : interface of the CWalkthroughView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_VIEWERVIEW_H__4EF39FBC_4EBB_11D1_8D67_0800369C8A03__INCLUDED_)
#define AFX_VIEWERVIEW_H__4EF39FBC_4EBB_11D1_8D67_0800369C8A03__INCLUDED_

#include "Tune.h"	// Added by ClassView
#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "WalkthroughDoc.h"
#include <OCC_3dView.h>

enum View3D_CurrentAction { 
  CurrentAction3d_Nothing,
  CurrentAction3d_DynamicZooming,
  CurrentAction3d_WindowZooming,
  CurrentAction3d_DynamicPanning,
  CurrentAction3d_GlobalPanning,
  CurrentAction3d_DynamicRotation,
  CurrentAction3d_Fly,
  CurrentAction3d_Turn
};

class CWalkthroughView : public OCC_3dView
{
protected: // create from serialization only
	CWalkthroughView();
	DECLARE_DYNCREATE(CWalkthroughView)

// Attributes
public:
	CWalkthroughDoc* GetDocument();

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWalkthroughView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

// Implementation
public:
	void SetDimensions ();
	void ReloadData();
	CTune m_Tune;
	void SetFocal ( double dFocus , double dAngle );
	void Fly (int x , int y);
	void Turn (int x , int y);
	void Roll (int x , int y);
	void Twist (int x , int y);
	virtual ~CWalkthroughView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	double m_dAngle;
	BOOL m_bShift;
	int m_cx , m_cy ;
	int m_curx , m_cury ;

	//{{AFX_MSG(CWalkthroughView)
	afx_msg void OnBUTTONPan();
	afx_msg void OnBUTTONPanGlo();
	afx_msg void OnBUTTONReset();
	afx_msg void OnBUTTONRot();
	afx_msg void OnBUTTONZoomAll();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnBUTTONZoomProg();
	afx_msg void OnBUTTONZoomWin();
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnMButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnUpdateBUTTONPanGlo(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONPan(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONZoomProg(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONZoomWin(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONRot(CCmdUI* pCmdUI);
	afx_msg void OnSensitivity();
	afx_msg void OnBUTTONFly();
	afx_msg void OnBUTTONTurn();
	afx_msg void OnUpdateBUTTONFly(CCmdUI* pCmdUI);
	afx_msg void OnUpdateBUTTONTurn(CCmdUI* pCmdUI);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnViewDisplaystatus();
	afx_msg void OnUpdateViewDisplaystatus(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	Handle_V3d_PerspectiveView myPView;

    View3D_CurrentAction myCurrentMode;
    double               m_Atx  , m_Aty  , m_Atz  ;
	double               m_Eyex , m_Eyey , m_Eyez ;
	double               m_FlySens ;
	double               m_TurnSens ;
	double               m_Focus ;

};

#ifndef _DEBUG  // debug version in WalkthroughView.cpp
inline CWalkthroughDoc* CWalkthroughView::GetDocument()
   { return (CWalkthroughDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_VIEWERVIEW_H__4EF39FBC_4EBB_11D1_8D67_0800369C8A03__INCLUDED_)
