/***************************************************************************
						normalize.cpp  -  description
							-------------------
	begin                : july 2nd, 2006
	copyright            : (C) 2006 by Frdric RODRIGO
	email                : f.rodrigo free.fr
	
	$Id: normalize.cpp 20 2006-07-16 10:28:39Z neoneurone $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   any later version.                                                    *
 *                                                                         *
 ***************************************************************************/

#include "normalize.h"

//#include <math.h>

namespace mapgen
{

   /*=====================================================================*/
Normalize::Normalize(
	const float min,
	const float max ):
_min(min),
_max(max)
{
	MAP_DEBUG( "ctor" );
}


   /*=====================================================================*/
Normalize::~Normalize()
{
	MAP_DEBUG( "ctor" );
}


   /*=====================================================================*/
void Normalize::apply( Map* map )
{
	float min, max;
	_getMinMax( map, &min, &max );

	float a = (_max-_min) / (max-min);
	float b = -min * a + _min;

	for( uint x=0 ; x<map->getW() ; ++x )
		for( uint y=0 ; y<map->getH() ; ++y )
			map->setAt( x, y, a*map->getAt(x,y)+b );
}

}
