;;; -*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;

;;; level-0;ppc;ppc-hash.lisp


;(in-package "CCL")

(eval-when (:compile-toplevel :execute)
  (require "HASHENV" "ccl:xdump;hashenv"))




; This should stay in LAP so that it's fast
; Equivalent to cl:mod when both args are positive fixnums
(defppclapfunction fast-mod ((number arg_y) (divisor arg_z))
  (divwu imm0 number divisor)
  (mullw arg_z imm0 divisor)
  (subf arg_z arg_z number)
  (blr))

; not used today
(defppclapfunction fixnum-rotate ((number arg_y) (count arg_z))
  (unbox-fixnum imm0 count)
  (unbox-fixnum imm1 number)
  (rlwnm imm1 imm1 imm0 0 31)
  (box-fixnum arg_z imm1)
  (blr))



(defppclapfunction %dfloat-hash ((key arg_z))
  (lwz imm0 arch::double-float.value key)
  (lwz imm1 arch::double-float.val-low key)
  (add imm0 imm0 imm1)
  (box-fixnum arg_z imm0)
  (blr))

(defppclapfunction %sfloat-hash ((key arg_z))
  (lwz imm0 arch::single-float.value key)
  (box-fixnum arg_z imm0)
  (blr))

(defppclapfunction %macptr-hash ((key arg_z))
  (lwz imm0 arch::macptr.address key)
  (slwi imm1 imm0 24)
  (add imm0 imm0 imm1)
  (clrrwi arg_z imm0 arch::fixnumshift)
  (blr))

(defppclapfunction %bignum-hash ((key arg_z))
  (let ((header imm3)
        (offset imm2)
        (ndigits imm1)
        (immhash imm0))
    (li immhash 0)
    (li offset arch::misc-data-offset)
    (getvheader header key)
    (header-size ndigits header)
    (let ((next header))
      @loop
      (cmpwi cr0 ndigits 1)
      (subi ndigits ndigits 1)
      (lwzx next key offset)
      (addi offset offset 4)
      (rotlwi immhash immhash 13)
      (add immhash immhash next)
      (bne cr0 @loop))
    (clrrwi arg_z immhash arch::fixnumshift)
    (blr)))

      


(defppclapfunction %get-fwdnum ()
  (ref-global arg_z arch::fwdnum)
  (blr))



(defppclapfunction %get-gc-count ()
  (ref-global arg_z arch::gc-count)
  (blr))


      
; X is ephemeral if it's a cons or vector, the kernel global
; "OLDEST-EPHEMERAL" is non-zero, and X is between OLDEST-EPHEMERAL
; and the freeptr.
(defppclapfunction ephemeral-p ((x arg_z))
  (ref-global imm1 oldest-ephemeral)
  (cmpwi cr0 imm1 0)
  (extract-fulltag imm0 x)
  (cmpwi cr1 imm0 arch::fulltag-cons)
  (cmpwi cr2 imm0 arch::fulltag-misc)
  (cmplw cr3 x freeptr)
  (beq cr0 @no)
  (cmplw cr0 imm1 x)
  (beq cr1 @maybe)
  (bne cr2 @no)
  @maybe
  (bgt cr3 @no)
  (bgt cr0 @no)
  (la arg_z arch::t-offset rnil)
  (blr)
  @no
  (mr arg_z rnil)
  (blr))



; Setting a key in a hash-table vector needs to 
; ensure that the vector header gets memoized as well
#+ppc-target
(defppclapfunction %set-hash-table-vector-key ((vector arg_x) (index arg_y) (value arg_z))
  (push vector memo)
  (la imm0 arch::misc-data-offset index)
  (add loc-g vector imm0)
  (push loc-g memo)
  (stw arg_z 0 loc-g)
  (blr))


; end of ppc-hash.lisp
