;;; -*- Mode: Lisp; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;


;;; Do an FF-CALL to MakeDataExecutable so that the data cache gets flushed.
;;; This needs to be called inside a WITHOUT-INTERRUPTS.
(defsparclapfunction %make-code-executable ((codev %arg_z))
  (save-lisp-context)
  (getvheader codev %imm2)
  (header-length %imm2 %imm1)
  (add codev arch::misc-data-offset %imm0)
  (sub %sp (+ sparc::c-frame.minsiz sparc::lisp-frame.size) %sp)
  (st %imm0 (%sp sparc::c-frame.param0))
  (st %imm1 (%sp sparc::c-frame.param1))
  (ref-global %imm3 kernel-imports)
  (call-subprim .SPeabi-ff-call)
    (ld (%imm3 arch::kernel-import-MakeDataExecutable) %arg_z)
  (restore-full-lisp-context)
  (retl)
    (mov %rnil %arg_z))

; end of ppc-def.lisp
