;;-*-Mode: LISP; Package: CCL -*-
;;;
;;;   Copyright (C) 1994-2001 Digitool, Inc
;;;   This file is part of Opensourced MCL.
;;;
;;;   Opensourced MCL is free software; you can redistribute it and/or
;;;   modify it under the terms of the GNU Lesser General Public
;;;   License as published by the Free Software Foundation; either
;;;   version 2.1 of the License, or (at your option) any later version.
;;;
;;;   Opensourced MCL is distributed in the hope that it will be useful,
;;;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;;;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;;   Lesser General Public License for more details.
;;;
;;;   You should have received a copy of the GNU Lesser General Public
;;;   License along with this library; if not, write to the Free Software
;;;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;;;


; Level-1.lisp

;; **** There must be NO lisp package or nilreg-rel immediates in this file ****

(unless 
    nil
  (setq *lds* t))

(macrolet ((l1-load (name)
	     (let* ((namestring
		     (concatenate 'simple-base-string
				  #+linuxppc-target "./l1-pfsls/"
				  #+sparc-target "./l1-sfsls/"
				  #+darwinppc-target "./l1-dfsls/"
				  (string name)
				  #+linuxppc-target ".pfsl"
				  #+sparc-target ".sfsl"
				  #+darwinppc-target ".dfsl")))
	       `(%fasload ,namestring)))
	   (bin-load (name)
	     (let* ((namestring
		     (concatenate 'simple-base-string
				  #+linuxppc-target "./binppc/"
				  #+sparc-target "./binsparc/"
				  #+darwinppc-target "./bindarwin/"
				  (string name)
				  #+linuxppc-target ".pfsl"
				  #+sparc-target ".sfsl"
				  #+darwinppc-target ".dfsl")))
	       `(%fasload ,namestring))))

  (l1-load "l1-cl-package")
  (l1-load "l1-utils")
  (l1-load "l1-init")
  (l1-load "l1-symhash")
  (l1-load "l1-numbers")
  (l1-load "l1-aprims")
  #+ppc-target
  (l1-load "ppc-callback-support")
  #+sparc-target
  (l1-load "sparc-callback-support")
  (l1-load "l1-callbacks")
  (l1-load "l1-sort")
  (l1-load "l1-dcode")
  (l1-load "l1-clos")
  (bin-load "defstruct")
  (l1-load "l1-streams")
  #+ppc-target
  (l1-load "linux-files")
  #+sparc-target
  (l1-load "solaris-files")
  (bin-load "lists")
  (bin-load "sequences")
  (bin-load "chars")
  (bin-load "dll-node")
  (l1-load "l1-files")
  (provide "SEQUENCES")
  (provide "DEFSTRUCT")
  (provide "CHARS")
  (provide "LISTS")
  (provide "DLL-NODE")
  #+ppc-target
  (l1-load "ppc-stack-groups")
  #+sparc-target
  (l1-load "sparc-stack-groups")
  (l1-load "l1-stack-groups")
  (l1-load "l1-processes")
  (l1-load "l1-io")
  (l1-load "l1-reader")
  (l1-load "l1-readloop")
  (lds (l1-load "l1-readloop-lds")
       (l1-load "l1-base-app"))
  (l1-load "l1-error-system")


					;#|
					; handy when we dont do windows yet
  (defun %error (condition args error-pointer)
    (setq condition (condition-arg condition args 'simple-error))
    (with-pstrs ((str (format nil "error: ~a" condition))) (Bug str))  
    (signal condition)
    (with-pstrs ((str (format nil "error: ~a" condition))) (Bug str))
    (application-error *application* condition error-pointer)
    (application-error
     *application*
     (condition-arg "~s returned. It shouldn't.~%If it returns again, I'll throw to toplevel."
		    '(application-error) 'simple-error)
     error-pointer)
    (toplevel))
					;|#

  (l1-load "l1-events")
  #+ppc-target
  (l1-load "ppc-trap-support")
  #+sparc-target
  (l1-load "sparc-trap-support")
  (l1-load "l1-format")
  (l1-load "l1-sysio")
  (l1-load "l1-pathnames")
  (l1-load "version")
  (lds (l1-load "l1-boot-lds"))		; load before l1-boot

  (l1-load "l1-boot-1")
  (l1-load "l1-boot-2")
  (l1-load "l1-boot-3")

  )




