# Copyright (C) 2000-2001 The OpenRPG Project
#
#	openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: orpg_settings.py
# Author: Chris Davis
# Maintainer:
# Version:
#   $Id: orpg_settings.py,v 1.22 2003/12/11 15:15:27 digitalxero Exp $
#
# Description: classes for orpg settings
#

from orpg.orpg_windows import *
import orpg.dirpath
import config_files
from orpg.orpg_xml import *
from rgbhex import *

class settings_grid(wxGrid):
    """grid for gen info"""
    def __init__(self, parent, setobj, settings, openrpg = None):
        wxGrid.__init__(self, parent, -1, style=wxSUNKEN_BORDER| wxWANTS_CHARS)
        self.openrpg = openrpg
        self.setting_data = []
        EVT_SIZE(self, self.on_size)
        EVT_GRID_CELL_CHANGE(self, self.on_cell_change)
        EVT_GRID_CELL_LEFT_CLICK(self, self.on_left_click)

        self.CreateGrid(len(settings),3)
        self.SetRowLabelSize(0)
        self.SetColLabelValue(0,"Setting")
        self.SetColLabelValue(1,"Value")
        self.SetColLabelValue(2,"Available Options")
        for i in range(len(settings)):
            self.SetCellValue(i,0,settings[i])
            value = setobj.get_setting(settings[i])
            self.SetCellValue(i,1,value)
            if value and value[0] == '#':
                self.SetCellBackgroundColour(i,1,value)
            options = setobj.get_options(settings[i])
            self.SetCellValue(i,2,options)
        self.setobj = setobj


    def on_left_click(self,evt):
        row = evt.GetRow()
        col = evt.GetCol()
        if col == 2:
            return
        elif col == 0:
            name = self.GetCellValue(row,0)
            str = self.setobj.get_help(name)
            msg = wxMessageBox(str,name)
            return
        setting = self.GetCellValue(row,0)
        value = self.GetCellValue(row,1)
        if value and value[0] == '#':
            hexcolor = RGBHex().do_hex_color_dlg(self)
            if hexcolor:
                self.setobj.set_setting(setting,hexcolor)
                self.SetCellBackgroundColour(row,1,hexcolor)
                self.Refresh()
        else:
            evt.Skip()

    def on_cell_change(self,evt):
        row = evt.GetRow()
        col = evt.GetCol()
        if col <> 1:
            return
        setting = self.GetCellValue(row,0)
        value = self.GetCellValue(row,1)

	self.setting_data += [[setting, value]]


    def on_size(self,evt):
        (w,h) = self.GetClientSizeTuple()
        cols = self.GetNumberCols()
        col_w = w/(cols)
        for i in range(0,cols):
            self.SetColSize(i,col_w)
        evt.Skip()
        self.Refresh()


##-----------------------------
## Preferences Dialog
##-----------------------------

class prefs_dialog(wxDialog):
    "Preferences dialog for OpenRPG"
    def __init__(self,parent,setobj,openrpg):
        SETTINGS_TABS = wxNewId()
        wxDialog.__init__(self,parent,-1,"OpenRPG Preferences",wxDefaultPosition,wxSize(640,480))
        self.settings_tabs = wxNotebook(self, SETTINGS_TABS)
        self.settings_handlers = []
        chat = []
        general = []
        map = []
        gametree = []
        macros = []
        roomlist = []
        toolbar = []
        colors = []

        settings = setobj.get_setting_keys()
        for m in range(len(settings)):
	    if setobj.get_catagory(settings[m]) == "chat":
                chat.append(settings[m])
            elif setobj.get_catagory(settings[m]) == "general":
                general.append(settings[m])
            elif setobj.get_catagory(settings[m]) == "map":
                map.append(settings[m])
            elif setobj.get_catagory(settings[m]) == "gametree":
                gametree.append(settings[m])
            elif setobj.get_catagory(settings[m]) == "macros":
                macros.append(settings[m])
            elif setobj.get_catagory(settings[m]) == "roomlist":
                roomlist.append(settings[m])
            elif setobj.get_catagory(settings[m]) == "toolbar":
                toolbar.append(settings[m])
            elif setobj.get_catagory(settings[m]) == "colors":
                colors.append(settings[m])

# general tab

        general_tab = settings_grid(self.settings_tabs,setobj,general)
        self.settings_handlers.append(general_tab)
        self.settings_tabs.AddPage(self.settings_handlers[0],"General")


# chat tab

        chat_tab = settings_grid(self.settings_tabs,setobj,chat)
        self.settings_handlers.append(chat_tab)
        self.settings_tabs.AddPage(self.settings_handlers[1],"Chat")

# map tab

        map_tab = settings_grid(self.settings_tabs,setobj,map)
        self.settings_handlers.append(map_tab)
        self.settings_tabs.AddPage(self.settings_handlers[2],"Map")
# gametree tab

        gametree_tab = settings_grid(self.settings_tabs,setobj,gametree)
        self.settings_handlers.append(gametree_tab)
        self.settings_tabs.AddPage(self.settings_handlers[3],"Game Tree")

# macros tab

        macros_tab = settings_grid(self.settings_tabs,setobj, macros)
        self.settings_handlers.append(macros_tab)
        self.settings_tabs.AddPage(self.settings_handlers[4],"Macros")

# Game Server/Room List tab

        roomlist_tab = settings_grid(self.settings_tabs,setobj, roomlist)
        self.settings_handlers.append(roomlist_tab)
        self.settings_tabs.AddPage(self.settings_handlers[5],"Server/Room Lists")

# Chat Toolbar tab

        toolbar_tab = settings_grid(self.settings_tabs,setobj, toolbar)
        self.settings_handlers.append(toolbar_tab)
        self.settings_tabs.AddPage(self.settings_handlers[6],"Chat Toolbar")

# Chat Colors tab

        colors_tab = settings_grid(self.settings_tabs,setobj, colors)
        self.settings_handlers.append(colors_tab)
        self.settings_tabs.AddPage(self.settings_handlers[7],"Chat Colors")

        sizer =  wxBoxSizer(wxHORIZONTAL)
        sizer.Add(wxButton(self, wxID_OK, "OK"), 1, wxEXPAND)
        sizer.Add(10,10)
        sizer.Add(wxButton(self, wxID_CANCEL, "Cancel"), 1, wxEXPAND)
        (w,h) = self.GetClientSizeTuple()
        self.settings_tabs.SetDimensions(0,0,w,h-25)
        sizer.SetDimension(0,h-25,w,25)

        self.general_tab =  general_tab
        self.chat_tab = chat_tab
        self.map_tab = map_tab
        self.gametree_tab = gametree_tab
        self.macros_tab = macros_tab
        self.roomlist_tab = roomlist_tab
        self.toolbar_tab = toolbar_tab
        self.colors_tab = colors_tab
        self.setobj = setobj

        EVT_BUTTON(self, wxID_OK, self.on_ok)
        EVT_NOTEBOOK_PAGE_CHANGED(self, SETTINGS_TABS, self.on_page_change)
        EVT_SIZE(self, self.on_size)

    def on_size(self,evt):
        (w,h) = self.GetClientSizeTuple()
        self.settings_tabs.SetDimensions(0,0,w,h-25)

    def on_page_change(self,evt):
        pass

    def on_ok(self,evt):
        for m in self.general_tab.setting_data:
            self.setobj.set_setting(m[0],m[1])
        for m in self.chat_tab.setting_data:
            self.setobj.set_setting(m[0],m[1])
            if m[0] == "tabbedwhispers":
                self.warning_msg()
            elif m[0] == "defaultfont":
                self.warning_msg()
            elif m[0] == "defaultfontsize":
                self.warning_msg()
        for m in self.map_tab.setting_data:
            self.setobj.set_setting(m[0],m[1])
        for m in self.gametree_tab.setting_data:
            self.setobj.set_setting(m[0],m[1])
        for m in self.macros_tab.setting_data:
            self.setobj.set_setting(m[0],m[1])
        for m in self.roomlist_tab.setting_data:
            self.setobj.set_setting(m[0],m[1])
        for m in self.colors_tab.setting_data:
            self.setobj.set_setting(m[0],m[1])
        for m in self.toolbar_tab.setting_data:
            self.setobj.set_setting(m[0],m[1])
        if len(self.toolbar_tab.setting_data) >0:
            self.warning_msg()
    	self.general_tab.DisableCellEditControl()
        self.chat_tab.DisableCellEditControl()
        self.map_tab.DisableCellEditControl()
        self.gametree_tab.DisableCellEditControl()
        self.macros_tab.DisableCellEditControl()
        self.roomlist_tab.DisableCellEditControl()
        self.toolbar_tab.DisableCellEditControl()
        self.colors_tab.DisableCellEditControl()
        self.EndModal(wxID_OK)

    def warning_msg(self):
        warning_dlg = wxMessageBox("You will need to restart for\nthese changes to take effect", "Information")

####################
## settings xml object
####################
class settings:
    def __init__(self):

        ini_xml="ini.xml"
        index=1
        while(index<len(sys.argv)-1):
            if (sys.argv[index] == "-i"):
                ini_xml=sys.argv[index+1]
                sys.argv[index]=""
                sys.argv[index+1]=""
            index = index + 1

        #  This stores a dictionary of runnable objects that will be called
        #      when a key's value gets set.  See settings.set_change_handler()
        self.change_handler = {}

        #  Load the two trees
        self.setup_ini(ini_xml)

    def setup_ini(self,ini_xml):
        self.filename = orpg.dirpath.dir_struct["user"] + ini_xml     # This is the filename we're going to use
        default_tree = self.loadTree(orpg.dirpath.dir_struct["template"]+"default_ini.xml")
        config_files.validate_config_file(ini_xml,"default_ini.xml")
        my_tree = self.loadTree(self.filename)
        #  four cases possible
        if (not default_tree):
            if (not my_tree):   # Case 1:  not default_tree AND not my_tree:  complain and exit
                msg = wxMessageDialog(None,"Restore " + ini_xml + " or default_ini.xml and start again.","Settings files bad or missing",wxOK)
                msg.ShowModal()
                msg.Destroy()
                sys.exit()
            else:               # Case 2:  not default_tree AND my_tree:  Just use my_tree as-is
                self.xml_dom = my_tree
        else:
            if (not my_tree):   # Case 3:  default_tree AND not my_tree:  Just use default_tree as-is
                self.xml_dom = default_tree
            else:               # Case 4:  Add nodes from default_tree that aren't in my_tree to my_tree
                for key in self.get_tree_setting_keys(default_tree,hidden = 1):  #  Cycle through all default keys
                    setting = self.get_tree_value(my_tree,key)                 #  See what my_tree has
                    if not setting:                                              #  If nothing,
                        self.set_tree_value(my_tree,key,self.get_tree_value(default_tree,key))   # Use defaults
                    catagory = self.get_tree_value(my_tree,key,attrib="catagory")
                    if not catagory:
                        self.set_tree_value(my_tree,key,self.get_tree_value(default_tree,key,attrib="catagory"),attrib="catagory")
                    help = self.get_tree_value(my_tree,key,attrib="help")
                    if not help:
                        self.set_tree_value(my_tree,key,self.get_tree_value(default_tree,key,attrib="help"),attrib="help")
                    options = self.get_tree_value(my_tree,key,attrib="options")
                    if not options:
                        self.set_tree_value(my_tree,key,self.get_tree_value(default_tree,key,attrib="options"),attrib="options")
                self.xml_dom = my_tree               #  Now that my_tree is fixed up, use it
                default_tree.unlink()  # free up circular refs in unused tree

    def reload_settings(self,chat):
        try:
            chat.session.set_name(self.get_setting("player"))
            chat.set_colors()
            chat.set_buffersize()
            chat.roller_manager.set_roller(self.get_setting('dieroller'))
        except Exception,e:
            print e
            chat.InfoPost("One or more settings were invalid check your settings")

    def loadTree(self, filename):

        try:
            ini = open(filename,"r")
            txt = ini.read()
            tree = parseXml(txt)._get_documentElement()
            ini.close()
            return tree
        except:
            return None


    def load(self, filename):
        self.xml_dom = self.loadTree(filename)
        if self.xml_dom:
            return 1
        else:
            return 0

    def get_tree_setting_keys(self,tree,hidden=0):
        node_list = tree._get_childNodes()
        keys = []
        for n in node_list:
            if not hidden and n.getAttribute("hidden"): #all none hidden elements
                continue
            keys.append(n._get_tagName())
        return keys


    def get_setting_keys(self,hidden=0):
        return self.get_tree_setting_keys(self.xml_dom,hidden)


    def get_tree_xml_node(self,tree,name):
        node_list = tree.getElementsByTagName(name)
        if not len(node_list):
            node = minidom.Element(name)
            node = tree.appendChild(node)
            #print tree.toxml(1)
            node_list = tree.getElementsByTagName(name)
        return node_list[0]

    def get_xml_node(self,name):
        return self.get_tree_xml_node(self.xml_dom,name)


    def get_tree_value(self,tree,name,create = 1,attrib = "value"):
        node = self.get_tree_xml_node(tree,name)
        return node.getAttribute(attrib)


    def get_setting(self,name,create=1):
        return self.get_tree_value(self.xml_dom,name,create)

    def get_help(self,name):
        node = self.get_tree_xml_node(self.xml_dom,name)
        try:
            str = node.getAttribute("help")
#
# funkyness to allow \n in help names display properly in dialog.
# if you can find a better way then go for it.
#

            splited = str.split("\\n")
            return_str = ""
            for m in range(len(splited)):
                return_str = return_str + splited[m] +"\n"
#
# end of funkyness
#

            if return_str == "\n":
                return_str = "No help available for this setting"
            return return_str
        except:
            return "No help available for this setting"

    def get_catagory(self,name):
        node =  self.get_tree_xml_node(self.xml_dom,name)
        try:
            catagory = node.getAttribute("catagory").lower()
            if catagory == "":
                catagory = "general"
            return catagory
        except:
            return "general"

    def get_options(self,name):
        node = self.get_tree_xml_node(self.xml_dom,name)
        try:
            option = node.getAttribute("options")
        except:
            option = ""
        return option

    def set_change_handler(self,key,handler):
        #  takes a key (key) to watch and runnable object (handler) to execute
        #    when key changes.  When handler is executed, it is passed a single
        #    argument, which will hold the value being stored.
        self.change_handler[key] = handler

    def get_change_handler(self,key):
        if self.change_handler.has_key(key):
            return self.change_handler[key]
        else:
            return None

    def set_tree_value(self,tree,name,value,hidden = 0, attrib="value"):
        node = self.get_tree_xml_node(tree,name)
        node.setAttribute(attrib,value)
        if hidden: node.setAttribute("hidden", "true")
        if self.change_handler.has_key(name) and attrib == "value":
            self.change_handler[name](value)

    def set_setting(self,name,value,hidden=0):
        node = self.get_xml_node(name)
        node.setAttribute("value",value)
        if hidden: node.setAttribute("hidden", "true")
        if self.change_handler.has_key(name):
            self.change_handler[name](value)

    def get_tree_multi_setting(self,tree,name):
        node_list = tree.getElementsByTagName(name)
        node_list = node_list[0]._get_childNodes()
        if len(node_list) == 0:
            return None
        ary = []
        for n in node_list:
            ary.append(n.getAttribute("value"))
        return ary


    def get_multi_setting(self,name):
        return self.get_tree_multi_setting(self.xml_dom,name)

    def saveTree(self,tree):
        ini = open(self.filename,"w")
        ini.write(toxml(tree,1))
        ini.close()


    def save(self):
        self.saveTree(self.xml_dom)

