# Copyright (C) 2000-2001 The OpenRPG Project
#
#    openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: mapper/whiteboard_hander.py
# Author: OpenRPG Team
# Maintainer:
# Version:
#   $Id: miniatures_handler.py,v 1.19 2005/03/06 01:50:32 digitalxero Exp $
#
# Description: Miniature layer handler
#
__version__ = "$Id: miniatures_handler.py,v 1.19 2005/03/06 01:50:32 digitalxero Exp $"


from base_handler import *
#from miniatures import *
from min_dialogs import *
import time


LABEL_TOOL = wxNewId()
LAYER_TOOL = wxNewId()
MIN_LIST_TOOL = wxNewId()
MIN_TOOL = wxNewId()
MIN_URL = wxNewId()
SERIAL_TOOL = wxNewId()

MIN_REMOVE = wxNewId()
MIN_PROP_DLG = wxNewId()
MIN_FACING_NONE = wxNewId()
MIN_FACING_MATCH = wxNewId()
MIN_FACING_EAST = wxNewId()
MIN_FACING_WEST = wxNewId()
MIN_FACING_NORTH = wxNewId()
MIN_FACING_SOUTH = wxNewId()
MIN_FACING_NORTHEAST = wxNewId()
MIN_FACING_SOUTHEAST = wxNewId()
MIN_FACING_SOUTHWEST = wxNewId()
MIN_FACING_NORTHWEST = wxNewId()
MIN_HEADING_NONE = wxNewId()
MIN_HEADING_MATCH = wxNewId()
MIN_HEADING_EAST = wxNewId()
MIN_HEADING_WEST = wxNewId()
MIN_HEADING_NORTH = wxNewId()
MIN_HEADING_SOUTH = wxNewId()
MIN_HEADING_NORTHEAST = wxNewId()
MIN_HEADING_SOUTHEAST = wxNewId()
MIN_HEADING_SOUTHWEST = wxNewId()
MIN_HEADING_NORTHWEST = wxNewId()
MIN_HEADING_SUBMENU = wxNewId()
MIN_FACING_SUBMENU = wxNewId()
MIN_ALIGN_SUBMENU = wxNewId()
MIN_ALIGN_GRID_CENTER = wxNewId()
MIN_ALIGN_GRID_TL = wxNewId()
MIN_TITLE_HACK = wxNewId()
MIN_TO_GAMETREE = wxNewId()

MIN_BACK_ONE = wxNewId()
MIN_FORWARD_ONE = wxNewId()
MIN_TO_BACK = wxNewId()
MIN_TO_FRONT = wxNewId()
MIN_LOCK_BACK = wxNewId()
MIN_LOCK_FRONT = wxNewId()
MIN_FRONTBACK_UNLOCK = wxNewId()
MIN_ZORDER_SUBMENU = wxNewId()

MAP_REFRESH_MINI_URLS = wxNewId()


class miniatures_handler(base_layer_handler):

    def __init__(self, parent, id, canvas):
        self.sel_min = None
        self.auto_label = 1
        self.use_serial = 1
        self.auto_label_cb = None
        base_layer_handler.__init__(self, parent, id, canvas)
        self.lasttime=time.clock()

    def build_ctrls(self):
        base_layer_handler.build_ctrls(self)

        # add controls in reverse order! (unless you want them after the default tools)

        auto_label = wxCheckBox(self, LABEL_TOOL, ' Auto Label ', (-1,-1),(-1,-1))
        self.auto_label_cb = auto_label
        auto_label.SetValue(self.auto_label)
        self.min_url = wxComboBox(self,MIN_URL,"http://",style=wxCB_DROPDOWN|wxCB_SORT)


        self.sizer.Prepend( createMaskedButton( self, orpg.dirpath.dir_struct["icon"]+'questionhead.gif', 'Edit miniature properties', MIN_LIST_TOOL ), 0, wxEXPAND )
        self.sizer.Prepend(wxSize(20,25))
        self.sizer.Prepend(wxButton(self, MIN_TOOL, "Add Miniature", style=wxBU_EXACTFIT), 0, wxEXPAND)
        self.sizer.Prepend(self.min_url, 1, wxALIGN_CENTER)
        self.sizer.Prepend(auto_label,0,wxALIGN_CENTER)
        self.sizer.Prepend(wxSize(10,25))

        #self.sizer.Fit(self)
        #self.SetAutoLayout(true)
        #self.SetSizer(self.sizer)

        EVT_BUTTON(self, MIN_LIST_TOOL, self.on_min_list)
        EVT_BUTTON(self, MIN_TOOL, self.on_miniature)
        EVT_CHECKBOX(self, LABEL_TOOL, self.on_label)


    def build_menu(self,label = "Miniature"):
        base_layer_handler.build_menu(self,label)

        self.main_menu.AppendSeparator()
        self.main_menu.Append(LABEL_TOOL,"&Auto label","",1)
        self.main_menu.Check(LABEL_TOOL,self.auto_label)
        self.main_menu.Append(SERIAL_TOOL,"&Number minis","",1)
        self.main_menu.Check(SERIAL_TOOL, self.use_serial)
        self.main_menu.Append(MAP_REFRESH_MINI_URLS,"&Refresh miniatures")       #  Add the menu item

        EVT_MENU(self.canvas,MAP_REFRESH_MINI_URLS,self.on_map_board_menu_item)          #  Set the handler
        EVT_MENU(self.canvas, LABEL_TOOL, self.on_label)
        EVT_MENU(self.canvas, SERIAL_TOOL, self.on_serial)

        # build miniature meenu

        self.min_menu = wxMenu()

        # Rectangles and hexagons require slightly different menus because of
        # facing and heading possibilities.
        heading_menu = wxMenu()
        face_menu = wxMenu()
        face_menu.Append(MIN_FACING_NONE,"&None")
        face_menu.Append(MIN_FACING_NORTH,"&North")
        face_menu.Append(MIN_FACING_NORTHEAST,"Northeast")
        face_menu.Append(MIN_FACING_EAST,"East")
        face_menu.Append(MIN_FACING_SOUTHEAST,"Southeast")
        face_menu.Append(MIN_FACING_SOUTH,"&South")
        face_menu.Append(MIN_FACING_SOUTHWEST,"Southwest")
        face_menu.Append(MIN_FACING_WEST,"West")
        face_menu.Append(MIN_FACING_NORTHWEST,"Northwest")
        heading_menu.Append(MIN_HEADING_NONE,"&None")
        heading_menu.Append(MIN_HEADING_NORTH,"&North")
        heading_menu.Append(MIN_HEADING_NORTHEAST,"Northeast")
        heading_menu.Append(MIN_HEADING_EAST,"East")
        heading_menu.Append(MIN_HEADING_SOUTHEAST,"Southeast")
        heading_menu.Append(MIN_HEADING_SOUTH,"&South")
        heading_menu.Append(MIN_HEADING_SOUTHWEST,"Southwest")
        heading_menu.Append(MIN_HEADING_WEST,"West")
        heading_menu.Append(MIN_HEADING_NORTHWEST,"Northwest")


        align_menu = wxMenu()
        align_menu.Append(MIN_ALIGN_GRID_CENTER,"&Center")
        align_menu.Append(MIN_ALIGN_GRID_TL,"&Top-Left")

        #  This is a hack to simulate a menu title, due to problem in Linux
        if wxPlatform == '__WXMSW__':
            self.min_menu.SetTitle(label)
        else:
            self.min_menu.Append(MIN_TITLE_HACK,label)
            self.min_menu.AppendSeparator()

        self.min_menu.Append(MIN_REMOVE,"&Remove")

        self.min_menu.Append(MIN_TO_GAMETREE,"To &Gametree")

        self.min_menu.AppendMenu(MIN_HEADING_SUBMENU,"Set &Heading",heading_menu)
        self.min_menu.AppendMenu(MIN_FACING_SUBMENU,"Set &Facing",face_menu)
        self.min_menu.AppendMenu(MIN_ALIGN_SUBMENU,"Snap-to &Alignment",align_menu)
        self.min_menu.AppendSeparator()
        zorder_menu = wxMenu()
        zorder_menu.Append(MIN_BACK_ONE,"Back one")
        zorder_menu.Append(MIN_FORWARD_ONE,"Forward one")
        zorder_menu.Append(MIN_TO_BACK,"To back")
        zorder_menu.Append(MIN_TO_FRONT,"To front")
        zorder_menu.AppendSeparator()
        zorder_menu.Append(MIN_LOCK_BACK,"Lock to back")
        zorder_menu.Append(MIN_LOCK_FRONT,"Lock to front")
        zorder_menu.Append(MIN_FRONTBACK_UNLOCK,"Unlock Front/Back")
        self.min_menu.AppendMenu(MIN_ZORDER_SUBMENU, "Miniature Z-Order",zorder_menu)

        #self.min_menu.Append(MIN_LOCK,"&Lock")
        self.min_menu.AppendSeparator()
        self.min_menu.Append(MIN_PROP_DLG,"&Properties")

        EVT_MENU(self.canvas, MIN_REMOVE, self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_TO_GAMETREE, self.on_min_menu_item)
        #EVT_MENU(self.canvas, MIN_LOCK, self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_PROP_DLG, self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_FACING_NONE,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_FACING_EAST,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_FACING_WEST,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_FACING_NORTH,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_FACING_SOUTH,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_FACING_NORTHEAST,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_FACING_SOUTHEAST,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_FACING_SOUTHWEST,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_FACING_NORTHWEST,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_HEADING_NONE,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_HEADING_EAST,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_HEADING_WEST,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_HEADING_NORTH,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_HEADING_SOUTH,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_HEADING_NORTHEAST,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_HEADING_SOUTHEAST,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_HEADING_SOUTHWEST,self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_HEADING_NORTHWEST,self.on_min_menu_item)

        EVT_MENU(self.canvas, MIN_ALIGN_GRID_CENTER, self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_ALIGN_GRID_TL, self.on_min_menu_item)

        EVT_MENU(self.canvas, MIN_BACK_ONE, self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_FORWARD_ONE, self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_TO_BACK, self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_TO_FRONT, self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_LOCK_BACK, self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_LOCK_FRONT, self.on_min_menu_item)
        EVT_MENU(self.canvas, MIN_FRONTBACK_UNLOCK, self.on_min_menu_item)



    def do_min_menu(self,pos):
        self.canvas.PopupMenu(self.min_menu,pos)


    def do_min_select_menu(self,min_list,pos):
        self.min_select_menu = wxMenu()
        self.min_select_menu.SetTitle("Select Miniature")
        menu_list = []
        loop_count = 0
        try:
            for m in min_list:
                menu_list.append(loop_count)
### Either use the miniatures label for the selection list

                if min_list[loop_count].label:
                    self.min_select_menu.Append(menu_list[loop_count],min_list[loop_count].label)
###
### Or use part of the images filename as an identifier
                else:
                    string_split = string.split(min_list[loop_count].path,"/",)
                    last_string = string_split[len(string_split)-1]
                    self.min_select_menu.Append(menu_list[loop_count],'Unlabeled - ' + last_string[:len(last_string)-4])
###
                EVT_MENU(self.canvas, menu_list[loop_count], self.min_selected)
                loop_count += 1
            self.canvas.PopupMenu(self.min_select_menu,pos)
        except:
            pass

    def min_selected(self,evt):
        self.canvas.Refresh(false)
        self.canvas.send_map_data()
        self.canvas.layers['miniatures'].id = evt.GetId()

    def on_left_down(self, evt):
        session = self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM) and (session.my_role()<>session.ROLE_PLAYER) and (session.use_roles()):
            self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be either a player or GM to use the miniature Layer")
            return
        min = 0
        dc = wxClientDC(self.canvas)
        self.canvas.PrepareDC(dc)
        dc.SetUserScale(self.canvas.layers['grid'].mapscale,self.canvas.layers['grid'].mapscale)
        pos = evt.GetLogicalPosition(dc)
        #pos = evt.GetPosition()
        if self.canvas.layers['miniatures'].id < 0:
            self.min_list =  self.canvas.layers['miniatures'].find_miniature(pos,true)
        min = None
        if not self.sel_min:
            try:
                if self.canvas.layers['miniatures'].id < 0:
                    if len(self.min_list) > 1:
                        self.do_min_select_menu(self.min_list,evt.GetPosition())
                    elif len(self.min_list) == 1:
                        min = self.min_list[0]
            except:
                pass
            if self.canvas.layers['miniatures'].id >= 0:
                min = self.min_list[self.canvas.layers['miniatures'].id]
                self.canvas.layers['miniatures'].id = -1

        if self.sel_min:
            grid = self.canvas.layers['grid']
            grid_pos = grid.grid_hit_test(pos)
            if grid_pos:
                topLeft = grid.get_top_corner(grid_pos)#  get the top corner for this grid cell
                if self.sel_min.snap_to_align == SNAPTO_ALIGN_CENTER:
                    if grid.get_mode() == 1:
                        x = ((topLeft.x/grid.size_ratio)-grid.unit_offset)+((grid.unit_widest/2) - (self.sel_min.bmp.GetWidth()/2))
                        y = topLeft.y + ((grid.unit_size_y - self.sel_min.bmp.GetHeight()) /2)
                    elif grid.get_mode() == 2:
                        x = (topLeft.x)-(self.sel_min.bmp.GetWidth()/2)
                        y = (topLeft.y)-(self.sel_min.bmp.GetHeight())
                    else:
                        x = topLeft.x + ((grid.unit_size - self.sel_min.bmp.GetWidth()) / 2)
                        y = topLeft.y + ((grid.unit_size_y - self.sel_min.bmp.GetHeight()) /2)

                else:
                    x = topLeft.x
                    y = topLeft.y
                self.sel_min.pos = cmpPoint(int(x),int(y))                                           #  Set the pos attribute
            else:
                self.sel_min.pos = cmpPoint(int(pos.x),int(pos.y))
            self.sel_min.selected = false
            self.sel_min = None
            self.canvas.Refresh(false)
            self.canvas.send_map_data()
        elif min:
            if self.sel_min:
                self.sel_min.selected = false
            self.sel_min = min
            self.sel_min.selected = true
            self.sel_min.draw(dc)
            self.lastx=pos.x
            self.lasty=pos.y
        del dc

    def on_left_up(self,evt):
        pass
#        if (self.sel_min):
#            self.on_left_down(evt)


    def on_right_down(self, evt):
        session = self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM) and (session.my_role()<>session.ROLE_PLAYER) and (session.use_roles()):
            self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be either a player or GM to use the miniature Layer")
            return
        min = 0
        self.sel_rmin = None
        dc = wxClientDC(self.canvas)
        self.canvas.PrepareDC(dc)
        dc.SetUserScale(self.canvas.layers['grid'].mapscale,self.canvas.layers['grid'].mapscale)
        pos = evt.GetLogicalPosition(dc)
        #pos = evt.GetPosition()
        if self.canvas.layers['miniatures'].id < 0:
            min_list = self.canvas.layers['miniatures'].find_miniature(pos)
        if not self.sel_rmin:
            try:
                if self.canvas.layers['miniatures'].id < 0:
                    if len(min_list) > 1:
                        self.do_min_select_menu(min_list,evt.GetPosition())
                    elif len(min_list) == 1:
                        min = min_list[0]
            except:
                base_layer_handler.on_right_down(self,evt)
                #self.do_map_board_menu(evt.GetPosition())

            if self.canvas.layers['miniatures'].id >= 0:
                min = min_list[self.canvas.layers['miniatures'].id]
                self.canvas.layers['miniatures'].id = -1

        #  End of left_down addition

            if min:
                self.sel_rmin = min
                pos = evt.GetPosition()
                #self.build_menu(min.label)
                self.do_min_menu(evt.GetPosition())
                self.sel_rmin = None
            elif self.sel_rmin:
                self.sel_rmin = None
                self.sel_rmin.selected = false
                self.Refresh(false)

        else:                                          # if not min_list, i.e. we right-clicked on the map board

            base_layer_handler.on_right_down(self,evt)
            #self.do_map_board_menu(evt.GetPosition())

        del dc

    def on_min_menu_item(self,evt):

        id = evt.GetId()
        if id == MIN_REMOVE:
            self.canvas.layers['miniatures'].del_miniature(self.sel_rmin)
            self.canvas.send_map_data()
        elif id == MIN_TO_GAMETREE:
            min_xml = self.sel_rmin.toxml(action="new",preserve_changed=1)
            node_begin = "<nodehandler module='map_miniature_nodehandler' class='map_miniature_handler' name='"

            if self.sel_rmin.label:
                node_begin += self.sel_rmin.label + "'"
            else:
                node_begin += "Unnamed Miniature'"

            node_begin += ">"
            gametree = self.canvas.frame.myopenrpg.get_component('tree')
            node_xml = node_begin + min_xml + '</nodehandler>'
            print "Sending this XML to insert_xml:" + node_xml
            gametree.insert_xml(node_xml)
        elif id == MIN_FACING_NONE:
            self.sel_rmin.face = FACE_NONE
            self.canvas.send_map_data()
        elif id == MIN_FACING_EAST:
            self.sel_rmin.face = FACE_EAST
            self.canvas.send_map_data()
        elif id == MIN_FACING_WEST:
            self.sel_rmin.face = FACE_WEST
            self.canvas.send_map_data()
        elif id == MIN_FACING_NORTH:
            self.sel_rmin.face = FACE_NORTH
            self.canvas.send_map_data()
        elif id == MIN_FACING_SOUTH:
            self.sel_rmin.face = FACE_SOUTH
            self.canvas.send_map_data()
        elif id == MIN_FACING_NORTHEAST:
            self.sel_rmin.face = FACE_NORTHEAST
            self.canvas.send_map_data()
        elif id == MIN_FACING_SOUTHEAST:
            self.sel_rmin.face = FACE_SOUTHEAST
            self.canvas.send_map_data()
        elif id == MIN_FACING_SOUTHWEST:
            self.sel_rmin.face = FACE_SOUTHWEST
            self.canvas.send_map_data()
        elif id == MIN_FACING_NORTHWEST:
            self.sel_rmin.face = FACE_NORTHWEST
            self.canvas.send_map_data()
        elif id == MIN_HEADING_NONE:
            self.sel_rmin.heading = FACE_NONE
            self.canvas.send_map_data()
        elif id == MIN_HEADING_EAST:
            self.sel_rmin.heading = FACE_EAST
            self.canvas.send_map_data()
        elif id == MIN_HEADING_WEST:
            self.sel_rmin.heading = FACE_WEST
            self.canvas.send_map_data()
        elif id == MIN_HEADING_NORTH:
            self.sel_rmin.heading = FACE_NORTH
            self.canvas.send_map_data()
        elif id == MIN_HEADING_SOUTH:
            self.sel_rmin.heading = FACE_SOUTH
            self.canvas.send_map_data()
        elif id == MIN_HEADING_NORTHEAST:
            self.sel_rmin.heading = FACE_NORTHEAST
            self.canvas.send_map_data()
        elif id == MIN_HEADING_SOUTHEAST:
            self.sel_rmin.heading = FACE_SOUTHEAST
            self.canvas.send_map_data()
        elif id == MIN_HEADING_SOUTHWEST:
            self.sel_rmin.heading = FACE_SOUTHWEST
            self.canvas.send_map_data()
        elif id == MIN_HEADING_NORTHWEST:
            self.sel_rmin.heading = FACE_NORTHWEST
            self.canvas.send_map_data()
        elif id == MIN_ALIGN_GRID_CENTER:
            self.sel_rmin.snap_to_align = SNAPTO_ALIGN_CENTER
            self.canvas.send_map_data()
        elif id == MIN_ALIGN_GRID_TL:
            self.sel_rmin.snap_to_align = SNAPTO_ALIGN_TL
            self.canvas.send_map_data()
        elif id == MIN_PROP_DLG:
            dlg = min_edit_dialog(self.canvas.frame.GetParent(),self.sel_rmin)
            if dlg.ShowModal() == wxID_OK:
                self.canvas.send_map_data()

        elif id == MIN_BACK_ONE:
            #  This assumes that we always start out with a z-order
            #     that starts at 0 and goes up to the number of
            #     minis - 1.  If this isn't the case, then execute
            #     a self.canvas.layers['miniatures'].collapse_zorder()
            #     before getting the oldz to test


            #  Save the selected minis current z-order
            oldz = self.sel_rmin.zorder

            # Make sure the mini isn't sticky front or back
            if (oldz != MIN_STICKY_BACK) and (oldz != MIN_STICKY_FRONT):
##                print "old z-order = " + str(oldz)

                self.sel_rmin.zorder -= 1

                #  Re-collapse to normalize
                #  Note:  only one update (with the final values) will be sent
                self.canvas.layers['miniatures'].collapse_zorder()


        elif id == MIN_FORWARD_ONE:
            #  This assumes that we always start out with a z-order
            #     that starts at 0 and goes up to the number of
            #     minis - 1.  If this isn't the case, then execute
            #     a self.canvas.layers['miniatures'].collapse_zorder()
            #     before getting the oldz to test

            #  Save the selected minis current z-order
            oldz = self.sel_rmin.zorder
##            print "old z-order = " + str(oldz)

            self.sel_rmin.zorder += 1

            #  Re-collapse to normalize
            #  Note:  only one update (with the final values) will be sent
            self.canvas.layers['miniatures'].collapse_zorder()


        elif id == MIN_TO_FRONT:
            #  This assumes that we always start out with a z-order
            #     that starts at 0 and goes up to the number of
            #     minis - 1.  If this isn't the case, then execute
            #     a self.canvas.layers['miniatures'].collapse_zorder()
            #     before getting the oldz to test

            #  Save the selected minis current z-order
            oldz = self.sel_rmin.zorder

            # Make sure the mini isn't sticky front or back
            if (oldz != MIN_STICKY_BACK) and (oldz != MIN_STICKY_FRONT):
##                print "old z-order = " + str(oldz)

                #  The new z-order will be one more than the last index
                newz = len(self.canvas.layers['miniatures'].miniatures)
##                print "new z-order = " + str(newz)

                self.sel_rmin.zorder = newz

                #  Re-collapse to normalize
                #  Note:  only one update (with the final values) will be sent
                self.canvas.layers['miniatures'].collapse_zorder()


        elif id == MIN_TO_BACK:
            #  This assumes that we always start out with a z-order
            #     that starts at 0 and goes up to the number of
            #     minis - 1.  If this isn't the case, then execute
            #     a self.canvas.layers['miniatures'].collapse_zorder()
            #     before getting the oldz to test


            #  Save the selected minis current z-order
            oldz = self.sel_rmin.zorder

            # Make sure the mini isn't sticky front or back
            if (oldz != MIN_STICKY_BACK) and (oldz != MIN_STICKY_FRONT):
##                print "old z-order = " + str(oldz)

                #  Since 0 is the lowest in a normalized order, be one less
                newz = -1
##                print "new z-order = " + str(newz)

                self.sel_rmin.zorder = newz


                #  Re-collapse to normalize
                #  Note:  only one update (with the final values) will be sent
                self.canvas.layers['miniatures'].collapse_zorder()


        elif id == MIN_FRONTBACK_UNLOCK:
            print "Unlocked/ unstickified..."
            if self.sel_rmin.zorder == MIN_STICKY_BACK:
                self.sel_rmin.zorder = MIN_STICKY_BACK + 1

            elif self.sel_rmin.zorder == MIN_STICKY_FRONT:
                self.sel_rmin.zorder = MIN_STICKY_FRONT - 1

        elif id == MIN_LOCK_BACK:
            print "lock back"
            self.sel_rmin.zorder = MIN_STICKY_BACK

        elif id == MIN_LOCK_FRONT:
            print "lock front"
            self.sel_rmin.zorder = MIN_STICKY_FRONT

        # Pretty much, we always want to refresh when we go through here
        # This helps us remove the redundant self.Refresh() on EVERY menu event
        # that we process above.
        self.canvas.Refresh(false)
        self.canvas.send_map_data()


    def on_miniature(self,evt):
        session = self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM) and (session.my_role()<>session.ROLE_PLAYER) and (session.use_roles()):
            self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be either a player or GM to use the miniature Layer")
            return
        min_url = self.min_url.GetValue()
        # build url
        if min_url == "" or min_url == "http://":
            return
        if min_url[:7] != "http://" :
            min_url = "http://"+min_url
        # make label
        if self.auto_label:
            start = min_url.rfind("/") + 1
            min_label = min_url[start:len(min_url)-4]
            if self.use_serial:
                #self.canvas.layers['miniatures'].serial_number = self.canvas.layers['miniatures'].serial_number + 1 # we're 1 indexed
                min_label = '%s %d' % ( min_label, self.canvas.layers['miniatures'].next_serial() )
        else:
            min_label = ""
        if self.min_url.FindString(min_url) == -1:
            self.min_url.Append(min_url)
        try:
            self.canvas.layers['miniatures'].add_miniature(self.canvas.frame.session.get_next_id(),min_url,label=min_label)
        except:
            # When there is an exception here, we should be decrementing the serial_number for reuse!!
            unablemsg= "Unable to load/resolve URL: " + min_url + " on resource \"" + min_label + "\"!!!\n\n"
            print unablemsg
            dlg =wxMessageDialog(self,unablemsg, 'Url not found',wxICON_EXCLAMATION)
            dlg.ShowModal()
            dlg.Destroy()
            self.canvas.layers['miniatures'].rollback_serial()

        self.canvas.send_map_data()
        self.canvas.Refresh(false)

        #except Exception, e:
            #wxMessageBox(str(e),"Miniature Error")

    def on_label(self,evt):
        self.auto_label = not self.auto_label
        self.auto_label_cb.SetValue(self.auto_label)
        #self.send_map_data()
        #self.Refresh()

    def on_min_list(self,evt):
        session = self.canvas.frame.session
        if (session.my_role() <> session.ROLE_GM):
            self.top_frame.myopenrpg.get_component("chat").InfoPost("You must be a GM to use this feature")
            return
        #d = min_list_panel(self.frame.GetParent(),self.canvas.layers,"Miniature list")
        d = min_list_panel(self.canvas.frame,self.canvas.layers,"Miniature list")
        if d.ShowModal() == wxID_OK:
            d.Destroy()
        self.canvas.Refresh(false)

    def on_serial(self, evt):
        self.use_serial = not self.use_serial

    def on_map_board_menu_item(self,evt):
        id = evt.GetId()
        if id == MAP_REFRESH_MINI_URLS:                          # Note: this doesn't change the mini, so no need to update the map
            for mini in self.canvas.layers['miniatures'].miniatures:       #  For all minis
                mini.set_bmp(load_img(mini.path,"miniature",mini))                    #  Reload their bmp member
            self.canvas.Refresh(false)
