/***********************************/
/* oroborus (c) Ken Lynch Jan 2001 */
/* Distributed under the GPL       */
/* See LICENSE for more details    */
/***********************************/

#include "oroborus.h"

#define MOUSE_STOPPED	-1
#define MOUSE_NORMAL	0
#define MOUSE_MOVE	1
#define MOUSE_RESIZE	2
#define MOUSE_CLOSE	3
#define MOUSE_HIDE	4

int mouse_x, mouse_y, mouse_mode=MOUSE_NORMAL;
Time last_button1_time;
#ifdef KEYBOARD_SUPPORT
int tab_client_state;
Time last_tab_time;
#endif

#ifdef KEYBOARD_SUPPORT

/*
 * 
 * Handle key press event
 *
 */

void event_key_press(XKeyEvent *ev)
{
  Client *c=NULL;

#ifdef DEBUG
  printf("event_handle_key_press\n");
#endif

  c=get_client_from_window(ev->window, WINDOW);

  ev->state=ev->state&(Mod1Mask|ControlMask|ShiftMask);
  
  /* If we have an active client */
  if(c!=NULL)
  {
    /* Maximize client */
    if(ev->keycode==config.keys.maximize.keycode && ev->state==config.keys.maximize.modifier)
      toggle_client_maximized(c);
      
    /* Shade client */
    if(ev->keycode==config.keys.shade.keycode && ev->state==config.keys.shade.modifier)
      toggle_client_shaded(c);

    /* Hide client */
    if(ev->keycode==config.keys.hide.keycode && ev->state==config.keys.hide.modifier)
      hide_client(c);
     
    /* Close client */ 
    if(ev->keycode==config.keys.close.keycode && ev->state==config.keys.close.modifier) 
      close_client(c); 
       
    /* Move client up */ 
    if(ev->keycode==config.keys.move_up.keycode && ev->state==config.keys.move_up.modifier)
    {
      mouse_mode=MOUSE_STOPPED; 
      move_client(c, c->x, c->y-10); 
    }
       
    /* Move client down */ 
    if(ev->keycode==config.keys.move_down.keycode && ev->state==config.keys.move_down.modifier)
    {
      mouse_mode=MOUSE_STOPPED; 
      move_client(c, c->x, c->y+10); 
    }
       
    /* Move client left */ 
    if(ev->keycode==config.keys.move_left.keycode && ev->state==config.keys.move_left.modifier)
    {
      mouse_mode=MOUSE_STOPPED; 
      move_client(c, c->x-10, c->y); 
    }
       
    /* Move client right */ 
    if(ev->keycode==config.keys.move_right.keycode && ev->state==config.keys.move_right.modifier) 
    {
      mouse_mode=MOUSE_STOPPED;
      move_client(c, c->x+10, c->y); 
    }
 
    if(!(get_gnome_hint(c->window, WIN_STATE)&WIN_STATE_MAXIMIZED) && !(get_gnome_hint(c->window, WIN_STATE)&WIN_STATE_SHADED)) 
    { 
      if(ev->keycode==config.keys.resize_up.keycode && ev->state==config.keys.resize_up.modifier) 
      {
        mouse_mode=MOUSE_STOPPED;
        resize_client(c, c->width, c->height-(c->size->flags&PResizeInc?c->size->height_inc:10), False); 
      }
      if(ev->keycode==config.keys.resize_down.keycode && ev->state==config.keys.resize_down.modifier) 
      {
        mouse_mode=MOUSE_STOPPED;
        resize_client(c, c->width, c->height+(c->size->flags&PResizeInc?c->size->height_inc:10), False);
      } 
      if(ev->keycode==config.keys.resize_left.keycode && ev->state==config.keys.resize_left.modifier) 
      {
        mouse_mode=MOUSE_STOPPED;
        resize_client(c, c->width-(c->size->flags&PResizeInc?c->size->width_inc:10), c->height, False);
      } 
      if(ev->keycode==config.keys.resize_right.keycode && ev->state==config.keys.resize_right.modifier) 
      {
        mouse_mode=MOUSE_STOPPED;
        resize_client(c, c->width+(c->size->flags&PResizeInc?c->size->width_inc:10), c->height, False); 
      }
    } 
     
#ifdef LAYER_SUPPORT 
    /* Raise client layer */ 
    if(ev->keycode==config.keys.raise_layer.keycode && ev->state==config.keys.raise_layer.modifier) 
      set_client_layer(c, get_client_layer(c)+1); 
       
    /* Lower client layer */ 
    if(ev->keycode==config.keys.lower_layer.keycode && ev->state==config.keys.lower_layer.modifier) 
      set_client_layer(c, get_client_layer(c)-1); 
#endif /* LAYER */ 
 
#ifdef WORKSPACE_SUPPORT 
    /* Toggle sticky */ 
    if(ev->keycode==config.keys.sticky.keycode && ev->state==config.keys.sticky.modifier) 
      toggle_client_sticky(c); 
       
    /* Move window to next workspace */ 
    if(ev->keycode==config.keys.move_next_ws.keycode && ev->state==config.keys.move_next_ws.modifier) 
      move_client_to_workspace(c, workspace+1); 
 
    /* Move window to prev workspace */ 
    if(ev->keycode==config.keys.move_prev_ws.keycode && ev->state==config.keys.move_prev_ws.modifier) 
      move_client_to_workspace(c, workspace-1); 
       
    /* Move window to specific workspace */ 
    if(ev->keycode==config.keys.move_ws_1.keycode && ev->state==config.keys.move_ws_1.modifier) 
      move_client_to_workspace(c, 0);      
    if(ev->keycode==config.keys.move_ws_2.keycode && ev->state==config.keys.move_ws_2.modifier) 
      move_client_to_workspace(c, 1); 
    if(ev->keycode==config.keys.move_ws_3.keycode && ev->state==config.keys.move_ws_3.modifier) 
      move_client_to_workspace(c, 2); 
    if(ev->keycode==config.keys.move_ws_4.keycode && ev->state==config.keys.move_ws_4.modifier) 
      move_client_to_workspace(c, 3); 
    if(ev->keycode==config.keys.move_ws_5.keycode && ev->state==config.keys.move_ws_5.modifier) 
      move_client_to_workspace(c, 4); 
    if(ev->keycode==config.keys.move_ws_6.keycode && ev->state==config.keys.move_ws_6.modifier) 
      move_client_to_workspace(c, 5); 
    if(ev->keycode==config.keys.move_ws_7.keycode && ev->state==config.keys.move_ws_7.modifier) 
      move_client_to_workspace(c, 6); 
    if(ev->keycode==config.keys.move_ws_8.keycode && ev->state==config.keys.move_ws_8.modifier) 
      move_client_to_workspace(c, 7); 
    if(ev->keycode==config.keys.move_ws_9.keycode && ev->state==config.keys.move_ws_9.modifier) 
      move_client_to_workspace(c, 8); 
#endif /* WORKSPACE */ 
  } 
 
  /* Next window */ 
  if(ev->keycode==config.keys.next_window.keycode && ev->state==config.keys.next_window.modifier) 
  { 
    Client *c2=NULL; 
 
    /* Check time of last tab */ 
    if(ev->time-last_tab_time<TAB_RAISE_TIMEOUT) 
    { 
     /* If window was hidden then hide it again */ 
     if(tab_client_state==IconicState && c!=NULL) 
        hide_client(c); 
    } 
    last_tab_time=ev->time; 
    if(c)
      c2=get_next_client(c);
    else if(client_list)
      c2=get_next_client(client_list->prev); 
    if(c2!=NULL) 
    { 
      tab_client_state=get_wm_state(c2->window); 
      raise_client(c2); 
      set_focus_client(c2); 
    } 
  }

  /* Previous window */ 
  if(ev->keycode==config.keys.prev_window.keycode && ev->state==config.keys.prev_window.modifier) 
  { 
    Client *c2=NULL; 
 
    /* Check time of last tab */ 
    if(ev->time-last_tab_time<TAB_RAISE_TIMEOUT) 
    { 
     /* If window was hidden then hide it again */ 
     if(tab_client_state==IconicState && c!=NULL) 
        hide_client(c); 
    } 
    last_tab_time=ev->time; 
    if(c)
      c2=get_prev_client(c);
    else if(client_list)
      c2=get_prev_client(client_list->next); 
    if(c2!=NULL) 
    { 
      tab_client_state=get_wm_state(c2->window); 
      raise_client(c2);
      set_focus_client(c2); 
    }
  } 
 
#ifdef WORKSPACE_SUPPORT   
  /* Switch to next workspace */ 
  if(ev->keycode==config.keys.next_ws.keycode && ev->state==config.keys.next_ws.modifier) 
    change_to_workspace(workspace+1); 
 
  /* Switch to prev workspace */ 
  if(ev->keycode==config.keys.prev_ws.keycode && ev->state==config.keys.prev_ws.modifier) 
    change_to_workspace(workspace-1); 
 
  /* Add new workspace */ 
  if(ev->keycode==config.keys.add_ws.keycode && ev->state==config.keys.add_ws.modifier) 
    set_gnome_hint(root, WIN_WORKSPACE_COUNT, config.workspace_count+1); 
 
  /* Delete last workspace */ 
  if(ev->keycode==config.keys.del_ws.keycode && ev->state==config.keys.del_ws.modifier) 
    set_gnome_hint(root, WIN_WORKSPACE_COUNT, config.workspace_count-1); 
 
  /* Switch to specific workspace */ 
  if(ev->keycode==config.keys.ws_1.keycode && ev->state==config.keys.ws_1.modifier) 
    change_to_workspace(0); 
  if(ev->keycode==config.keys.ws_2.keycode && ev->state==config.keys.ws_2.modifier) 
    change_to_workspace(1); 
  if(ev->keycode==config.keys.ws_3.keycode && ev->state==config.keys.ws_3.modifier) 
    change_to_workspace(2); 
  if(ev->keycode==config.keys.ws_4.keycode && ev->state==config.keys.ws_4.modifier) 
    change_to_workspace(3); 
  if(ev->keycode==config.keys.ws_5.keycode && ev->state==config.keys.ws_5.modifier) 
    change_to_workspace(4); 
  if(ev->keycode==config.keys.ws_6.keycode && ev->state==config.keys.ws_6.modifier) 
    change_to_workspace(5); 
  if(ev->keycode==config.keys.ws_7.keycode && ev->state==config.keys.ws_7.modifier) 
    change_to_workspace(6); 
  if(ev->keycode==config.keys.ws_8.keycode && ev->state==config.keys.ws_8.modifier) 
    change_to_workspace(7); 
  if(ev->keycode==config.keys.ws_9.keycode && ev->state==config.keys.ws_9.modifier) 
    change_to_workspace(8); 
#endif /* WORKSPACE */ 
} 
#endif /* KEYBOARD */ 
 
/* 
 * 
 * Handle button press events 
 * 
 */ 

void event_button_press(XButtonEvent *ev) 
{ 
  Client *c=NULL; 
  Window ptr_win; 
  int replay=False, focus=True, raise=True; 
 
#ifdef DEBUG 
  printf("event_button_press\n"); 
#endif 
 
  c=get_client_from_window(ev->window, FRAME); 

  ev->state=ev->state&(Mod1Mask|ControlMask|ShiftMask);
 
  /* Clicked on a client */ 
  if(c!=NULL) 
  { 
    ptr_win=get_pointer_win(c->frame); 
 
    /* If we want to resize */ 
    if((ptr_win==c->resize && ev->button==Button1 && ev->state==0) || (ev->button==Button2 && ev->state==(Mod1Mask|ControlMask))) 
    { 
      XGrabPointer(dpy, c->frame, False, PointerMotionMask|ButtonReleaseMask, GrabModeAsync, GrabModeAsync, None, resize_curs, CurrentTime); 
 
      /* Set mouse_x and mouse_y to position of cursor relative to southeast corner of window */ 
      mouse_x=FW-(ev->x_root-FX); 
      mouse_y=FH-(ev->y_root-FY); 
      mouse_mode=MOUSE_RESIZE; 
    } 
 
    /* If we want to hide */ 
    else if(ptr_win==c->hide && ev->button==Button1 && ev->state==0) 
    { 
      c->hide_state=BUTTON_PRESSED; 
      mouse_mode=MOUSE_HIDE; 
      XGrabPointer(dpy, c->frame, False, ButtonReleaseMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime); 
      redraw_client_buttons(c); 
    } 
 
    /* If we want to close */ 
    else if(ptr_win==c->close && ev->button==Button1 && ev->state==0) 
    { 
      c->close_state=BUTTON_PRESSED; 
      mouse_mode=MOUSE_CLOSE; 
      XGrabPointer(dpy, c->frame, False, ButtonReleaseMask, GrabModeAsync, GrabModeAsync, None, None, CurrentTime); 
      redraw_client_buttons(c); 
    } 
 
    /* If we want to move or maximize */ 
    else if((ptr_win!=c->window && ev->button==Button1 && ev->state==0) || (ev->button==Button1 && ev->state==(Mod1Mask|ControlMask))) 
    { 
      if(ev->time-last_button1_time<DBL_CLICK) 
      { 
        toggle_client_maximized(c); 
        last_button1_time=0; 
      } 
      else 
      { 
        XGrabPointer(dpy, c->frame, False, PointerMotionMask|ButtonReleaseMask, GrabModeAsync, GrabModeAsync, None, move_curs, CurrentTime); 
 
        /* Set mouse_x and mouse_y to position of cursor relative to root window */ 
        mouse_x=ev->x_root; 
        mouse_y=ev->y_root; 
        mouse_mode=MOUSE_MOVE; 
        last_button1_time=ev->time; 
      } 
    } 
 
    /* If we want to shade */ 
    else if(ptr_win!=c->window && ev->button==Button2 && ev->state==0) 
      toggle_client_shaded(c); 
 
    /* If we want to send to back */ 
    else if((ptr_win!=c->window && ev->button==Button3 && ev->state==0) || (ev->button==Button3 && ev->state==(Mod1Mask|ControlMask))) 
    { 
      lower_client(c); 
      raise=False; 
      focus=False; 
    } 
 
#ifdef WORKSPACE_SUPPORT 
    /* If we want to make window sticky */ 
    else if(ptr_win!=c->window && ev->button==Button2 && ev->state==Mod1Mask) 
      toggle_client_sticky(c); 
#endif /* WORKSPACE */ 
 
#ifdef LAYER_SUPPORT 
    /* If we want to move to a higher layer */ 
    else if(ptr_win!=c->window && ev->button==Button1 && ev->state==Mod1Mask) 
      set_client_layer(c, get_client_layer(c)+1); 
 
    /* If we want to send to a lower layer */ 
    else if(ptr_win!=c->window && ev->button==Button3 && ev->state==Mod1Mask) 
      set_client_layer(c, get_client_layer(c)-1); 
#endif /* LAYER */ 
    else 
      replay=True; 
 
    if(raise) raise_client(c); 
    if(focus) set_focus_client(c); 
 
    if(replay) 
      XAllowEvents(dpy, ReplayPointer, CurrentTime); 
    else 
      XAllowEvents(dpy, SyncPointer, CurrentTime); 
  } 
 
  /* Clicked on root */ 
  else 
  { 
    /* Proxy root click */ 
    XUngrabPointer(dpy, CurrentTime); 
    XSendEvent(dpy, check_win, False, SubstructureNotifyMask, (XEvent *)ev); 
  } 
} 
 
/* 
 * 
 * Handle button release events 
 * 
 */ 

void event_button_release(XButtonEvent *ev) 
{ 
  Client *c=NULL; 
 
#ifdef DEBUG 
  printf("event_button_release\n"); 
#endif 
 
  c=get_client_from_window(ev->window, FRAME); 
  if(c!=NULL) 
  { 
    c->hide_state=BUTTON_UNPRESSED; 
    c->close_state=BUTTON_UNPRESSED; 
    redraw_client_buttons(c); 
       
    /* Release occured on hide button */ 
    if(mouse_mode==MOUSE_HIDE && get_pointer_win(c->frame)==c->hide) 
      hide_client(c); 
 
    /* Release occured on close button */ 
    if(mouse_mode==MOUSE_CLOSE && get_pointer_win(c->frame)==c->close) 
      close_client(c);
 
    /* If we are resizing */
    if(mouse_mode==MOUSE_RESIZE)
      resize_client(c, c->width, c->height, False); 
 
    XUngrabPointer(dpy, CurrentTime); 
    mouse_mode=MOUSE_NORMAL;
  } 
 
  /* Release was on root window */ 
  else 
  { 
    /* Proxy root release */ 
    XSendEvent(dpy, check_win, False, SubstructureNotifyMask, (XEvent *)ev); 
  } 
} 
 
/* 
 * 
 * Handle motion notify events 
 * 
 */ 

void event_motion_notify(XMotionEvent *ev) 
{ 
  Client *c=NULL; 
  int height, width, dx, dy; 
  XEvent e; 
 
#ifdef DEBUG 
  printf("event_motion_notify\n"); 
#endif 
 
  /* If there are other motion events on this window, ignore this one */ 
  if(XCheckTypedWindowEvent(dpy, ev->window, MotionNotify, &e)) 
  { 
    XPutBackEvent(dpy, &e); 
    return; 
  }

  c=get_client_from_window(ev->window, FRAME); 
  if(c!=NULL) 
  { 
    /* If resizing */ 
    if(mouse_mode==MOUSE_RESIZE) 
    { 
      /* Don't allow resizing if maximized or shaded */ 
      if(get_gnome_hint(c->window, WIN_STATE)&(WIN_STATE_MAXIMIZED|WIN_STATE_SHADED)) 
        return; 
 
      width=(ev->x_root-FX-LW-RW)+mouse_x; 
      height=(ev->y_root-FY-TH-BH)+mouse_y; 
      resize_client(c, width, height, !config.continuous_resize); 
    } 
 
    /* If moving */ 
    else if(mouse_mode==MOUSE_MOVE) 
    { 
      dx=ev->x_root-mouse_x; 
      dy=ev->y_root-mouse_y; 
      mouse_x=ev->x_root; 
      mouse_y=ev->y_root; 
      move_client(c, c->x + dx, c->y + dy); 
    } 
  } 
} 
 
/* 
 * 
 * Handle enter notify events 
 * 
 */ 

void event_enter_notify(XCrossingEvent *ev) 
{ 
  Client *c=NULL; 
  XEvent e; 
 
#ifdef DEBUG 
  printf("event_enter_notify\n"); 
#endif 
 
  /* If there are other enter notify events, ignore this one */ 
  if(XCheckTypedEvent(dpy, EnterNotify, &e)) 
  { 
    XPutBackEvent(dpy, &e); 
    return; 
  } 
 
  if(config.focus_style==FOCUS_SLOPPY && mouse_mode!=MOUSE_STOPPED) 
  { 
    c=get_client_from_window(ev->window, FRAME); 
    set_focus_client(c);
  }
} 
 
/* 
 * 
 * Handle focus in events 
 * 
 */ 

void event_focus_in(XFocusChangeEvent *ev) 
{ 
  Client *c=NULL; 
  XEvent e; 
 
#ifdef DEBUG 
  printf("event_focus_in\n"); 
#endif 
 
  /* If there are other focus in events, ignore this one */ 
  if(XCheckTypedEvent(dpy, FocusIn, &e)) 
  { 
    XPutBackEvent(dpy, &e); 
    return; 
  } 
 
  c=get_client_from_window(ev->window, WINDOW); 
  if(c!=NULL) 
  { 
    if(config.raise_on_focus) 
      raise_client(c); 
    redraw_client_frame(c); 
  } 
  else 
    set_focus_client(get_top_most_client(WIN_LAYER_NORMAL)); 
} 
 
/* 
 * 
 * Handle focus out events 
 * 
 */ 

void event_focus_out(XFocusChangeEvent *ev) 
{ 
  Client *c=NULL; 
 
#ifdef DEBUG 
  printf("event_focus_out\n"); 
#endif 
 
  c=get_client_from_window(ev->window, WINDOW); 
  if(c!=NULL) 
    redraw_client_frame(c); 
} 
 
/* 
 * 
 * Handle destroy notify events 
 * 
 */  

void event_destroy_notify(XDestroyWindowEvent *ev) 
{ 
  Client *c; 
   
#ifdef DEBUG 
  printf("event_destroy_notify\n"); 
#endif 
 
  c=get_client_from_window(ev->window, WINDOW); 
  if(c!=NULL) 
    delete_client(c, False); 
} 
 
/* 
 * 
 * Handle unmap notify events 
 * 
 */ 

void event_unmap_notify(XUnmapEvent *ev) 
{ 
  Client *c=NULL; 
 
#ifdef DEBUG 
  printf("event_unmap_notify\n"); 
#endif 
 
  c=get_client_from_window(ev->window, WINDOW); 
  if(c!=NULL) 
  { 
    if(c->ignore_unmap) 
      c->ignore_unmap--; 
    else 
    { 
      delete_client(c, False); 
      set_focus_client(get_top_most_client(WIN_LAYER_NORMAL)); 
    } 
  } 
} 
 
/* 
 * 
 * Handle map request events 
 * 
 */ 
void event_map_request(XMapRequestEvent *ev) 
{ 
  Client *c=NULL; 
 
#ifdef DEBUG 
  printf("event_map_request\n"); 
#endif 
 
  c=get_client_from_window(ev->window, WINDOW); 
  if(c==NULL) 
    create_new_client(ev->window, True); 
  else 
  { 
    raise_client(c); 
    set_focus_client(c); 
  } 
} 
 
/* 
 * 
 * Handle configure request events 
 * 
 */ 

void event_configure_request(XConfigureRequestEvent *ev) 
{ 
  Client *c=NULL; 
  XWindowChanges wc; 
  XEvent e; 
 
#ifdef DEBUG 
  printf("event_configure_request\n"); 
#endif 
 
  /* If there are other configure requests on this window, ignore this one */ 
  if(XCheckTypedWindowEvent(dpy, ev->window, ConfigureRequest, &e)) 
  { 
    XPutBackEvent(dpy, &e); 
    return; 
  } 
 
  wc.x=ev->x; 
  wc.y=ev->y; 
  wc.width=ev->width; 
  wc.height=ev->height; 
  wc.sibling=ev->above; 
  wc.stack_mode=ev->detail; 
  wc.border_width=0; 
 
  c=get_client_from_window(ev->window, WINDOW); 
  if(c!=NULL) 
    configure_client(c, ev->value_mask, &wc, False); 
  else 
    XConfigureWindow(dpy, ev->window, ev->value_mask, &wc); 
} 
 
/* 
 *  
 * Handle property notify events 
 * 
 */ 

void event_property_notify(XPropertyEvent *ev) 
{ 
  Client *c=NULL; 
  long dummy; 
 
#ifdef DEBUG 
  printf("event_property_notify\n"); 
#endif 
 
  c=get_client_from_window(ev->window, WINDOW); 
  if(c!=NULL) 
  { 
    switch(ev->atom) 
    { 
    case XA_WM_NAME: 
      if(c->name) XFree(c->name); 
      XFetchName(dpy, c->window, &c->name); 
      XClearWindow(dpy, c->title); 
      redraw_client_title(c); 
      break; 
    case XA_WM_NORMAL_HINTS: 
      XGetWMNormalHints(dpy, c->window, c->size, &dummy); 
      break; 
    } 
  } 
#ifdef WORKSPACE_SUPPORT 
  else 
  { 
    if(ev->atom==gnome[WIN_WORKSPACE_COUNT]) 
      update_workspace_count(); 
  } 
#endif /* WORKSPACE */ 
} 
 
/* 
 * 
 * Handle client message events 
 * 
 */ 

void event_client_message(XClientMessageEvent *ev) 
{ 
  Client *c=NULL; 
 
#ifdef DEBUG 
  printf("event_client_message\n"); 
#endif 
 
  c=get_client_from_window(ev->window, WINDOW); 
  if(c!=NULL) 
  { 
    /* Client wants to minimise */ 
    if(ev->message_type==icccm[WM_CHANGE_STATE] && ev->format==32 && ev->data.l[0]==IconicState) 
      hide_client(c); 
 
    /* Client wants to toggle shaded state */ 
    if(ev->message_type==gnome[WIN_STATE] && ev->format==32 && ev->data.l[0]&WIN_STATE_SHADED) 
      toggle_client_shaded(c); 
       
#ifdef WORKSPACE_SUPPORT 
    /* Client wants to toggle sticky state */ 
    if(ev->message_type==gnome[WIN_STATE] && ev->format==32 && ev->data.l[0]&WIN_STATE_STICKY) 
      toggle_client_sticky(c); 
#endif /* WORKSPACE */ 
 
#ifdef LAYER_SUPPORT 
    /* Client wants to change layer */ 
    if(ev->message_type==gnome[WIN_LAYER] && ev->format==32) 
      set_client_layer(c, ev->data.l[0]); 
#endif /* LAYER */ 
  } 
  else if(ev->window==root)  
  { 
#ifdef WORKSPACE_SUPPORT 
    /* Change to new workspace */ 
    if(ev->message_type==gnome[WIN_WORKSPACE] && ev->format==32) 
      change_to_workspace(ev->data.l[0]); 
#endif /* WORKSPACE */ 
  } 
} 
 
#ifdef SHAPE_SUPPORT 
/* 
 * 
 * Handle shape events 
 * 
 */ 

void event_shape(XShapeEvent *ev) 
{ 
  Client *c=NULL; 
  XEvent e; 
 
#ifdef DEBUG 
  printf("event_shape\n"); 
#endif 
 
  c=get_client_from_window(ev->window, WINDOW); 
  if(c!=NULL) 
  { 
    /* If there are other shape events on this window, ignore this one */ 
    if(XCheckTypedWindowEvent(dpy, ev->window, shape_event, &e)) 
    { 
      XPutBackEvent(dpy, &e); 
      return; 
    } 
 
    set_client_shape(c); 
  } 
} 
#endif /* SHAPE */ 
 
/* 
 * 
 * Main event loop 
 * 
 */ 

void do_event_loop() 
{ 
#ifdef DEBUG 
  printf("do_event_loop\n"); 
#endif 
 
#ifdef KEYBOARD_SUPPORT
  XMapWindow(dpy, check_win);
  grab_keys(check_win); 
  set_focus_client(get_focus_client());
#endif 
 
  while(1) 
  { 
    XEvent ev;

    while(XPending(dpy)) 
    { 
      XNextEvent(dpy, &ev); 

      switch(ev.type) 
      { 
#ifdef KEYBOARD_SUPPORT 
      case KeyPress:
        event_key_press(&ev.xkey); 
        break; 
#endif /* KEYBOARD */ 
      case ButtonPress:
        event_button_press(&ev.xbutton); 
        break; 
      case ButtonRelease: 
        event_button_release(&ev.xbutton); 
        break; 
      case MotionNotify: 
        event_motion_notify(&ev.xmotion); 
        break; 
      case EnterNotify: 
        event_enter_notify(&ev.xcrossing);
        break; 
      case FocusIn: 
        event_focus_in(&ev.xfocus); 
        break; 
      case FocusOut: 
        event_focus_out(&ev.xfocus); 
        break; 
      case DestroyNotify: 
        event_destroy_notify(&ev.xdestroywindow); 
        break; 
      case UnmapNotify: 
        event_unmap_notify(&ev.xunmap); 
        break; 
      case MapRequest: 
        event_map_request(&ev.xmaprequest); 
        break; 
      case ConfigureRequest: 
        event_configure_request(&ev.xconfigurerequest); 
        break; 
      case PropertyNotify: 
        event_property_notify(&ev.xproperty); 
        break; 
      case ClientMessage: 
        event_client_message(&ev.xclient); 
        break; 
      default: 
#ifdef SHAPE_SUPPORT 
        if(shape && ev.type==shape_event) 
          event_shape((XShapeEvent *)&ev); 
#endif /* SHAPE */ 
        break; 
      }
    }

    if(mouse_mode==MOUSE_STOPPED) mouse_mode=MOUSE_NORMAL;
    usleep(5);
  } 
} 
