/***********************************/ 
/* oroborus (c) Ken Lynch Jan 2001 */ 
/* Distributed under the GPL       */ 
/* See LICENSE for more details    */ 
/***********************************/ 
 
#include "oroborus.h" 
#include "parse_rc.h" 
 
/* 
 * 
 * Free memory used for rc structure 
 * 
 */ 

void free_rc(RcStruct *rc_values) 
{ 
  int i; 
 
#ifdef DEBUG 
  printf("free_rc\n"); 
#endif 
 
  for(i=0;rc_values[i].option;i++) 
  { 
    if(rc_values[i].option) 
      free(rc_values[i].option); 
    if(rc_values[i].value) 
      free(rc_values[i].value); 
  } 
} 
 
/* 
 * 
 * Simple routine to parse rc file into structure 
 * 
 */ 

int parse_rc(char *rc_dir, char *rc_file, RcStruct *rc_values) 
{ 
  char *full_file_name=NULL, buf[1024], *lvalue=NULL, *rvalue=NULL; 
  FILE *file; 
  int i; 
 
#ifdef DEBUG 
  printf("parse_rc\n"); 
#endif 
 
  /* Build full file name from rc_dir and rc_file */ 
  if((full_file_name=malloc(strlen(rc_dir)+strlen(rc_file)+2))==NULL)
  { 
    fprintf(stderr, "%s: Memory allocation failed in function parse_rc.\n", PROGNAME);
    exit(1);
  } 

  sprintf(full_file_name, "%s/%s", rc_dir, rc_file); 

#ifdef DEBUG
  printf("  loading config file %s\n", full_file_name);
#endif
 
  /* Open file and parse into rc_values */ 
  if((file=fopen(full_file_name, "r"))) 
  { 
    while(fgets(buf, sizeof buf, file)) 
    { 
      lvalue=strtok(buf, "="); 
      if(lvalue) 
      { 
        for(i=0;rc_values[i].option;i++) 
        { 
          if(!strcmp(lvalue, rc_values[i].option)) 
          { 
            rvalue=strtok(NULL, "\n"); 
            if(rvalue) 
            { 
              if(rc_values[i].value) free(rc_values[i].value); 
              rc_values[i].value=strdup(rvalue); 
            } 
          } 
        } 
      } 
    } 
    fclose(file);
    free(full_file_name);
    return True; 
  } 

#ifdef DEBUG
  printf("  file not found\n");
#endif

  free(full_file_name); 
  return False; 
} 
