/*
 *
 * Copyright (C) 2005, 2006 Mekensleep
 *
 *	Mekensleep
 *	24 rue vieille du temple
 *	75004 Paris
 *       licensing@mekensleep.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * Authors:
 *  Johan Euphrosine <proppy@gmail.com>
 *  Cedric Pinson <cpinson@freesheep.org>
 *
 */
#ifndef _OSG_VIEWER_H
#define _OSG_VIEWER_H

#include <vector>
#include <osg/ref_ptr>
#include <string>
#include <SDL.h>
#include <SDL/SDL_events.h>

typedef std::vector<SDL_Event> EventList;

struct SDL_Surface;
namespace osgUtil
{
  class SceneView;
};
namespace osg
{
  class Group;
};

#define ASSERT(_condition) Assert::AssertMsg(_condition, #_condition, __FUNCTION__, __FILE__, __LINE__)
struct Assert
{
  static void AssertMsg(bool condition, const std::string& msg, const std::string& function, const std::string& file, int line);
};

struct osgViewer
{
  static int const WIDTH = 1024;
  static int const HEIGHT = 768;
  static int const BPP = 24;
  bool mRunning;
  double mDeltaTime;
  double mCurrentTime;
  double mPreviousTime;
  SDL_Surface* mSurface;
	EventList mEvents;
  osg::ref_ptr<osgUtil::SceneView> mSceneView;
  osg::ref_ptr<osg::Group> mSceneRoot;
  osgViewer();
  ~osgViewer();
  void Create(int width = WIDTH, int height = HEIGHT, int bpp = BPP, bool fullscreen = false);
  void Destroy();
  void Update();
	void Render();
  void Draw();
  void Cull();
	void SwapBuffer();

	EventList& GetEventList();

  bool GetRunning() const;
  osg::Group* GetRoot();
	osgUtil::SceneView* GetSceneView();
  const SDL_Event* GetLastEvent() const;
  float GetDeltaTime() const;
  float GetCurrentTime() const;
  float GetPreviousTime() const;
  void UpdateCurrentTime();
};

#endif
