
/******************************************************************************
**
**  Copyright (C) 2006 Brian Wotring.
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, view a current copy of the license
**  file here:
**
**      http://www.hostintegrity.com/osiris/LICENSE
**
******************************************************************************/

#include <stdio.h>
#include <stdarg.h>

#include "config.h"
#include "debug.h"


void OSI_DEBUG( const char *file, const char *function,
                const int line, char *message, ... )
{
#ifdef DEBUG
    va_list params;

    fprintf( stderr, "osiris[%s:%s: line(%d)]:", file, function, line );

    va_start( params, message );
    vfprintf( stderr, message, params );
    va_end( params );

    fprintf( stderr, "\n" );
#endif
}

