'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS28E04-100 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.TP
.B DS28E04
1-Wire EEPROM chip (4096-bit) with seven address inputs
.SH SYNOPSIS
4096-bit EEPROM, 2 port switch
.PP
.B 1C
[.]XXXXXXXXXXXX[XX][/[
.B latch.[0-1|ALL|BYTE]
|
.B PIO.[0-1|ALL|BYTE]
|
.B power
|
.B sensed.[0-1|ALL|BYTE]
|
.B polarity
|
.B por
|
.B set_alarm
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.PP
.I 1C
.SH SPECIAL PROPERTIES
.SS latch.0 latch.1 latch.ALL latch.BYTE
.I read-write, binary
.br
The 2 pins (PIO) latch a bit when their state changes, either externally, or through a write to the pin. 
.br
Reading the
.I latch
property indicates that the latch has been set.
.br
Writing any data to ANY 
.I latch 
will reset them all. (This is the hardware design).
.br
.I ALL
is all 
.I latch 
states, accessed simultaneously, comma separated.
.br
.I BYTE
references all channels simultaneously as a single byte. Channel 0 is bit 0.
.SS PIO.0 PIO.1 PIO.ALL PIO.BYTE
.I read-write, yes-no
.br
State of the open-drain output (
.I PIO
) pin. 0 = non-conducting = off, 1 = conducting = on.
.br
Writing zero will turn off the switch, non-zero will turn on the switch. Reading the
.I PIO
state will return the switch setting. To determine the actual logic level at the switch, refer to the
.I sensed.0 sensed.1 sensed.ALL sensed.BYTE
property.
.br
.I ALL
references all channels simultaneously, comma separated.
.br
.I BYTE
references all channels simultaneously as a single byte. Channel 0 is bit 0.
.SS power
.I read-only, yes-no
.br
Is the
.I DS28E04
powered parasitically (=0) or separately on the Vcc pin (=1)?
.SS sensed.0 sensed.1 sensed.ALL sensed.BYTE
.I read-only, yes-no
.br
Logic level at the
.I PIO
pin. 0 = ground. 1 = high (~2.4V - 5V ). Really makes sense only if the
.I PIO
state is set to zero (off), else will read zero.
.br
.I ALL
references all channels simultaneously, comma separated.
.br
.I BYTE
references all channels simultaneously as a single byte. Channel 0 is bit 0.
.SS polarity
.I read-only, yes-no
.br
Reports the state of the POL pin. The state of the POL pin specifies whether the PIO pins P0
and P1 power up high or low. The polarity of a pulse generated at a PIO pin is the opposite
of the pin's power-up state.
.TP
.I 0
PIO powers up 0
.TP
.I 1
PIO powers up 1
.PP
.SS por
.I read-write, yes-no
.br
Specifies whether the device has performed power-on reset. This bit can only
be cleared to 0 under software control. As long as this bit is 1 the device
will allways respond to a conditional search.
.SS set_alarm
.I read-write, integer unsigned (0-333)
.br
A number consisting of 3 digits XYY, where:
.TP
X
select source and logical term 
.br 
.I 0
PIO   OR 
.br 
.I 1
latch OR 
.br 
.I 2
PIO   AND 
.br 
.I 3
latch AND
.TP
Y
select channel and polarity
.br 
.I 0
Unselected (LOW) 
.br
.I 1
Unselected (HIGH) 
.br
.I 2
Selected    LOW 
.br
.I 3
Selected    HIGH
.PP
All digits will be truncated to the 0-3 range. Leading zeroes are optional. Low-order digit is channel 0.
.PP
Example:
.TP
133
Responds on Conditional Search when latch.1 or latch.0 are set to 1.
.TP
222
Responds on Conditional Search when sensed.1 and sensed.0 are set to 0.
.TP
000 (0)
Never responds to Conditional Search.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
Use the
.I set_alarm
property to set the alarm triggering criteria.
.SH DESCRIPTION
.so man3/description.3so
.SS DS28E04
The
.B DS28E04 (3)
is a memory chip that bends the unique addressing capabilities of the 
.I 1-wire
design. Some of the ID bits can be assigned by hardware.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS28E04.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
