//
// C++ Interface: tagselectionlistview.h
//
// Description: 
//
//
// Author: Benjamin Mesing <bensmail@gmx.net>, (C) 2004
//
// Copyright: See COPYING file that comes with this distribution
//
// The first version of this file was generated by umbrello 
// on Tue May 18 2004 at 20:13:27

#ifndef __TAGSELECTIONLISTVIEW_H_2004_05_18
#define __TAGSELECTIONLISTVIEW_H_2004_05_18

#include <string>
#include <iterator>
#include <assert.h>

#include <q3listview.h>
//Added by qt3to4:
#include <QMouseEvent>

#if 0
#include <tagcoll/CardinalityStore.h>
#include <tagcoll/OpSet.h>

#include <apt-front/forward.h>
#endif



#include "tagselectionview.h"
#include "taglistviewitem.h"
// #include "tagitem.h"

using namespace std;

namespace NPlugin
{
	class DebtagsPluginContainer;
}

// class TagListViewItem;
// class TagListItem;

namespace NWidgets
{


#if 0
using namespace aptFront::cache;
#endif


/** @brief This class offers a listview that allows the selection of multiple tags.
  *
  * The tags are arranged in a listview tree.
  *
  * I am really sorry not to offer a template class, but QT does not support signals and
  * slots for templates :-(
  * @author Benjamin Mesing
  */
class TagSelectionListView : public Q3ListView, public TagSelectionView 
{
	Q_OBJECT

	typedef ept::configuration::apt::cache::Tag Tag;
	typedef ept::configuration::apt::cache::Facet Facet;

	/** @brief The object used to access the tag collection.
	  *
	  * If this is 0, the tag selection will not be accessible, and no companion tags
	  * will be determined (i.e. if you select a tag, the selection will not be limited 
	  * according to this tag.)
	  */
	const NPlugin::DebtagsPluginContainer* _pContainer;
	/** Holds the items selected */
	set<TagItem*> _selected;
	string _filterByNamePattern;
protected:
	/** @brief This function makes all items in the tree visible.
	  *
	  * This is necessary as QListViewItem setVisible() also makes all beneath the parents visible,
	  * this behavoir is kinda odd because it does only occur if we go from a less detailed listview
	  * to a more detailed one.  
	  */
	void makeAllVisible();
	/** @returns if the handed list item is visible. */
	bool isVisible(const TagListViewItem* pItem)	{ return pItem->isVisible(); };
	/** @brief Hides all tags where selecting would result in an empty result list. 
	  * 
	  * This iterates over all visible items and checks if they may be selected according to
	  * the demand stated above. If #_pColl is not set (i.e. equals 0) the function does nothing.
	  * @pre all items that shall be processed must be visible. 
	  * @see #_filterByNamePattern, filter()
	  */
	void filterByTagSet();
	/** @brief Filters all items which contain filter in their longTagname.
	  * 
	  * Items will be compared against the _filterByNamePattern */
	virtual void filterByName();

	/** This runs the items through all filters available. */
	void filter();
	/** @brief Intercept the clicking of the right mouse button, and avoid selection by it. */
	virtual void contentsMousePressEvent(QMouseEvent* pE );

protected slots:
	void onContextMenuRequested(Q3ListViewItem* item, const QPoint& pos, int col);	
	/** This will be connected to the selection changed signal. It emits the 
	  * tagItemsSelected() signal. */
	virtual void onSelectionChanged();
public slots:
	/** Expands all nodes of the listview. */
	void expandAll();
	/** Collapses all nodes of the listview except the root. */
	void collapseAll();
	/** Sets the #_filterByNamePattern property. */
	void setFilterByNamePattern(const string& filterByNamePattern)  
		{ _filterByNamePattern=filterByNamePattern; filter(); }
public:
	/** @brief Constructor creates an empty list for selection of tags.
	  *
	  * Call loadTagDatabase() to fill the list with tags.
	  * @param pContainer the object used to access the #_pContainer property
	  */
	TagSelectionListView(QWidget *parent, const NPlugin::DebtagsPluginContainer* pContainer);
	/** This provides an STL compatible iterator over the datastructure. 
	  * 
	  * This uses the QListViewIterator as baseclass and inherits its functionality. Especially the 
	  * IteratorFlags are a very usefull feature.\n
	  * The constructor adds the QListViewItemIterator::Selectable flag as the root "/" which is
	  * not selectable should not be iterated
	  */
	class iterator : private Q3ListViewItemIterator,  
		public std::iterator<bidirectional_iterator_tag, TagSelectionListView*>
	{
		/** Stores the flag as the QListViewItemIterator copy ctor is buggy. */
		IteratorFlag _flags;
	public:
		/** For stl conformance. */
/*		typedef input_iterator_tag iterator_category;	// we do not have a random access iterator*/
		/** Create an iterator that iterates the items.
		  * @param _pSelectionView tag list view to be iterated
		  * @param flags QListViewItemIterator::IteratorFlag to be used
		  */
		iterator(TagSelectionListView* _pSelectionView, IteratorFlag flags) : 
			Q3ListViewItemIterator(_pSelectionView, flags) 
		{ 
			_flags = IteratorFlag(flags);
			if (current() == _pSelectionView->firstChild())
				operator++();	// skip the root element
		};
		/** Create an iterator that iterates all items except the root "/"*/
		iterator(TagSelectionListView* _pSelectionView) : 
			Q3ListViewItemIterator(_pSelectionView) 
		{ 
			_flags = IteratorFlag(); 
			operator++();	// skip the root element
		};
		/** Create an empty iterator.*/
		iterator() : 
			Q3ListViewItemIterator() 
		{ 
			_flags = IteratorFlag(0); 
		};
		
		/** Copy constructor - offered cause the QListViewItemIterator copy ctor is buggy. */
		iterator(const iterator& it) : Q3ListViewItemIterator(it.current(), it._flags) 
		{
			_flags = it._flags;
		};
	private:
		iterator& operator=(const iterator& it) { return *this; };
	public:
		
		/** Go to the next element. */
		using Q3ListViewItemIterator::operator++;
		/** Go to the previous element. */
		using Q3ListViewItemIterator::operator--;
		/** @returns the TagListViewItem referenced by the iterator. */
		TagListViewItem* operator*() 
		{	
			return static_cast<TagListViewItem*>(Q3ListViewItemIterator::operator*());
		}
		/** @returns a pointer to the TagListViewItem referenced by the iterator. */
		TagListViewItem* operator->() 
		{
			return static_cast<TagListViewItem*>(Q3ListViewItemIterator::operator*());
		}
		/** @returns if the two iterators point to the same object. */
		bool operator==(iterator it) 
		{
			return (current() == it.current());
		}
		/** @returns if the two iterators point to different objects. */
		bool operator!=(iterator it) 
		{
			return (current() != it.current());
		}
	};
	/** Not yet implemented. */
	class const_iterator
	{
	
	};

	/** @brief Creates an iterator that points to the first element.
	  * 
	  * @param flags QListViewItemIterator::IteratorFlag to be used, additionally the 
	  * QListViewItemIterator::Selectable flag will be added */
	iterator begin(Q3ListViewItemIterator::IteratorFlag flags)	{ return iterator(this, flags); };
	/** @brief Creates an iterator that points to the first element. */
	iterator begin()	{ return iterator(this); };
	/** @returns the element that follows the last element */
	iterator end()		{ return iterator(); };
	/** @returns the #_selected property. */
	set<TagItem*> selected()	{ return _selected; }
	/** @brief Returns the selected items as tags. */
	std::set<Tag> getSelectedTags();
	/** @brief Returns if any item is selected. */
	bool selectedEmpty()
	{ return _selected.empty(); }

	
	/** @returns the #_filterByNamePattern property. */
	const string& filterByNamePattern() const      { return _filterByNamePattern; }

	// documented in base class 
	// as a simple assumption this is true when the list is not empty
	virtual bool hasData() const { return childCount() != 0; };

	// documented in base class currently with empty implementation
	virtual void addTagItem(TagItem* pItem, TagItem* pParent=0) {};
	// documented in base class currently with empty implementation
	virtual void addTagItem(TagItem* pItem, const string& parentFullTagName) {};
	/** @brief Deselects the tag with the given name.
	  * 
	  * @param fullTagname tag to be deselected  */
	virtual void deselectTag(const string& fullTagname);
	/** @brief Deselects all tags. */
	virtual void deselectAll();
	/** @brief Clears the view and emits the tagItemsSelected() signal. */
	virtual void clear();
	// documented in baseclass
	///@todo covariant returns are currently not implemented by the gcc :-( Recheck it every new release!
//	virtual TagListViewItem* getTagItem(const string& fullName);
	virtual TagItem* getTagItem(const string& fullName);
	/** @brief Returns the first element that matches the given name.
	  * 
	  * Added for your convenience. This directly calls getTagItem(). */
	TagListViewItem* thisGetTagItem(const string& fullName)
	{ return static_cast<TagListViewItem*>(getTagItem(fullName)); };
	/** @brief Sets a new vocabulary data.
	  *
	  * Call this whenever you want to change the vocabulary data.\n
	  * Even if it is the same as the old one it will be reloaded. */
	virtual void loadVocabulary(const std::set<Facet>& vocabulary);
signals:
	/** @brief The signal will be emitted, whenever the selection changes.
	  *
	  * @param tags the items that were selected by the user.
	  * @implements signal_tagItemsSelected() */
	void tagItemsSelected(const set<TagItem*>& tags);
};

}	// namespace NWidgets

#endif // __TAGSELECTIONLISTVIEW_H_2004_05_18

