/*****************************************************************************
*
* Copyright (c) 2000 - 2013, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-442911
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <SimulationCommand.h>
#include <DataNode.h>

// ****************************************************************************
// Method: SimulationCommand::SimulationCommand
//
// Purpose: 
//   Init utility for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SimulationCommand::Init()
{

    SimulationCommand::SelectAll();
}

// ****************************************************************************
// Method: SimulationCommand::SimulationCommand
//
// Purpose: 
//   Copy utility for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void SimulationCommand::Copy(const SimulationCommand &obj)
{
    command = obj.command;

    SimulationCommand::SelectAll();
}

// Type map format string
const char *SimulationCommand::TypeMapFormatString = SIMULATIONCOMMAND_TMFS;
const AttributeGroup::private_tmfs_t SimulationCommand::TmfsStruct = {SIMULATIONCOMMAND_TMFS};


// ****************************************************************************
// Method: SimulationCommand::SimulationCommand
//
// Purpose: 
//   Default constructor for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SimulationCommand::SimulationCommand() : 
    AttributeSubject(SimulationCommand::TypeMapFormatString)
{
    SimulationCommand::Init();
}

// ****************************************************************************
// Method: SimulationCommand::SimulationCommand
//
// Purpose: 
//   Constructor for the derived classes of SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SimulationCommand::SimulationCommand(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SimulationCommand::Init();
}

// ****************************************************************************
// Method: SimulationCommand::SimulationCommand
//
// Purpose: 
//   Copy constructor for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SimulationCommand::SimulationCommand(const SimulationCommand &obj) : 
    AttributeSubject(SimulationCommand::TypeMapFormatString)
{
    SimulationCommand::Copy(obj);
}

// ****************************************************************************
// Method: SimulationCommand::SimulationCommand
//
// Purpose: 
//   Copy constructor for derived classes of the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SimulationCommand::SimulationCommand(const SimulationCommand &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    SimulationCommand::Copy(obj);
}

// ****************************************************************************
// Method: SimulationCommand::~SimulationCommand
//
// Purpose: 
//   Destructor for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SimulationCommand::~SimulationCommand()
{
    // nothing here
}

// ****************************************************************************
// Method: SimulationCommand::operator = 
//
// Purpose: 
//   Assignment operator for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

SimulationCommand& 
SimulationCommand::operator = (const SimulationCommand &obj)
{
    if (this == &obj) return *this;

    SimulationCommand::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SimulationCommand::operator == 
//
// Purpose: 
//   Comparison operator == for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SimulationCommand::operator == (const SimulationCommand &obj) const
{
    // Create the return value
    return ((command == obj.command));
}

// ****************************************************************************
// Method: SimulationCommand::operator != 
//
// Purpose: 
//   Comparison operator != for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SimulationCommand::operator != (const SimulationCommand &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SimulationCommand::TypeName
//
// Purpose: 
//   Type name method for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
SimulationCommand::TypeName() const
{
    return "SimulationCommand";
}

// ****************************************************************************
// Method: SimulationCommand::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SimulationCommand::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SimulationCommand *tmp = (const SimulationCommand *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SimulationCommand::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SimulationCommand::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SimulationCommand(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: SimulationCommand::NewInstance
//
// Purpose: 
//   NewInstance method for the SimulationCommand class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
SimulationCommand::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SimulationCommand(*this);
    else
        retval = new SimulationCommand;

    return retval;
}

// ****************************************************************************
// Method: SimulationCommand::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
SimulationCommand::SelectAll()
{
    Select(ID_command, (void *)&command);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SimulationCommand::SetCommand(const std::string &command_)
{
    command = command_;
    Select(ID_command, (void *)&command);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

const std::string &
SimulationCommand::GetCommand() const
{
    return command;
}

std::string &
SimulationCommand::GetCommand()
{
    return command;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SimulationCommand::SelectCommand()
{
    Select(ID_command, (void *)&command);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SimulationCommand::GetFieldName
//
// Purpose: 
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SimulationCommand::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_command: return "command";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SimulationCommand::GetFieldType
//
// Purpose: 
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeGroup::FieldType
SimulationCommand::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_command: return FieldType_string;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SimulationCommand::GetFieldTypeName
//
// Purpose: 
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

std::string
SimulationCommand::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_command: return "string";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SimulationCommand::FieldsEqual
//
// Purpose: 
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
SimulationCommand::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SimulationCommand &obj = *((const SimulationCommand*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_command:
        {  // new scope
        retval = (command == obj.command);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

