/*****************************************************************************
 *                                                                           *
 * Program:   paul                                                           *
 *            (P)rogramm zur (A)uswertung und (U)mformung von                *
 *            (L)aserbildern                                                 *
 * Uses:      GTK                                                            *
 * Modul:     messages.c                                                     *
 *            various output stuff                                           *
 * Author:    Andreas Tille                                                  *
 * Date:      18.09.1998                                                     *
 * Copyright: Andreas Tille, 1999; GNU Public License                        *
 *                                                                           *
 *****************************************************************************/

#include <stdlib.h>
#include "paul.h"
#include "callback.h"

enum { MESSAGE, WARNING, ERROR, LAST_TYPE };

static const char *MSG_TYPE[LAST_TYPE];

static void PrintIt(int type, const char *str)
{
  static GtkWidget *window = NULL; 
  GtkWidget *text, *button;

  if ( !gtk_main_level() ) { 
/* if ( 1 ) { */
    char *buf;

    buf = g_strdup_printf("%s: %s\n", MSG_TYPE[type], str);
    if ( type ) { fputs(buf, stderr); fflush(stderr); }      
    else        { fputs(buf, stdout); fflush(stdout); }
    FREE(buf);
    return;
  }

  if ( window ) gtk_widget_destroy(window);
  window = gtk_dialog_new();
  gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  gtk_signal_connect(GTK_OBJECT(window), "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);
  gtk_window_set_title(GTK_WINDOW(window), MSG_TYPE[type]);

  text = gtk_label_new(str);
  gtk_container_set_border_width(GTK_CONTAINER(GTK_DIALOG(window)->vbox), 10);
  gtk_container_add(GTK_CONTAINER(GTK_DIALOG(window)->vbox), text);

  button = CreateCancelButton(window, GTK_DIALOG(window)->action_area);
  GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
  gtk_widget_grab_default(button);
  
  gtk_widget_show_all(window);
}

static void Message(const char *str)
{
  PrintIt(MESSAGE, str);
}

static void Error(const char *str)
{
  PrintIt(ERROR, str);
}

static void Warning(const char *str)
{
  PrintIt(WARNING, str); 
}

void MessagesInit(void)
/* Initialize message functions
 */
{
  g_set_message_handler(Message);
  g_set_error_handler(Error);
  g_set_warning_handler(Warning);   

  MSG_TYPE[MESSAGE] = _("Message");
  MSG_TYPE[WARNING] = _("Warning");
  MSG_TYPE[ERROR]   = _("Error");
}

