from __future__ import (
    absolute_import,
    division,
    print_function,
    unicode_literals,
)

from pcs.test.tools.pcs_unittest import TestCase

from pcs.lib import tools


class EnvironmentFileToDictTest(TestCase):
    def test_success(self):
        data = """
# ignored comment
IgnoredOptionNoValue
NUMBER=10
OPTION=value # this is also value
ANOTHER ONE="complex value"
; another comment

"""
        expected = {
            "NUMBER": "10",
            "OPTION": "value # this is also value",
            "ANOTHER ONE": '"complex value"'
        }
        self.assertEqual(expected, tools.environment_file_to_dict(data))


class DictToEnvironmentFileTest(TestCase):
    def test_success(self):
        cfg_dict = {
            "OPTION": "value",
            "ANOTHER": "option value",
            "ANOTHER ONE": '"complex value"'
        }
        expected = """# This file has been generated by pcs.
ANOTHER=option value
ANOTHER ONE="complex value"
OPTION=value
"""
        self.assertEqual(expected, tools.dict_to_environment_file(cfg_dict))
