/*******************************************
 PDF Chain
 
 Copyright: 2009 Martin Singer
 <http://sourceforge.net/projects/pdfchain/>
 
 Author: Martin Singer
 <m_power3@users.sourceforge.net>
 
 License: GPL version 3+
 <http://www.gnu.org/licenses/>
 
 Tools
 src/update_info.hh
 *******************************************/

#ifndef PDF_CHAIN__TOOLS_UPDATE_INFO
#define PDF_CHAIN__TOOLS_UPDATE_INFO

#include "definings.hh"
#include "dialogs.hh"
#include "filechoosers.hh"

/*** Class ***/
class class_window_tools_update_info : public Gtk::Window{
	
	public:
		class_window_tools_update_info();
		virtual ~class_window_tools_update_info(){}; // Destruktor (inline)
		
		// Routines
		void set_dialogs(class_dialogs*);
		void clear();
		
	protected:
		
		// Windows
		class_dialogs *pt_dialogs;
		
		// Widgets
		Gtk::VBox
			vbox_window;
		
		Gtk::HBox
			hbox_sourcefile,
		hbox_dumpfile,
		hbox_selection,
		hbox_save;
		
		Gtk::Frame
			frame_sourcefile,
		frame_dumpfile;
		
		Gtk::Entry
			entry_sourcefile,
		entry_dumpfile;
		
		Gtk::Button
			button_sourcefile,
		button_dumpfile,
		button_save;
		
		Gtk::Alignment
			alignment_save;
		
		// Signal Handlers
		virtual void on_button_sourcefile();
		virtual void on_button_dumpfile();
		virtual void on_button_save();
};

#endif
