/*
 * window_main.cc
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "window_main.h"

/*** Menu Main ****************************************************************/

// Constructor
cMenu_Main::cMenu_Main( Gtk::Window* pt_window )
{
	pWindow		= pt_window;

	rAGroup		= Gtk::ActionGroup::create();
	rUIManager	= Gtk::UIManager::create();

	Glib::ustring ui_menu;
	
	rAGroup->add( Gtk::Action::create( "menu_main_file"						, _("_File")						) );
	//rAGroup->add( Gtk::Action::create( "menu_main_file_new"					, Gtk::Stock::NEW					) , sigc::mem_fun( *this , &cMenu_Main::onFile_New			) );	//TODO
	rAGroup->add( Gtk::Action::create( "menu_main_file_quit"				, Gtk::Stock::QUIT					) , sigc::mem_fun( *this , &cMenu_Main::onFile_Quit				) );
	//rAGroup->add( Gtk::Action::create( "menu_main_file_copy_command"		, _("_Copy command to clipboard")	) , sigc::mem_fun( *this , &cMenu_Main::onFile_CopyCommand		) );	//TODO
	rAGroup->add( Gtk::Action::create( "menu_main_help"						, _("_Help")						) );
	//rAGroup->add( Gtk::Action::create( "menu_main_help_homepage"			, _("Project Homepage")				) , sigc::mem_fun( *this , &cMenu_Main::onHelp_Homepage			) );	//TODO
	//rAGroup->add( Gtk::Action::create( "menu_main_help_translate"			, _("Translate")					) , sigc::mem_fun( *this , &cMenu_Main::onHelp_Translate		) );	//TODO
	//rAGroup->add( Gtk::Action::create( "menu_main_help_help"				, Gtk::Stock::HELP					) , sigc::mem_fun( *this , &cMenu_Main::onHelp_Help				) );	//TODO
	rAGroup->add( Gtk::Action::create( "menu_main_help_about"				, Gtk::Stock::ABOUT					) , sigc::mem_fun( *this , &cMenu_Main::onHelp_About			) );

	rUIManager->insert_action_group( rAGroup );
	pWindow->add_accel_group( rUIManager->get_accel_group() );	// add shortcuts
	
	ui_menu =
		"<ui>																"
		"	<menubar name='menu_main'>										"
		"		<menu action='menu_main_file'>								"
//		"			<menuitem action='menu_main_file_new'/>					"
		"			<menuitem action='menu_main_file_quit'/>				"
//		"			<menuitem action='menu_main_file_copy_command'/>		"
		"		</menu>														"
		"		<menu action='menu_main_help'>								"
//		"			<menuitem action='menu_main_help_homepage'/>			"
//		"			<menuitem action='menu_main_help_translate'/>			"
//		"			<separator/>											"
//		"			<menuitem action='menu_main_help_help'/>				"
		"			<menuitem action='menu_main_help_about'/>				"
		"		</menu>														"
		"	</menubar>														"
		"</ui>																";

#ifdef GLIBMM_EXCEPTIONS_ENABLED
	
	try {
		rUIManager->add_ui_from_string( ui_menu );
	}

	catch ( const Glib::Error& ex ) {
		std::cerr << std::endl << "ERROR at 'cMenu_Main::cMenu_Main()': Building menus failed - " << ex.what();
	}

#else

	std::auto_ptr<Glib::Error> ex;
	rUIManager->add_ui_from_string( ui_menu , ex );

	if ( ex.get() ) {
		std::cerr << std::endl << "ERROR at 'cMenu_Main::cMenu_Main()': Building menus failed - " << ex.what();
	}

#endif

}


// Destructor
cMenu_Main::~cMenu_Main()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cMenu_Main::~cMenu_Main()";	//TEST
#endif
}



/*** Notebook Sections ********************************************************/

// Constructor
cNotebook_Sections::cNotebook_Sections( Gtk::Window& ref_window )
:
	mSection_Cat(		ref_window ),
	mSection_Burst(		ref_window ),
	mSection_BgSt(		ref_window ),
	mSection_Attach(	ref_window ),
	mSection_Tool(		ref_window ),
	mLabel_Cat(		_("_Concatenate")			, true ),	// label , mnemonic
	mLabel_Burst(	_("_Burst")					, true ),
	mLabel_BgSt(	_("Background / _Stamp")	, true ),
	mLabel_Attach(	_("Attach_ment")			, true ),
	mLabel_Tool(	_("_Tools")					, true )
{
	set_scrollable( true );

	mLabel_Cat.set_tooltip_text(	_("Concatenates several PDF files into one PDF file")		);
	mLabel_Burst.set_tooltip_text(	_("Splits a PDF file into its individual pages")			);
	mLabel_BgSt.set_tooltip_text(	_("Adds a background or stamp on every page of a PDF file")	);
	mLabel_Attach.set_tooltip_text(	_("Attaches several files at a PDF file")					);
	mLabel_Tool.set_tooltip_text(	_("Some different Tools")									);
	
	append_page( mSection_Cat		, mLabel_Cat	);	// child_widget , tab_label_widget
	append_page( mSection_Burst		, mLabel_Burst	);
	append_page( mSection_BgSt		, mLabel_BgSt	);
	append_page( mSection_Attach	, mLabel_Attach	);
	append_page( mSection_Tool		, mLabel_Tool	);
}


// Destructor
cNotebook_Sections::~cNotebook_Sections()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cNotebook_Sections::~cNotebook_Sections()";	//TEST
#endif
}



/*** HBox : Save **************************************************************/

// Constructor
cHBox_Save::cHBox_Save()
:
	Gtk::HBox( false , Pdfchain::SPACING ),	// homogenous , spacing
	mButton_SaveAs( Gtk::Stock::SAVE_AS )
{
	pack_start( mPBar_Save		, true	, true	, Pdfchain::PADDING );
	pack_start( mButton_SaveAs	, false	, false	, Pdfchain::PADDING );
}


// Destructor
cHBox_Save::~cHBox_Save()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cHBox_Save::~cHBox_Save()";	//TEST
#endif
}


/*** Window : Main ************************************************************/

// Constructor
cWindow_Main::cWindow_Main()
:
	mMenu_Main( this ),
	mNotebook_Sections( *this ),
	mMDialog_PdftkError( *this )
{
	//Pdfchain::pWindow	= this;
	Pdfchain::pSBar		= &mSBar_Main;

	Glib::RefPtr<Gio::File>	ref_icon_path_A = Gio::File::create_for_path( Pdfchain::APPICON_PATH_A );
	Glib::RefPtr<Gio::File>	ref_icon_path_B = Gio::File::create_for_path( Pdfchain::APPICON_PATH_B );
	
	if		( ref_icon_path_A->query_exists() )	set_default_icon_from_file( Pdfchain::APPICON_PATH_A );
	else if	( ref_icon_path_B->query_exists() )	set_default_icon_from_file( Pdfchain::APPICON_PATH_B );
	else										std::cerr << std::endl << "Icon file doesn't exist! " << Pdfchain::APPICON_PATH_A << " , " << Pdfchain::APPICON_PATH_B;

	set_title( Pdfchain::Window::TITLE );
	set_default_size( Pdfchain::Window::WIDTH , Pdfchain::Window::HEIGHT );
	set_position( Gtk::WIN_POS_CENTER );
	
	pWidget_Menu = mMenu_Main.getWidget();

	mNotebook_Sections.set_sensitive( true );	//TODO: move to init()

	mVBox_Content.pack_start( mNotebook_Sections	, true	, true	, Pdfchain::PADDING );
	mVBox_Content.pack_start( mExpander_Permissions	, false	, false	, Pdfchain::PADDING );
	mVBox_Content.pack_start( mHBox_Save			, false	, false	, Pdfchain::PADDING	);

	mAlign_Content.set_padding( 0 , Pdfchain::BORDER , Pdfchain::BORDER , Pdfchain::BORDER );	// top , bottom , left , right
	mAlign_Content.add( mVBox_Content );

	mVBox_Main.pack_start( *pWidget_Menu			, false	, false	, Pdfchain::PADDING );	// widget , expand , fill , padding
	mVBox_Main.pack_start( mAlign_Content			, true	, true	, Pdfchain::PADDING );
	mVBox_Main.pack_start( mSBar_Main				, false	, false	, Pdfchain::PADDING );
	
	add( mVBox_Main );
	show_all_children();

														mHBox_Save.mButton_SaveAs.signal_clicked().connect( sigc::mem_fun( *this , &cWindow_Main::onButton_SaveAs_clicked ) );
	mConnection_NotebookSections_signal_switch_page =	mNotebook_Sections.signal_switch_page().connect( sigc::mem_fun( *this , &cWindow_Main::onNotebook_Sections_switch_page ) );
}


// Destructor
cWindow_Main::~cWindow_Main()
{
#ifdef PDFCHAIN_TEST
	std::cout << std::endl << "cWindow_Main::~cWindowMain()";	//TEST
#endif

	// The signal handler "onNotebook_Sections_switch_page" calls a method at the expander "mExpander_Permissions-object".
	// While destroying the notebook object, the signal "mNotebook_Sections.signal_switch_page()" could be emitted
	// while the mExpander_Permissions object is already destroyed.
	// To prevent a segmentation fault the signal handler is disconnected from the signal.
	mConnection_NotebookSections_signal_switch_page.disconnect();
}


// Method (protected) : confirm pdftk error code
void
cWindow_Main::confirmErrorCode( int error_code )
{	
	switch ( error_code ) {
		case 0:		std::cout << std::endl << "PDFTK returned: " << error_code	<< std::endl;					break;
		case 256:	mMDialog_PdftkError.popupMessage( _("Input/Output Error") , error_code );					break;
		case 512:	mMDialog_PdftkError.popupMessage( _("Unhandled Java exception at PDFTK") , error_code );	break;
		case 32512:	mMDialog_PdftkError.popupMessage( _("PDFTK-Command not found") , error_code );				break;
		default:	mMDialog_PdftkError.popupMessage( _("Unknown Error") , error_code );						break;
	}

	return;
}


// Signal Handler (protected) : on Button SaveAs clicked
void
cWindow_Main::onButton_SaveAs_clicked()
{
	std::string			str_command	= "";
	std::string			str_section	= "";
	int					error_code	= 0;
	const Gtk::Widget*	pt_page		= mNotebook_Sections.get_nth_page( mNotebook_Sections.get_current_page() );

	if		( pt_page == &(mNotebook_Sections.mSection_Cat) )		str_section = mNotebook_Sections.mSection_Cat.createCommand();
	else if ( pt_page == &(mNotebook_Sections.mSection_Burst) )		str_section = mNotebook_Sections.mSection_Burst.createCommand();
	else if ( pt_page == &(mNotebook_Sections.mSection_BgSt) )		str_section = mNotebook_Sections.mSection_BgSt.createCommand();
	else if ( pt_page == &(mNotebook_Sections.mSection_Attach) )	str_section = mNotebook_Sections.mSection_Attach.createCommand();
	else if ( pt_page == &(mNotebook_Sections.mSection_Tool) )		str_section = mNotebook_Sections.mSection_Tool.createCommand();
	
	if ( "" != str_section ) {
		str_command  = Pdfchain::Cmd::PDFTK;
		str_command += str_section;

		if ( pt_page != &(mNotebook_Sections.mSection_Tool) )
			str_command += mExpander_Permissions.createCommand();

		confirmErrorCode( Pdfchain::execute_command( str_command ) );
	}

	return;
}


// Signal Handler (protected) : on Notebook Sections switch page
void
cWindow_Main::onNotebook_Sections_switch_page( Widget* pt_page , guint page_num )
{
	if ( pt_page == &(mNotebook_Sections.mSection_Tool) ) {
		mExpander_Permissions.set_expanded( false );
		mExpander_Permissions.set_sensitive( false );
	}
	else {
		mExpander_Permissions.set_sensitive( true );
	}

	return;
}
