#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npstringarray.h"

int NP_Stringarray::remove_item( const char *item )
{
   if ( mutex )
      return 3;

   mutex = 1;
   
   if ( item == NULL )
   {
      strcpy( error_message, "NP_Stringarray: remove_item(): NULL item"
              " pointer passed as argument." );
      mutex = 0;
      return 1;
   }

   if ( item_list == NULL || total == 0 )
   {
      strcpy( error_message, "NP_Stringarray: remove_item(): there are no"
              " items currently stored in this object." );
      mutex = 0;
      return 2;
   }
   
   char **pointer = item_list;
   int i;
   for( i = 0; i < total; ++i )
   {
      if ( !strcmp( *pointer, item ))
         break;

      ++pointer;
   }

   if ( i == total )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Stringarray: remove_item(): no such item"
                " is stored in this object: %s.", item );
      mutex = 0;
      return 2;
   }

   mutex = 0;
   return remove_item( i );
}

int NP_Stringarray::remove_item( int i )
{
   if ( mutex )
      return 3;

   mutex = 1;
   
   if ( i >= total || i < 0 )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Stringarray: remove_item(): index out of range: %d.",
                i );
      mutex = 0;
      return 1;
   }

   if ( total == 1 )
   {
      if ( item_list != NULL )
      {
         if ( *item_list != NULL )
            free( *item_list );
      
         free( item_list );
         item_list = NULL;
      }
      
      total = 0;
      mutex = 0;
      return 0;
   }

   char **temp_list;
   if (( temp_list = ( char **)calloc( total - 1, sizeof *item_list ))
       == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   char **pointer = item_list;
   char **temp = temp_list;

   for( int j = 0; j < total; ++j )
   {
      if ( j == i )
      {
         if ( *pointer != NULL )
            free( *pointer );
         
         ++pointer;
         continue;
      }

      *temp = *pointer;

      ++pointer;
      ++temp;
   }

   free( item_list );
   item_list = temp_list;
   
   --total;
      
   mutex = 0;
   return 0;
}
