#define _GNU_SOURCE

class NP_Collections
{
   NP_Tree tree;

   GdkColor empty_col, read_col;
   GtkStyle *small_style, *empty_style, *unread_style, *read_style;
   GtkAccelGroup *accel_group;

   GtkWidget *window, *scroll, *tree_widget, 
      *message_window, *message_label, *message_button,
      *pixmapwid, *search_clist, *search_window, *transfer_window,
      *quantity_frame, *message_progress_bar, *search_label,
      *undelete_window, *undelete_clist, *undelete_label,
      *next_article_wid, *prev_article_wid, *next_unread_wid,
      *prev_unread_wid, *up_button, *down_button, *left_button, 
      *right_button, *font_button, *menu, *item, *first_item,
      *second_item, *third_item;

   GtkAdjustment *adjustment;
   GtkTooltips *tooltips;

   int transfer_quantity, transfer_what, summary_pipe_fds[ 2 ],
      feedback_pipe_fds[ 2 ], search_position, search_line,
      undelete_selection, deleted, button;

   FILE *summary_file, *feedback_file;

   gpointer selected_item;

   int summary_pid, launcher_pid, feedback_id, compose_pid;

   struct np_tree_nodes_t
   {
      GtkWidget *node, *label;
      int total_groups, total_messages, total_unseen,
         total_headers, total_requested;

      GtkWidget **group_nodes, **group_labels;
      int *messages, *unseen, *headers, *requested;
   }
   *tree_nodes;

   struct np_master_group_list_t
   {
      GtkWidget *node;
      int total, unseen;
   }
   *master_group_list;

   update_tree();
   void set_size();
   void save_size();

   NP_Stringarray children, search_results;
   
   int total_nodes, total_groups, total_unseen, total_headers,
      total_requested, total_messages,
      child_pid, callbacks_disabled, SIGPIPE_received,
      search_shown, what, quantity, stop;

   const char *home;
   char search_text[ 128 ];

   void expand_tree();
   do_all_servers( FILE *, NP_Stringarray& );
   do_one_server( char *, FILE *, NP_Stringarray& );
   void disable_callbacks( GtkWidget *, int );
   
 public:

   NP_Collections( int, char ** );
   ~NP_Collections();

   friend void before_transfer_hooks( NP_Collections * );
   friend void after_transfer_hooks( NP_Collections * );
	friend void startup_hooks( NP_Collections * );
   friend void exit_hooks( NP_Collections * );

   friend void exit_button_callback( GtkWidget *, gpointer );
   friend void expand_button_callback( GtkWidget *, gpointer );
   friend void contract_button_callback( GtkWidget *, gpointer );
   friend void launcher_button_callback( GtkWidget *, gpointer );
   friend int fonts_button_callback( GtkWidget *, GdkEvent * );
   friend void font_menu_callback( GtkWidget *, gpointer );
   friend void author_email_website_callback( GtkWidget *, gpointer );
   friend void help_button_callback( GtkWidget *, gpointer );

   friend void configure_button_callback( GtkWidget *, gpointer );
   friend void compose_button_callback( GtkWidget *, gpointer );
   friend void summary_button_callback( GtkWidget *, gpointer );
   friend void pack_button_callback( GtkWidget *, gpointer );
   friend void expire_button_callback( GtkWidget *, gpointer );
   friend void search_button_callback( GtkWidget *, gpointer );
   friend void transfer_button_callback( GtkWidget *, gpointer );
   friend void transfer_callback( GtkWidget *, gpointer );
   friend void radio_buttons_callback( GtkWidget *, gpointer );
   friend void spin_button_callback( GtkWidget *, gpointer );

   friend void down_button_callback( GtkWidget *, gpointer );
   friend void up_button_callback( GtkWidget *, gpointer );
   friend void left_button_callback( GtkWidget *, gpointer );
   friend void right_button_callback( GtkWidget *, gpointer );

   friend void tree_callback( GtkWidget *, gpointer );

   friend void regexp_entry_callback( GtkWidget *, gpointer );
   friend void search_clist_callback( GtkWidget *, gint, gint, GdkEvent *,
                                      gpointer );
   friend void close_search_button_callback( GtkWidget *, gpointer );
   friend void execute_search_button_callback( GtkWidget *, gpointer );
   
   void show_message( char *, int );
   friend void message_callback( GtkWidget *, gpointer );
   void update_message( char * );
   friend void stop_button_callback( GtkWidget *, gpointer );

   void fork_browser();

   friend void feedback_callback( gpointer, gint, GdkInputCondition );

   friend void undelete_button_callback( GtkWidget *, gpointer );
   friend void undelete_callback( GtkWidget *, gpointer );
   friend void undelete_all_callback( GtkWidget *, gpointer );
   friend void undelete_clist_callback( GtkWidget *, gint, gint, GdkEvent *,
                                        gpointer );
   friend void close_undelete_callback( GtkWidget *, gpointer );
   friend void remove_undelete_callback( GtkWidget *, gpointer ); 
   friend void remove_undelete_all_callback( GtkWidget *, gpointer );
   friend void undelete_refresh( NP_Collections * );

   friend void request_buttons_callback( GtkWidget *, gpointer );
                                     
   friend void SIGUSR1_handler( int );
   friend void SIGCHLD_handler( int );
   friend void SIGPIPE_handler( int );

   void run();
};


void SIGUSR2_handler( int );
void SIGTERM_handler( int );
void signal_handler( int );

void about_button_callback( GtkWidget *, gpointer );

