#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>

#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

int NP_Collections::update_tree()
{
   static running = 0;

   if ( running )
      return 0;

   running = 1;
   char *server = NULL, *group = NULL;

   if ( selected_item != NULL )
   {
      server = ( char *)gtk_object_get_data( GTK_OBJECT( selected_item ),
                                             "server" );

      if ( server != NULL )
         if (( server = strdup( server )) == NULL )
         {
            perror( "strdup" );
            exit( 1 );
         }

      group = ( char *)gtk_object_get_data( GTK_OBJECT( selected_item ),
                                            "group" );

      if ( group != NULL )
         if (( group = strdup( group )) == NULL )
         {
            perror( "strdup" );
            exit( 1 );
         }
   }

   int result = tree.update();
   if ( result )
   {
      if ( result == ENOENT )
      {
         GtkWidget *label = gtk_label_new( "UNCONFIGURED" );
         gtk_widget_show( label );
         gtk_scrolled_window_add_with_viewport( GTK_SCROLLED_WINDOW( scroll ), 
               label );
         running = 0;
         return 0;
      }

      tree.print_error();
      running = 0;
      return 1;
   }

   int nodes = 0, groups = 0, messages = 0,
      unseen = 0, requested = 0, headers = 0;
   if ( tree.get_totals( &nodes, &groups, &messages, &unseen, &requested,
                         &headers ))
   {
      tree.print_error();
      running = 0;
      return 1;
   }

   total_nodes = nodes;
   total_groups = groups;
   total_unseen = unseen;
   total_headers = headers;
   total_requested = requested;
   total_messages = messages;

   int l = 0;

   if ( master_group_list != NULL )
      free( master_group_list );

   master_group_list = 
      ( np_master_group_list_t *)calloc( sizeof *master_group_list, 
                                         total_groups );
   if ( master_group_list == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   if ( tree_nodes != NULL )
   {
      if ( total_nodes )
      {
         np_tree_nodes_t *pointer = tree_nodes;
         for( int i = 0; i < total_nodes; ++i )
         {
            char *data_p = ( char *)gtk_object_get_data(
               GTK_OBJECT( pointer->node ), "server" );

            gtk_object_remove_data( GTK_OBJECT( pointer->node ), "server" );

            if ( data_p != NULL )
               free( data_p );

            if ( pointer->total_groups )
            {
               GtkWidget **group_pointer = pointer->group_nodes;
               for( int j = 0; j < pointer->total_groups; ++j )
               {
                  data_p = ( char *)gtk_object_get_data(
                     GTK_OBJECT( *group_pointer ), "group" );

                  gtk_object_remove_data( GTK_OBJECT( *group_pointer ),
                                          "group" );
                  gtk_object_remove_data( GTK_OBJECT( *group_pointer ),
                                          "server" );

                  if ( data_p != NULL )
                     free( data_p );

                  ++group_pointer;
               }

               if ( pointer->group_nodes != NULL )
                  free( pointer->group_nodes );

               if ( pointer->group_labels != NULL )
                  free( pointer->group_labels );

               if ( pointer->messages != NULL )
                  free( pointer->messages );

               if ( pointer->unseen != NULL )
                  free( pointer->unseen );

               if ( pointer->headers != NULL )
                  free( pointer->headers );

               if ( pointer->requested != NULL )
                  free( pointer->requested );
            }

            ++pointer;
         }

         free( tree_nodes );
      }
   }

   total_nodes = nodes;

   if (( tree_nodes =
         ( np_tree_nodes_t *)calloc( nodes, sizeof *tree_nodes ))
         == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   NP_Stringarray node_array;

   if ( tree.get_nodes( node_array ))
   {
      tree.print_error();
      running = 0;
      return 1;
   }

   int total = node_array.get_total();
   if ( total < 0 )
   {
      node_array.print_error();
      running = 0;
      return 1;
   }

   if ( !total )
   {
      GtkWidget *label = gtk_label_new( "UNCONFIGURED" );
      gtk_widget_show( label );
      gtk_scrolled_window_add_with_viewport( GTK_SCROLLED_WINDOW( scroll ), 
                                             label );
      return 0;
   }

   // tree

   if ( tree_widget != NULL )
      gtk_widget_destroy( tree_widget );
   tree_widget = gtk_tree_new();

   gtk_widget_show( tree_widget );
   gtk_container_border_width( GTK_CONTAINER( tree_widget ), 10 );
   gtk_tree_set_selection_mode( GTK_TREE( tree_widget ),
                                GTK_SELECTION_SINGLE );
   gtk_signal_connect( GTK_OBJECT( tree_widget ), "selection_changed",
                       GTK_SIGNAL_FUNC( tree_callback ), this );
   gtk_signal_connect( GTK_OBJECT( tree_widget), "unselect_child",
                       GTK_SIGNAL_FUNC( tree_callback ), this );

   gtk_scrolled_window_add_with_viewport( GTK_SCROLLED_WINDOW( scroll ),
                                          tree_widget );

   if ( total )
      for( int i = 0; i < total; ++i )
      {
         NP_Stringarray group_array;
         
         if ( tree.get_groups( ( char *)node_array[ i ], group_array ))
         {
            tree.print_error();
            running = 0;
            return 1;
         }

         groups = messages = unseen = requested = headers = 0;
         
         if ( tree.get_node_stats( ( char *)node_array[ i ],
                                   &groups, &messages, &unseen, &requested,
                                   &headers ))
         {
            tree.print_error();
            running = 0;
            return 1;
         }

         tree_nodes[ i ].total_messages = messages;
         tree_nodes[ i ].total_groups = groups;
         tree_nodes[ i ].total_unseen = unseen;
         tree_nodes[ i ].total_headers = headers;
         tree_nodes[ i ].total_requested = requested;

         char buffer2[ 256 ];
         strcpy( buffer2, node_array[ i ] );

         for( char *pointer = buffer2; *pointer; ++pointer )
            *pointer = toupper( *pointer );

         char buffer1[ 128 ];
         snprintf( buffer1, sizeof buffer1, "\n%s:\n"
               "groups: %d\nunseen: %d\n"
               "total: %d\nrequested: %d\nheaders: %d\n",
               buffer2, groups, unseen, messages,
               requested, headers );

         tree_nodes[ i ].node = gtk_tree_item_new();
         gtk_widget_show( tree_nodes[ i ].node );
         GtkWidget *label = gtk_label_new( buffer1 );
         gtk_widget_show( label );
         gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
         gtk_container_add( GTK_CONTAINER( tree_nodes[ i ].node ), label );
         tree_nodes[ i ].label = label;
         
         char *node_name = ( char *)node_array[ i ];
         if ( node_name == NULL )
         {
            node_array.print_error();
            running = 0;
            return 1;
         }
         if (( node_name = strdup( node_name )) == NULL )
         {
            perror( "strdup" );
            exit( 1 );
         }
         gtk_object_set_data( GTK_OBJECT( tree_nodes[ i ].node ), "server",
                              node_name );
         gtk_tree_append( GTK_TREE( tree_widget ), tree_nodes[ i ].node );

         int group_total = group_array.get_total();
         if ( group_total < 0 )
         {
            group_array.print_error();
            running = 0;
            return 1;
         }

         if ( !group_total )
            continue;

         if (( tree_nodes[ i ].group_nodes =
               ( GtkWidget **)calloc( group_total,
                                      sizeof *tree_nodes[ i ].group_nodes ))
             == NULL )
         {
            perror( "calloc" );
            exit( 1 );
         }

         if (( tree_nodes[ i ].group_labels =
               ( GtkWidget **)calloc( group_total,
                                      sizeof *tree_nodes[ i ].group_labels ))
             == NULL )
         {
            perror( "calloc" );
            exit( 1 );
         }

         if (( tree_nodes[ i ].messages =
               ( int *)calloc( group_total,
                               sizeof *tree_nodes[ i ].messages ))
             == NULL )
         {
            perror( "calloc" );
            exit( 1 );
         }

         if (( tree_nodes[ i ].unseen =
               ( int *)calloc( group_total,
                               sizeof *tree_nodes[ i ].unseen ))
             == NULL )
         {
            perror( "calloc" );
            exit( 1 );
         }

         if (( tree_nodes[ i ].headers =
               ( int *)calloc( group_total,
                               sizeof *tree_nodes[ i ].headers ))
             == NULL )
         {
            perror( "calloc" );
            exit( 1 );
         }

         if (( tree_nodes[ i ].requested =
               ( int *)calloc( group_total,
                               sizeof *tree_nodes[ i ].requested ))
             == NULL )
         {
            perror( "calloc" );
            exit( 1 );
         }

         tree_nodes[ i ].total_groups = group_total;

         GtkWidget *subtree = gtk_tree_new();
         gtk_widget_show( subtree );

         for( int j = 0; j < group_total; ++j )
         {
            char *group = ( char *)group_array[ j ];

            messages = unseen = headers = requested = 0;
            
            if ( tree.get_group_stats( ( char *)node_array[ i ],
                                       group,
                                       &messages, &unseen,
                                       &requested, &headers ))
            {
               tree.print_error();
               running = 0;
               return 1;
            }

            master_group_list[ l ].total = messages;
            master_group_list[ l ].unseen = unseen;

            tree_nodes[ i ].messages[ j ] = messages;
            tree_nodes[ i ].unseen[ j ] = unseen;
            tree_nodes[ i ].headers[ j ] = headers;
            tree_nodes[ i ].requested[ j ] = requested;

            int outgoing = 0;

            if ( !strcmp( group, "OUTBOX" ) ||
                 !strcmp( group, "FOLLOW-UPS" ) ||
                 !strcmp( group, "SENT-MAIL" ) ||
                 !strcmp( group, "POSTED" ))
               outgoing = 1;
         
            if ( outgoing )
               snprintf( buffer1, sizeof buffer1, "%s:  %d",
                         group, messages );
            else
            {
               snprintf( buffer2, sizeof buffer2, "%d/%d",
                         unseen, messages );
               char buffer3[ 256 ];
               snprintf( buffer3, sizeof buffer3, ": %d/%d ", requested,
                         headers );
               snprintf( buffer1, sizeof buffer1, "%s:  %s %s",
                         group,
                         ( messages ? buffer2 : "" ),
                         ( headers ? buffer3 : "" ));
            }
            
            GtkWidget *group_item = gtk_tree_item_new();
            gtk_widget_show( group_item );

            label = gtk_label_new( buffer1 );
            GtkStyle *style = unread_style;
            if ( !messages )
               style = empty_style;
            else if ( !unseen )
               style = read_style;

            gtk_widget_set_style( label, style );
            gtk_widget_show( label );
            gtk_misc_set_alignment( GTK_MISC( label ), 0.0, 0.5 );
            gtk_container_add( GTK_CONTAINER( group_item ), label );

            gtk_tree_append( GTK_TREE( subtree ), group_item );
            tree_nodes[ i ].group_nodes[ j ] = group_item;
            tree_nodes[ i ].group_labels[ j ] = label;
            master_group_list[ l++ ].node = group_item;
            
            char *group_name;
            if (( group_name = strdup( group )) == NULL )
            {
               perror( "strdup" );
               exit( 1 );
            }
            gtk_object_set_data( GTK_OBJECT( group_item ), "server",
                                 node_name );
            gtk_object_set_data( GTK_OBJECT( group_item ), "group",
                                 group_name );
         }

         gtk_tree_item_set_subtree( GTK_TREE_ITEM( tree_nodes[ i ].node ),
                                    subtree );
      }

   expand_tree();
   
   if ( server != NULL )
   {
      int i = tree[ server ];
      if ( i < 0 )
      {
         if ( i != -2 )
            tree.print_error();
      }

      if ( group == NULL )
         gtk_tree_select_child( GTK_TREE( tree_widget ),
                                tree_nodes[ i ].node );
      else
      {
         int j = tree.get_group_index( server, group );
         if ( j < 0 )
         {
            if ( j != -2 )
               tree.print_error();
         }
         else
            gtk_tree_select_child( GTK_TREE( tree_widget ),
                        tree_nodes[ i ].group_nodes[ j ] );
      }
   }

   if ( server != NULL )
      free( server );

   if ( group != NULL )
      free( group );

   running = 0;

   return 0;
}
