#include "npconfig.h"

void NP_Config::busy_cursor_and_block_signals( int i )
{
   static GdkCursor *normal, *wait;
   
   if ( i )
   {
      normal = gdk_cursor_new(  GDK_TOP_LEFT_ARROW );
      wait = gdk_cursor_new( GDK_WATCH );
      gdk_window_set_cursor( lists_window->window, wait );
      gtk_widget_draw( lists_window, NULL );

      gtk_signal_handler_block( GTK_OBJECT( edit_group_clist ),
                                group_clist_id );
      gtk_signal_handler_block( GTK_OBJECT( list_clist ), list_clist_id );
      gtk_signal_handler_block_by_data( GTK_OBJECT( search_entry ), this );
      gtk_signal_handler_block_by_data( GTK_OBJECT( sort_active_button ),
                                        this );
      gtk_signal_handler_block_by_data( GTK_OBJECT( sort_subscribed_button ),
                                        this );
      gtk_signal_handler_block_by_data( GTK_OBJECT( ok_button ), this );
      gtk_signal_handler_block_by_data( GTK_OBJECT( cancel_button ), this );
      gtk_signal_handler_block_by_data( GTK_OBJECT( update_button ), this );
   }
   else
   {
      gdk_window_set_cursor( lists_window->window, normal );
      gtk_widget_draw( lists_window, NULL );
      gdk_cursor_destroy( normal );
      gdk_cursor_destroy( wait );

      gtk_signal_handler_unblock( GTK_OBJECT( edit_group_clist ),
                                  group_clist_id );
      gtk_signal_handler_unblock( GTK_OBJECT( list_clist ), list_clist_id );
      gtk_signal_handler_unblock_by_data( GTK_OBJECT( search_entry ),
                                          this );
      gtk_signal_handler_unblock_by_data( GTK_OBJECT( sort_active_button ),
                                          this );
      gtk_signal_handler_unblock_by_data( GTK_OBJECT( sort_subscribed_button ),
                                          this );
      gtk_signal_handler_unblock_by_data( GTK_OBJECT( ok_button ), this );
      gtk_signal_handler_unblock_by_data( GTK_OBJECT( cancel_button ), this );
      gtk_signal_handler_unblock_by_data( GTK_OBJECT( update_button ), this );
   }

   return;
}

