#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npsubscription.h"

int NP_Subscription::remove_server( int i )
{
   if ( !total )
   {
      strcpy( error_message, "NP_Subcription: remove_server(): "
              "no servers have been added to this object." );
      return 1;
   }
   
   if ( i < 0 || i >= total )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Subscription: remove_server(): "
                "server index out of range: %d.", i );
      return 1;
   }

   if ( server_names.remove_item( i ) )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Subscription: remove_server(): %s",
                server_names.get_error() );
      return 1;
   }
   
   group_list_t *pointer = group_list;

   if ( total == 1 )
   {
      if ( pointer->server != NULL )
         free( ( char *)pointer->server );

      delete pointer->group_names;
      delete pointer->article_nos;
      
      free( group_list );
      group_list = NULL;
      total = 0;

      return 0;
   }
   
   group_list_t *temp_list;
   if (( temp_list = ( group_list_t *)calloc( total - 1, sizeof *group_list ))
       == NULL )
   {
      perror( "calloc" );
      exit( 1 );
   }

   group_list_t *temp = temp_list;

   for( int j = 0; j < total; ++j )
   {
       if ( j == i )
       {
          if ( pointer->server != NULL )
             free( ( char *)pointer->server );

          if ( pointer->group_names != NULL )
          {
             delete pointer->group_names;
             delete pointer->article_nos;
          }
          
          ++pointer;
          continue;
       }

       temp->server = pointer->server;
       temp->group_names = pointer->group_names;
       temp->article_nos = pointer->article_nos;
       
       ++pointer;
       ++temp;
   }
   
   free( group_list );
   group_list = temp_list;

   if ( authentication.remove( i ))
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "remove_server(): %s", authentication.get_error() );
      return 1;
   }
   
   --total;

   return 0;
}

int NP_Subscription::remove_server( const char *server )
{
   if ( server == NULL )
   {
      strcpy( error_message, "NP_Subscription: remove_server(): "
              "NULL server name passed as argument." );
      return 1;
   }

   int i;
   if (( i = server_names[ server ] ) < 0 )
   {
      server_names.print_error();
      return 1;
   }

   return remove_server( i );
}
