# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is taken from www.openclipart.org (public domain)

from core import models
from core.translation import _t

#---PIL
def init():
    global Image, ImageFilter
    import Image, ImageFilter
    
def maximum(image,radius,amount=100):
    """Apply a filter
    - amount: 0-1"""
    maximumed  = image.filter(ImageFilter.MaxFilter(radius))
    if amount < 100:
        return Image.blend(image, maximumed, amount/100.0)
    return maximumed

#---Phatch
class Action(models.Action):
    label       = _t('Maximum')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    pil         = staticmethod(maximum)
    version     = '0.1'
    tags        = [_t('filter')]
    __doc__     = _t("Copies the maximum pixel value")
    
    def interface(self,fields):
        fields[_t('Radius')] = self.RankSizeField(self.RANK_SIZES[0])
        fields[_t('Amount')] = self.SliderField(100,1,100)
        
    icon = \
'x\xda\x01\xba\x08E\xf7\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x08qIDATh\x81\xd5\x99{\x8c\\U\x1d\xc7?\xe7\xdey\xcf\
\xcev\xf6\xbd[\xfa\xb0\x84%Bk\xe5Q\x82\x956\xa1\x98\xc66\xf5\x01!\xd4*Z\x81\
\x18\x95\x87`\x02$\x1acz\x0b\xc4\x88\x98(\x1a\xb4Q"V"\xda\x14\x8d\x84\x02\
\x02Q\x03RM\xd1j06\xe9c\xd7n\xdb\x9d\xd7nw\xe7\xb53s\xef\xdc\xc7\xf1\x8f3;\
\xddmw\xdb\x99e\xed\xca7\xb9\xd9\xbds~\xe7w\xbe\xdfs~\xbf\xdf9\xf7^\xc1\x1c\
\xb0s\x94-\xcbKW\xee:\x15\xfcO\xa2\x8a\xf9\xbc\x1e\xe0\'F\x07\x85\xb9\xf8z\
\xb7\x10\x8d\x18\x19\x12\x9f\x96\xe2\x83\x9e`-\x82\xb5\xa52\xdb"a4\tT\xab\
\x80\xcdD(\xc2\x16c1o\xfeo\xe9\x9e\x0b\xdf\xf9\x1a\x8d,qQ\xe5\x019\xc2\x03\
\x9eF\x9biB:\x03\x95\n\x8c\x8dB(\x02]\x1d\xa0\xe9\x84{|\xe8\x17\x8b\xf4T\xcc\
\xba\x02\x8f$Y\xefi\xecq]\xfa\xb2\xe3\x90\xcb\x83\xe7Q\x9e\x98\xa0(\xa1\x10\
\t\xd1\xe6INF[\xf8\xb9\x9b\xe3g\xcf~\x94\xd2\xc5$>\x89\x19\x05\x18\x19nF\xb2\
\xb7T\xc2w\xea\x14\x04\x83\x8c\xb6-\xe2\xce\xef_\xc9K\x17\x9b\xe0\x85p\x8e\
\x00#\xcd*\xe0@\xc5$2t\x1cb-\xfce\xc9\x1a\xd6\x1b\x02o\x01\xf8]\x103\xe5\xc0\
\xe3R\x12I\x0cC$\xc2\xc0\xd3\xd7q\xc3Eg\xd5\x04\xb4\xa97F\x86\xd5\xc0\xe6B\
\x01\x1c\x07\xaf5\xc2\xba\x05\xe2\xd50\xa6\t\xc0c\x13 \xf2y\x88Fy\xf3\xc9\
\x0f\x90Y\x18Z\x8dc\xba\x00\xc1:$\x94\xcb 4\x1e] NMA;\xeb\xfe\x06\xcb\x86H\
\x94\xca\xd3\xd7\xf0\xa7\x05a\xd4$\xea\x02\x1e\x1f%\x06\xb4\x9b\x15\x88\xc58\
\x82@. \xaf\x86Q\x17`W\x89\x038\x0e\x00\xce\x02\xf1i\x1au\x01\x8e\x8f\xb6\
\xc9\xff\xf5\xf7\xc8\xec\xc3\xd4}\xc0F\xc3\x07\xb1\x18\xb8\xaeZ\x8d\xf7\x02\
\xea+0\x96\xa7\xea\xb8\xe0\xba\x10\x0e\xd3k\xc8s\x12\xfc\xff\x12gH\x06\x18\
\xacT \x14\x06 \xa6eX\xb9P\xa4\x9aA]\xc0\x0f\xfb\xb1\xaa\x16Y\x01x\x12$\xdc\
\xb8p\xb4\x1a\xc7\xb40\xa9\x94\x19\x01\xc8\xe7@\xc2\xad\x0bC\xa99L\x13\xe0\
\xb8\x0c\x9a&\xb4\xb6\x02\xb0\xfe\xb1\x04K\x17\x84U\x13\x98& \xe8\xe7\x85\
\xf11\xd0t0M4G\xe7\x8b\x0bE\xacQL\x13\xb0\xb2\x95\xdd\xb9\x1c.@.\x0b\x08\xee\
5Fh\xb9\x18D\x8cQ.\x9f\xcbX\xd3\x04\xdc\xdf\x8f%4\x92fE\xed\xc8\xd2\xa3MH\
\x1e\x9c?\x9a\xb3\xc3\xad\xb2N\xb7\xb9\xa4\xd9~\xe7\xd4z\xdd\xcf\xbe\xd1Qh\
\x89A\xa1\x08R\xf2\x90\x91d\xd9\xfc\xd0\x9c\x1d%\x8b\x83\xa6\xc7\xc3\xcd\xf6\
;\xe7\x91\xf2\xab\xff$~<\xc5\xd8\xcaUh\x99\x0c,Ui\xbc\xbf\xaf\x87\r_\x12\xd8\
391\xd2tk\x82~\t\xbdR\x90\xc1\xe1\xb0\xb1\x98\xd3\xcd\x92y\xf0(\xaf\xc7\xe2\
\xec4\xbayk\xce\x02\x00n}\x9d\xa1\xc5},\xf7$\xb4\xb4@8\x0cH~l\xf4q\xcf\xa4\
\xcd\xb7\xc7YdV\xf9<\xf0i\xe0\xfa\xb3|y\xc0\x1bH~\xb4\xa3\x97\xdf\x88\x06\
\xcfV\xf7\xbe\xc35\x9a\x8f\xe7\x17\xb7p\xed\xd7\x97\x93\x9d\xb3\x80\xdb\xff\
\xcc=\x96\xc5SW\\\t\xe9\x14\\2\x19\x99\x92\xafhp\xc0\x13|\x19\xd8\x06D\x1a\
\x18\xe3\xaf:\xdc\xfe\xcd^\x8e7B\xe8s\xfby\xa9\xbb\x8b\xc8w\xfb\xb9\xa9\x11\
\xe13\x9ew\xfa\xff\xc0.\xc7\xc6*\x16\xd4\xe1\xaeX\xac[?\xe9\t\xde\x06\xeej\
\x90<\xc0Z\x17\x0e\x18I\xd64b\xec\xc6\xf8l*\xc5\x87\x1e\xc9\xb0\xad\x11\xfb\
\x19\x05\x18\x06\x9e\xcf\xc7\x9eTB%s\xb9\x0c\xae\x07\xcc\xfd\x80\xd7\x85\xc6\
~c\x98\xed\x172|n5Y\xdb#%\xe5\x99p=\x1ff%$\xe0~\xd3\xc6\xc9\x8eAg\'\x8cdxW\
\x0f\t\xe5\n\x01\xa9\xb1\xdbH\xf2\xcac\xa7\xcf_.\x85$\xe3z\xacj\xc4\xef\xac\
\x02\xf6n$\x1f\xf4\xf1\x8bTZ%JK\x0b$\x13\xaa\xb4zsx\xc5%\x80T\x1a\xca\x1569\
\x0e\xff\xda\x99b\xf3l\xb6\xc1\x00E\t\xf1\x1f\x1c#8g\x01\x00r\x9c\xbb=\x97\
\xe2\xd8\xb8\xca\x85Eq\x95\xd4CC\xb5\x90j\x02\xe10\xe4\xf3\xa0\xfb@z\xb4K\
\xc1\x8b;S3\xd7}_\x80\xa8O\x87\xf1(\xb1w%`\xefV\xaa\x91\x00\xdbM\x13l\x1bZ\
\xa2\xb0|\xb9:\xec\xe9\rf\xc3\xd4\xd5\xea\xee\x81\\A\xbd\xdd\x06t)\xf8\x8e\
\x91\xe6{RN\xaf\x86\x1a,\x03<\xfa\x18\xbf\x90\xff\x86\xbe\x0f\xac\xff%\x95\
\xae.B\x97]V\xdb\x13\x00\xd1PO\xa8Z\x10\x08\xd4F\x92p\xec\x18\xf4\xf5\x81?\
\x00\xc13\x01\xf2\x1cc\xdci\xac\xa4z\xd7[,\x0e\xc78\xde\xd5C\xce\xe8\xa5\xe7\
B\xfe\x1b\x9a\xc7p\x84\x9f\xe6\xf3p\xea\x94*\xa9\xb3\x91\x9f)7\\\x0fl\xb7v#\
\xd4\x19K\xf3\xc1\xf8x\xfd\r\x08\xc0gh\xe7\x05\xe3\x10\x01\x02\xechYD\x00\
\x18h\x84[C\x02^\xbb\x85\xfbCa2\x12%\xa0P\x00)\xd5U\'\xea\x82i\xaa/6\xae;\
\xfd\xf7\xc9p\xb3m\x08\x86\xc0\xa7\xab0\x9a\x98\x982\x88`\x13\x1d<kY|2\x1c\
\x04\x04G\xe7M\x00@k\x94\x1bKe\x1c\xcfS3\x9d\xcbA\xb9\xa2\xc4\x98\xa6Z\x95B\
\x11FFT\xdb$<\xa9\xdaA\xfd\x1e\x8b)\xe1\xe5R\xed\xc4;e\x12,\x8b\xadB\xa3\x1b\
\x01\xc2\xe3p#\xbc\xce\xfb\x89i*~\xb5\x81\xc3\xb7\xbd\xce\xcd\xc3\xc3\xec\
\xd34\xd0u\xd04hkW3\x1c\x8b\x81S\x85S\xc3\xd0\xd1\xa1.\x00\xd7\x81\xc4\xb0\
\xb2\x9f(\xc1\xe5\x97\xab\t(\x97U\x18E\xa3g\xf2*\x91\x84x\xab\xcaK\xa9qd^\
\x05\x00\xec\xdd\xc8Kw\x1d 3x\x9c\x9e|\x1e\x02~E"PKF\x9f\x0e\xd9q\xf0M\xf1*4\
\xb0,\xb5R\x1a\xea\xb2m\x18\x1bWW.\x0bK\x96\xaa\xc4\x9e(BW\xa7\xea\xa7i\x8d\
\x1d\xe6\x9a>\x1ah\x1a\xa9\xee.Xr\t\x04\x82\xc8b\x01N\x8f\xaa+\x9d\x06\xab\n\
\xa5\x12\x9c<\xa9\xc2C\xd7!\x99\xc4\x13:\x8e?\x08R@k\x8cW\xaf\xbe\x9a%+.\xe3\
\xa9\x8a\x85\x9dL\xc2\xf0\xb0\x12:Y\x17\xa5\xcb\x8e\xb3\xcb\xeb\xbc\x08\xe8\
\xee\xe6\r\x9f\x1f\xc6\xc6 \x1c\xa4\xb8v-\xe5\xa5\xcb \x1e\x87P\x08\x02\x01\
\xa4\xeeCV-5\xa3\xa1\x10Ew5\xa1H\x88C\x81 86\x08\x8d\xce]W\x91\xf8\xf5z\xee\
\xbb\x1b\xc2\x12\x063i%\xd8\xae\xd6\x04\xc0\x86\x9d\x19\xbe5\xef\x02rY:\x1d\
\x1b\x16\xf7A0@V\xd7\xc8\x85C*\x89#\x112\x7f\xff\x02Z\xac\x95\xd7:: \xd6\n~\
\x1f{\x0f\xae\xc1\xb6,\x02B\xaa\x98\x97\x1e\x95I\x7f[\xb7\xe2\xee\xdbB\xbf\
\xaes\xc2\x93\xeak\xe8\x14|\xcd\xc8\xf0\xd0\xbc\npe\xed|"\xa0\\A\x08\x9d\xa3\
B\xd4\x92YWm\xc1\x00n0T\xef\xd2\t\xe0\xf7\xa3wt\xd6\xf2C`M\xf5)\x04r\xdd5\
\xac\x0c\x87\xb0FF\xea;\xb5\x82\xe4\x89\x1d)v?\x91&:/\x02\xaaU\xfe\x06*^\x1d\
\x97\x18\xa8z\xed\xf7\x81\xed\xa8\xb7\n\xc1\x10\xb66\xe9Y\xd2^\xfb\xeb\xd4\
\x93[\x928\xdb\xef\xc3\xbd\x94V]\xca\xb5fE\xe5C\xb5:M\xe0\xf6\xb2 k\xa4\xd9o\
\xa4x\xc8\x90g\x8aO\xd3\x02\xf4Zy\xf3\xf9@\x80\xe6\xb9\xbc3\xd9\xe6y\xca\x9f\
\xae\x9d;[\xba\x9f\x9c\xdf_\x1f\xf5\x9d\xb3\xdb\x01\x1e\xed\xe7P{\x07\xbfK$`\
p\x10\xb2Y\xb5\x8f\x00H\x89\x1f\xf80\x82\'\x18a\xef\x9c\x05\x04}\xd8\x8e\xa3\
\xaa\x8d\xa6\xe3T+\x1c\x03\xb51\xd9\xb6\xaa\x1a\xc5"}\xc7\x06\xa0T\x06\x04e\
\x80x+\x9ae\xd57\xae\x7f\xcf\xe6\xff\xb7\x1b\xb9%\x12\xe1\xe0\x89!\x188\x06G\
\x0eC"\xa1\xc4\x98\xa6\x12$$\xd7O\xda7\xb5\x0f\x00d\x07\xbb7\xe8C\xab!6\x88\
\xd6q\xfc\xb4=\xda\xd1\xe7\x9dX\x81\xd6u\x94\xaaY\x10w<\xf3\xbex\xfa\x95U\
\xfdW|d\x1c-\x9b\xc4edh\xdb7\xd6-=\xfd\xb2w\xdd\xb2\x1bNb\xe9e\xfc\xad\xf9\n\
\x14g\x1d\xe3\xe5O\xb0\xe6c/\xf2\xa9\x89\tv\x8f\x8c\x10\x0cGj\x15.\xa8\xf6\
\x9a\xde)\xcf\xd7M\x0bH\xfe\xb1kg\xe7\x121p\xe9\x12\xf3\xf7Om\xe1\xc4m\xb7\
\xdd\xa4\x8f-\x1b~\xfb\xba5\xb8\xfe.\xba\x9f\xd90\x94\xbfcw\xdbF\xfb\xf4\x8a\
xu\xac\xc7\x8bv\x0f\xfd\xc3\xed\x10f\xbb\xa6m.\x0e,MD-/,\xed\xc2\x00\x1c<\
\xef8\xfb>\xce\x1e`\xcf\x8d\x06>\xed\xfd\xdc\xe7ylw\x1c\xe2\xa1\x10\xaf\xee\
\xba\x8a\xbb\'\xed\xfe\x0bf.D\xbc\xac\x02\x0bc\x00\x00\x00\x00IEND\xaeB`\x82\
\xd5\xad&f'
