#include "phluid.h"
#include "debug.h"

Display *disp;
Window root;
Visual *vis;
Colormap cm;
Imlib_Image bg_image;
Client *client_list_head = NULL;
XColor fg, bg, bd, dummyc;
Cursor move_curs, resize_curs, pointer_curs;
GC invert_gc;
int depth;
int screen;
int bw = 1;

int
main(int argc, char **argv)
{
  XEvent ev;
  Window dummyw1, dummyw2, *wins;
  XWindowAttributes attr;
  unsigned int nwins, i;

  init_signal();
  init_x();
  init_imlib();

  XQueryTree(disp, root, &dummyw1, &dummyw2, &wins, &nwins);
  for (i = 0; i < nwins; i++) {
    XGetWindowAttributes(disp, wins[i], &attr);
    {
      char *name, *dummy;
      XFetchName(disp, wins[i], &name);
      if (name && strcmp(name, "gkrellm") == 0) {
        XFree(name);
        continue;
      }
      dummy = malloc(sizeof(char) * 5);
      dummy[0] = '\0';
      if (name && strcmp(strncat(dummy, name, 4), "XMMS") == 0) {
        XFree(name);
        continue;
      }
    }
    if (!attr.override_redirect && attr.map_state == IsViewable)
      make_client(&wins[i]);
  }
  XFree(wins);

  XFlush(disp);

  /* main event loop */
  for (;;) {
    Client *c;
    XNextEvent(disp, &ev);
    switch (ev.type) {
      case ButtonPress:
        button_press(ev);
        break;
      case MotionNotify:
        motion_notify(ev);
        break;
      case MapRequest:
        DEBUG_PRINT("got MapRequest\n");
        map_request(ev);
        break;
      case DestroyNotify:
        DEBUG_PRINT("got DestroyNotify\n");
        /* fall through (handle the same as an Unmap) */
      case UnmapNotify:
        DEBUG_PRINT("got UnmapNotify\n");
        unmap_notify(ev);
        break;
      case Expose:
        expose(ev);
        break;
      case EnterNotify:
        DEBUG_PRINT("got EnterNotify\n");
        enter_notify(ev);
        break;
      case PropertyNotify:
        DEBUG_PRINT("got PropertyNotify\n");
        property_notify(ev);
        break;
      case ConfigureRequest:
        DEBUG_PRINT("got ConfigureRequest\n");
        configure_request(ev);
        break;
      default:
        break;
    }

    if (!XPending(disp)) {
      for (c = client_list_head; c; c = c->next) {
        redraw_client(c);
      }
    }
    XSync(disp, False);
  }

  return 0;
}
