<?php
	/**************************************************************************\
	* phpGroupWare - Shopping cart                                             *
	* http://www.phpgroupware.org                                              *
	* Written by Bettina Gille [ceb@phpgroupware.org]                          *
	* -----------------------------------------------                          *
	* This program is free software; you can redistribute it and/or modify it  *
	* under the terms of the GNU General Public License as published by the    *
	* Free Software Foundation; either version 2 of the License, or (at your   *
	* option) any later version.                                               *
	\**************************************************************************/
	/* $Id: view_product.php,v 1.3 2001/06/02 00:59:12 bettina Exp $ */

	if (! $Add)
	{
		$referer = $HTTP_REFERER;
	}

	if (!$con)
	{
		$phpgw_info['flags'] = array('noheader' => True,
									'nonavbar' => True);
		Header('Location: ' . $HTTP_REFERER);
		$phpgw->common->phpgw_exit();
	}

	$phpgw_info['flags']['currentapp'] = 'cart';
	include('../header.inc.php');

	$t = CreateObject('phpgwapi.Template',PHPGW_APP_TPL);
	$t->set_file(array('view' => 'view_product.tpl'));

	$hidden_vars = '<input type="hidden" name="sort" value="' . $sort . '">' . "\n"
				. '<input type="hidden" name="order" value="' . $order . '">' . "\n"
				. '<input type="hidden" name="query" value="' . $query . '">' . "\n"
				. '<input type="hidden" name="start" value="' . $start . '">' . "\n"
				. '<input type="hidden" name="filter" value="' . $filter . '">' . "\n"
				. '<input type="hidden" name="referer" value="' . $referer . '">' . "\n"
				. '<input type="hidden" name="con" value="' . $con . '">' . "\n";

	$c = CreateObject('phpgwapi.categories');

	$currency = $phpgw_info['user']['preferences']['common']['currency'];
	$t->set_var('hidden_vars',$hidden_vars);
	$t->set_var('lang_id',lang('Product ID'));
	$t->set_var('lang_short_name',lang('Short Name'));
	$t->set_var('lang_description',lang('Description'));
	$t->set_var('lang_category',lang('Category'));
	$t->set_var('lang_price',lang('Price'));
	$t->set_var('lang_piece',lang('Piece'));
	$t->set_var('lang_add',lang('Add to Shopping cart'));
	$t->set_var('currency',$currency);
	$t->set_var('image',PHPGW_IMAGES . '/logo.jpg');

	$phpgw->db->query("select * from phpgw_inv_products where con='$con'");
	$phpgw->db->next_record();

	$category = $phpgw->db->f('category');
	$t->set_var('cat_name',$c->return_name($category));
	$t->set_var('piece',$piece);

	$price = $phpgw->db->f('price');
	$t->set_var('id',$phpgw->db->f('id'));
	$t->set_var('name',$phpgw->strip_html($phpgw->db->f('name')));
	$t->set_var('descr',$phpgw->strip_html($phpgw->db->f('descr')));

	$taxpercent = select_tax($category);
	$retail = round($price*(1+$taxpercent),2);
	$t->set_var('retail',sprintf("%01.2f",$retail));

	$t->set_var('action_url',$phpgw->link('/cart/view_product.php'));
	$t->set_var('done_action',$referer);
	$t->set_var('lang_done',lang('Done'));
	$t->pparse('out','view');

	$phpgw->common->phpgw_footer();
?>
