/*
 * decl.h:  NULL kernel declarations
 *
 * (C) 1999 Ramon van Handel, the plex86 team
 *
 * HISTORY
 * Date      Author      Rev    Notes
 * 14/07/99  ramon       1.0    Adapted for plex86 NULL kernel
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __DECL_H
#define __DECL_H

#include <typewrappers.h>
#include "taskstate.h"
#include "gdt.h"

VOID setVector(VOID *handler, UBYTE interrupt, UWORD16 control_major);
VOID disableIRQ(UDATA irq);
VOID enableIRQ(UDATA irq);
VOID initIntr(VOID);
VOID initMem(VOID);

extern struct TSS tss[];
extern union DTEntry GDT[];

#endif
