/*
 *  Copyright (C) 1994-2000  Kevin P. Lawton
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include <stdio.h>
#include <stdlib.h>

#include <unistd.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>


#define BX_DBG_A20_REPORT(val)

#include "config.h"
#include "plex86.h"
#include "user.h"
#include "plugin.h"

#define uint8   Bit8u
#define uint16  Bit16u
#define uint32  Bit32u


enum PCS_OP { PCS_CLEAR, PCS_SET, PCS_TOGGLE };

#include "gui/gui.h"
extern bx_gui_c bx_gui;
//#include "iodev/iodev.h"

#define bx_ptr_t void *

extern plugin_t *bx_plugin;

#define BX_SET_ENABLE_A20(enabled) pluginSetA20E(enabled)
#define BX_GET_ENABLE_A20()        pluginGetA20E()

#define BX_SET_INTR(b) (plugin_set_intr(b))

#define BX_INSTR_INP(addr, io_len)
#define BX_INSTR_OUTP(addr, len)
#define BX_DBG_IO_REPORT(addr, size, op, val)
#define BX_TICK1()

#define GUI_WINDOW_TITLE "http://www.plex86.org"
#define BX_CPU_LEVEL 5

#define BX_EJECTED   10
#define BX_INSERTED  11
 
#define BX_RESET_SOFTWARE 10
#define BX_RESET_HARDWARE 11

#define BX_FLOPPY_NONE   10 // floppy not present
#define BX_FLOPPY_1_2    11 // 1.2M  5.25"
#define BX_FLOPPY_1_44   12 // 1.44M 3.5"
#define BX_FLOPPY_2_88   13 // 2.88M 3.5"
#define BX_FLOPPY_720K   14 // 720K  3.5"

extern "C" {
void plugin_fini(void);
int plugin_init(plugin_t *plugin, int argc, char *argv[]);
};
