/*-*-c++-*-
 * $Id: rpcs16.cc,v 1.7 2001/03/01 00:22:22 felfert Exp $
 *
 * This file is part of plptools.
 *
 *  Copyright (C) 1999 Matt J. Gumbley <matt@gumbley.demon.co.uk>
 *  Copyright (C) 1999-2001 Fritz Elfert <felfert@to.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stream.h>
#include <stdlib.h>
#include <fstream.h>
#include <iomanip.h>
#include <time.h>
#include <string.h>

#include "rpcs16.h"
#include "bufferstore.h"
#include "ppsocket.h"

rpcs16::rpcs16(ppsocket * _skt)
{
    skt = _skt;
    reset();
}

Enum<rfsv::errs> rpcs16::
queryDrive(char drive, bufferArray &ret)
{
    bufferStore a;
    a.addByte(drive);
    if (!sendCommand(rpcs::QUERY_DRIVE, a))
	return rfsv::E_PSI_FILE_DISC;
    Enum<rfsv::errs> res = getResponse(a, true);
    cout << dec << "qd: " << res << " " << a.getLen() << " a="<< a << endl;
    return res;
}

Enum<rfsv::errs> rpcs16::
getCmdLine(const char *process, bufferStore &ret)
{
    return rfsv::E_PSI_GEN_NONE;
}

/*
 * Local variables:
 * c-basic-offset: 4
 * End:
 */
