/*
 * $Id: controlform.c,v 1.19 2001/09/16 15:07:38 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "controlform.h"
#include "debug.h"
#include "prefsdata.h"
#include "resourceids.h"
#include "util.h"


/***********************************************************************
 *
 *      Internal Constants
 *
 ***********************************************************************/
#define MAX_CONTROL_LIST_LEN    14


/***********************************************************************
 *
 *      Private variables
 *
 ***********************************************************************/
static SelectType   defaultSelect[ NUM_OF_CONTROL_MODES ][ NUM_OF_CONTROL_LISTS ];
static ModeType     defaultMode;



/* Initialize pop-up control list */
static void UpdateControlList
    (
    Int16 num   /* list number ( starting from zero ) */
    )
{
    ListType*       list;
    ControlType*    ctl;
    UInt16          selection;

    ErrFatalDisplayIf( ( frmControlList2 != frmControlList1 + 1 ) && 
                       ( frmControlList3 != frmControlList1 + 2 ) &&
                       ( frmControlList4 != frmControlList1 + 3 ),
                       "UpdateControlList: for this function to work the resource IDs must be located together" );

    list        = (ListType*) GetObjectPtr( frmControlList1 + num );
    ctl         = (ControlType*) GetObjectPtr( frmControlPopup1 + num );
    selection   = Prefs()->select[ Prefs()->controlMode ][ num ];

    LstSetHeight( list, MAX_CONTROL_LIST_LEN );
    LstSetSelection( list, selection );
    CtlSetLabel( ctl, LstGetSelectionText( list, selection ) );
}



/* Initialize all pop-up control lists */
static void UpdateAllControlLists( void )
{
    Int16 i;

    for ( i = 0; i < NUM_OF_CONTROL_LISTS; i++ )
        UpdateControlList( i );
}



/* Show control objects for current mode */
static void ShowMode( void )
{
    FormType* controlForm;

    controlForm = FrmGetFormPtr( frmControl );
    if ( Prefs()->controlMode == MODE1 ) {
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, bmpMode2 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, bmpMode3 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, bmpMode1 ) );

        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlPopup1 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlPopup2 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlPopup3 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlPopup4 ) );

        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlMsg1 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlMsg2 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlMsg3 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlMsg4 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlLabel1 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlLabel2 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlLabel3 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlLabel4 ) );
    }
    else if ( Prefs()->controlMode == MODE2 ) {
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, bmpMode1 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, bmpMode3 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, bmpMode2 ) );

        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlPopup1 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlPopup2 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlPopup3 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlPopup4 ) );

        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlMsg1 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlMsg2 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlMsg3 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlMsg4 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlLabel1 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlLabel2 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlLabel3 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlLabel4 ) );
    }
    else {
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, bmpMode1 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, bmpMode2 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, bmpMode3 ) );

        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlPopup1 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlPopup2 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlPopup3 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlPopup4 ) );

        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlLabel1 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlLabel2 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlLabel3 ) );
        FrmHideObject( controlForm, FrmGetObjectIndex( controlForm, frmControlLabel4 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlMsg1 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlMsg2 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlMsg3 ) );
        FrmShowObject( controlForm, FrmGetObjectIndex( controlForm, frmControlMsg4 ) );
    }
}



/* Initialize the control options form */
static void ControlFormInit( void )
{
    FormType* controlForm;

    MemMove( defaultSelect, Prefs()->select, sizeof( defaultSelect ) );
    defaultMode = Prefs()->controlMode;

    controlForm = FrmGetFormPtr( frmControl );

    FrmDrawForm( controlForm );

    CtlSetValue( (ControlType*) GetObjectPtr( frmControlMode1 ), defaultMode == MODE1 );
    CtlSetValue( (ControlType*) GetObjectPtr( frmControlMode2 ), defaultMode == MODE2 );
    CtlSetValue( (ControlType*) GetObjectPtr( frmControlMode3 ), defaultMode == MODE3 );

    ShowMode();
    UpdateAllControlLists();
}



/* Event handler for the control options form */
Boolean ControlFormHandleEvent
    (
    const EventType* event  /* pointer to an EventType structure */
    )
{
    Boolean handled = false;

    SET_A4_FROM_A5 

    switch ( event->eType ) {
        case ctlSelectEvent:
            if ( event->data.ctlEnter.controlID == frmControlMode1 ) {
                Prefs()->controlMode = MODE1;

                ShowMode();
                UpdateAllControlLists();
                break;
            }
            else if ( event->data.ctlEnter.controlID == frmControlMode2 ) {
                Prefs()->controlMode = MODE2;

                ShowMode();
                UpdateAllControlLists();
                break;
            }
            else if ( event->data.ctlEnter.controlID == frmControlMode3 ) {
                Prefs()->controlMode = MODE3;

                ShowMode();
                UpdateAllControlLists();
                break;
            }
            else if ( event->data.ctlEnter.controlID == frmControlCancel ) {
                MemMove( Prefs()->select, defaultSelect, sizeof( Prefs()->select ) );
                Prefs()->controlMode = defaultMode;
            }
            else if ( event->data.ctlEnter.controlID != frmControlOK )
                break;

            FrmReturnToForm( Prefs()->lastForm );
            handled = true;
            break;

        case popSelectEvent:
        {
            Int16 selection;

            selection = event->data.popSelect.selection;
            if ( selection != noListSelection ) {
                ListType*       list;
                ControlType*    ctl;
                Char*           label;

                list    = event->data.popSelect.listP;
                ctl     = (ControlType*) GetObjectPtr( event->data.popSelect.controlID );
                label   = LstGetSelectionText( list, selection );

                CtlSetLabel( ctl, label );
                LstSetSelection( list, selection );

                Prefs()->select[ Prefs()->controlMode ][ event->data.popSelect.listID - frmControlList1 ] = (SelectType) LstGetSelection( list );
            }
            handled = true;
            break;
        }

        case frmOpenEvent:
            ControlFormInit();
            handled = true;
            break;

        default:
            handled = false;
    }

    RESTORE_A4 

    return handled;
}
