#! /usr/bin/perl
#   flat2pot.pl: transform intemediate representation into POT file
#   This script is part of po-debiandoc

use strict;
use Getopt::Long;

use vars(qw($opt_v));

my ($name, $line, $file, $start, $end);
my ($cnt, @entry, @list, %index, $text);

my $date = `date +'%Y-%m-%d %k:%M%z'`;
chomp $date;
print <<"EOT";
msgid ""
msgstr ""
"Project-Id-Version: PACKAGE VERSION\\n"
"POT-Revision-Date: $date\\n"
"PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\\n"
"Last-Translator: FULL NAME <EMAIL\@ADDRESS>\\n"
"Language-Team: LANGUAGE <LL\@li.org>\\n"
"MIME-Version: 1.0\\n"
"Content-Type: text/plain; charset=CHARSET\\n"
"Content-Transfer-Encoding: ENCODING\\n"

EOT

$Getopt::Long::bundling = 1;
$Getopt::Long::getopt_compat = 0;
if (not Getopt::Long::GetOptions(qw(
                        v|verbose
                ))) {
        warn "Try `$0 --help' for more information.\n";
        exit(1);
}

$file = <>;
chomp $file;

$cnt = 0;
while (<>) {
        next unless (m/START (\S+)/);
        $name = $1;
        $_ = <> or die "Unknown format";
        chomp;
        die "Unknown format" if !m/^LINES (\d+) (\d+)/;
        $start = $1;
        $end = $2;
        $_ = <> or die "Unknown format";
        chomp;
        s/^\s+//s;
        s/\s+$//s;
        s/"/\\"/g;
        next unless length($_);
        next if m/\[po-debiandoc-dummy\]/;
        if (!defined($index{$_})) {
                $index{$_} = $cnt;
                $list[$cnt] = [];
                $cnt++;
        }
        push (@{$list[$index{$_}]}, $start, $end, $name, $file, $_);
}

foreach (@list) {
        my $pos = '';
        while (@entry = splice (@$_, 0, 5)) {
                print "#. <".$entry[2]."> ".$entry[0]."--".$entry[1]."\n";
                $pos .= "#: ".$entry[3].":".$entry[0]."\n";
                $text = $entry[4];
        }
        print $pos;
        print "msgid \"".$text."\"\n";
        print "msgstr \"\"\n\n";
}
1;
