// ------------------------------------------------------------------------- //
// $Id: ftdraw.h,v 1.20 2003/01/01 15:05:25 pandr Exp $
// ------------------------------------------------------------------------- //

/*
 * Copyright (c) 2002 
 *				see AUTHORS list
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// Tool for rendering strings

#ifndef _FTDRAW_H_
#define _FTDRAW_H_

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include <ft2build.h>
#include FT_FREETYPE_H

#if HAVE_VECTOR
# include <vector>
#endif

#if HAVE_MAP
# include <map>
#endif

#include "primitive.h"
#include "refcount.h"

class Image;
class FreeTypeFont;

// ------------------------------------------------------------------------- //

//! Contains info about where on a texture the glyph's bitmap is found

class Glyph
{
public:
	Glyph(FT_UInt glyph_index) : _tile(0), _index(glyph_index)  { };
	~Glyph() {};
	Tile::handle _tile;
	FT_UInt      _index;
	v2           _size;
	v2           _advance;
	v2           _offset;
};

class FontId
{
public:
	FontId(std::string n, uint s) : fontname(n), size(s) {};

	std::string fontname;
	uint        size;

	static bool less (const FontId& id_1, const FontId& id_2)
	{
		if (id_1.fontname < id_2.fontname)
			return true;
		if (id_1.fontname == id_1.fontname && id_1.size < id_2.size)
			return true;
		return false;
	}
};

//! A Face object holds the texture info for a particular font + size

class FreeTypeFont : public Refcount
{
public:
	typedef Ref<FreeTypeFont> handle;

	static handle get_font(const char* fontname, uint size);

	int    render(const char *string, Image *image, int x, int y);
	const Glyph* get_tex_glyph(FT_ULong unicode);
	Glyph* make_tex_glyph(FT_UInt glyph_index);
	Glyph* get_poly_glyph(unsigned char c);
	float     get_kerning(FT_UInt left, FT_UInt right);
	float     get_baselineskip() const;
	float     get_underline_position() const;
	float     get_underline_thickness() const;
	float     get_vert_advance();
	bool      font_ok() const { return _ok; }

private:
	FreeTypeFont(const char *fontname, uint size);
	~FreeTypeFont();
	void       copy_bitmap(Tile::handle, FT_GlyphSlot glyph);
    uint       get_char_index(unsigned char c);
	void       make_tex_glyphs();
	void       make_poly_glyphs();

	// Data for the texturized glyphs
	std::vector<Glyph*> _tex_glyphs;   ///< info about each tex-glyph
	Texture*       _texture;      ///< master texture with all glyphs

	// Data for the polygonized glyphs
	std::vector<Primitive*> _poly_glyphs;

	// Common data
	FT_Face        _ft_face;      ///< the freetype2 handle to the face

	// All FreeTypeFont's shares the same FreeType lib
	static void load_freetype_lib();
	static FT_Library _ft_lib;

	typedef std::map<FT_ULong, Glyph*> _glyphs_;
	_glyphs_ _glyphs;

	bool _ok;                    ///< Indicates if constructor succeeded
};

#endif /* _FTDRAW_H_ */

// ------------------------------------------------------------------------- //
