#!/usr/bin/env python

from optparse import OptionParser

DEFAULT_FILE="./typegen.conf"

EXEC = "exec"
DIR = "dir"
FILE = "file"
NAME = "name"
TEDIR = "tedir"
FCDIR = "fcdir"
ROLE = "role"
TYPES = "types"
CLASSES = [EXEC, DIR, FILE]
SCALARS = [NAME, TEDIR, FCDIR]
ROLE_LIKE = [ROLE]

def get_options():
    parser = OptionParser(version="%prog 1.0")
    parser.add_option("-i", "--input", dest="filename",
                      help="input configuration file",
                      default=DEFAULT_FILE, metavar=FILE)
    (options, args) = parser.parse_args()
    return options.filename

class Typegen:
    def __init__(self,conf_file_name):
        self.data = {}
        for key in CLASSES:
            self.data[key] = {}
        for key in SCALARS:
            self.data[key] = {}
        for key in ROLE_LIKE:
            self.data[key] = {}
        conf_file = file(conf_file_name,'r')
        for line in conf_file:
            items = line.split()
            if 1 > len(items):
                continue # blank line
            if items[0][0] == "#":
                continue # comment
            label = items[0]
            items = items[1:]
            if label in SCALARS:
                val = items[0]
                assert val != ""
                self.data[label] = val
            elif label in CLASSES:
                key = items[0]
                val = items[1]
                assert val != ""
                self.data[label][key]=val
            elif label in ROLE_LIKE:
                key = items[0]
                x = items[1]
                vals = items[2:]
                assert x == TYPES
                self.data[label][key] = vals
            else:
                raise StandardError, "bad keyword: %s" % (label)
        conf_file.close()
        for key in SCALARS:
            assert 0 < len(self.data[key])
        for key in ROLE_LIKE:
            assert 0 < len(self.data[key])
    def type(self,classname, resource):
        combo = ''.join(["polgen_temp_",resource,"_",classname,"_t"])
        if classname == EXEC and resource == self.data[NAME]:
            return combo
        else:
            return ''.join([self.data[NAME],"_",combo])
    def progtype(self,resource):
        combo = "polgen_temp_" + resource + "_t"
        if resource == self.data[NAME]:
            return combo
        else:
            return ''.join([self.data[NAME],"_",combo])
    def attributes(self,classname):
        if classname in [DIR, FILE]:
            return "file_type"
        elif classname in [EXEC]:
            return "file_type, exec_type"
        else:
            return ""
    def format_fc_line(self,path,classname,resource):
        return ("%s system_u:object_r:%s\n" \
                % (path, self.type(classname,resource)))
    def format_fc_class(self,classname):
        return [self.format_fc_line(self.data[classname][resource], classname, resource) for resource in self.data[classname]]
    def format_fc_file(self,classes=CLASSES):
        output = []
        for chunk in [self.format_fc_class(classname) \
                      for classname in classes]:
            output.extend(chunk)
        return output
    def write_fc(self):
        filename = "polgen_temp.fc" #self.data[FCDIR] + ".fc"
        fc_file = file(filename, "w")
        output = ''.join(self.format_fc_file())
        fc_file.write(output)
        fc_file.close()
    def format_te_line(self,type,attr):
        return "type %s, %s;\n" % (type, attr)
    def format_list(self,types):
        return ('{ ' + (' '.join(types)) + ' }')
    def format_resource_line(self,role,types,progtype,progexectype):
        output = ["type_transition %s " % self.format_list(types),
                  "%s:process %s;\n" % (progexectype, progtype),
                  "allow %s " % self.format_list(types),
                  "%s:process transition;\n" % progtype,
                  "role %s types %s;\n\n" % (role, progtype)]
        return ''.join(output) 
    def format_te_class(self,classname):
        types = [self.type(classname,resource) \
                 for resource in self.data[classname]]
        attr = self.attributes(classname)
        return [self.format_te_line(type,attr) for type in types]
    def format_domain_line(self,resource):
        return "type %s, domain;\n" % self.progtype(resource)
    def format_resource(self,resource):
        progtype=self.progtype(resource)
        progexectype=self.type(EXEC,resource)
        output = ([self.format_resource_line(role,self.data["role"][role],progtype,progexectype) for role in self.data["role"]])
        return [self.format_domain_line(resource)] + output
    def format_te_file(self):
        output = []
        for chunk in [self.format_te_class(classname) \
                      for classname in CLASSES]:
            output.extend(chunk)
        output.extend("\n")
        for chunk in [self.format_resource(resource) \
                      for resource in self.data[EXEC]]:
            output.extend(chunk)
        return output
    def write_te(self):
        filename = "polgen_temp.te" #self.data[TEDIR] + ".te"
        te_file = file(filename, "w")
        output = ''.join(self.format_te_file())
        te_file.write(output)
        te_file.close()

if __name__=='__main__':
    filename = get_options()
    conf = Typegen(filename)
    conf.write_te()
    conf.write_fc()
