#!/bin/sh


declare -i result

if [ "$#" != "1" ]
    then
    echo "One parameter is needed : a glade file or \"all\""
    exit 1
fi

if [ "$1" == "all" ]
    then
    # Will extract all translatable strings from *.glade files in
    # the tmp directory.
    
    # Once this operation is performed, it is necessary to run the 
    # intltool-update --pot and 
    # intltool-update fr
    # scripts, both from the topsrcdir/po directory.


    for gladefile in *.glade
      do intltool-extract --type="gettext/glade" --local $gladefile
      result=$result+$?
    done
    
    if [ "$result" != "0" ]
	then
	echo "Failed to extract at least one file."
    fi
    
    exit $result
fi

file="$1"

if [ -f "$file" ]
    then
    grep 'DOCTYPE glade\-interface' $file > /dev/null

    if [ "$?" != "0" ]
	then
	echo "File $1 does not seem to be a glade file"
	exit 1
    fi
    

    intltool-extract --type="gettext/glade" --local $file

    result=$?

    if [ "$result" != "0" ]
	then
	echo "Failed to extract the file."
    fi
    
    exit $result
fi

