/*                                                     
ClientTIMSIEVED.cc

# grep -i sieve /etc/services
sieve 2000/tcp

Para prucor2
authenticate "plain" "AHBydWNvcjIAa29raWxvMw=="

AUTHENTICATE
LOGOUT      
GETSCRIPT   
PUTSCRIPT   
SETACTIVE   
LISTSCRIPTS 
DELETESCRIPT
CAPABILITY  
HAVESPACE   
*/

#include "ClientTIMSIEVED.h"
extern Language *L;

extern FilterList FLAllFilters;      
extern XVacation vacation;

ClientTIMSIEVED::ClientTIMSIEVED (const char *aserver, int aport, const char *auser, const char *apw, const char *asievefile)
  {
  TBuffer abuf;
  char *pc;
  int totsz, base64len;

  initStr (ErrorMsg);
  FLAllFilters.Clear();
    
  xstrncpy (server, CMAXIPNAME, aserver);
  xstrncpy (user, CMAXBUFFER, auser);
  xstrncpy (pw, CMAXBUFFER, apw);
  timsievedport = aport;

  xstrncpy (sievefile, CMAXIPNAME, asievefile);
  ConfSieve = new Configuration (sievefile, false);
  ConfSieve->ConfRead ();

  loadFiltersFromFile ();
  getVacationFromFile ();

  /*\000username\000password*/
  memset (abuf, 0, CMAXBUFFER);
  pc = abuf + 1;
  memcpy (pc, user, strlen(user));
  pc = abuf + strlen(user) + 2;
  memcpy (pc, pw, strlen(pw));
  totsz = strlen(user) + strlen(pw) + 2;
  EncodeBase64Buffer (abuf, totsz, base64, &base64len);
  }  

ClientTIMSIEVED::~ClientTIMSIEVED ()
  {
  delete ConfSieve;
  }

void ClientTIMSIEVED::initFilter (XFilter *filter)
  {
  initStr(filter->sectionname);
  initStr(filter->name); 
  initStr(filter->from); 
  initStr(filter->to); 
  initStr(filter->subject); 
  initStr(filter->size); 
  initStr(filter->header_name); 
  initStr(filter->header_value); 
  initStr(filter->folder); 
  initStr(filter->action); 
  initStr(filter->rejecttext);  
  }
  
void ClientTIMSIEVED::initVacation (XVacation *vacation)
  {
  initStr(vacation->vacations_active);
  initStr(vacation->vacations_msgtext); 
  initStr(vacation->vacations_msgsubject);   
  initStr(vacation->vacations_days2repeat); 
  initStr(vacation->vacations_ausenstaddresses); 
  }  
  
const char *ClientTIMSIEVED::getErrorMsg (void)
  {
  return ErrorMsg;           
  }  

void ClientTIMSIEVED::loadFiltersFromFile (void)
  {
  XString XS;
  TBuffer sectname, label;
  XFilter filter;
  int i = 1;
  
  FLAllFilters.Clear();  
  xsnprintf (sectname, CMAXBUFFER, "filter_%d", i);
  xsnprintf (label, CMAXBUFFER, ConfSieve->getString (sectname, "name", "", CMAXBUFFER));
  while (i <= CMAXFILTERS)
    {
    if (ConfSieve->IsThereSection(sectname))
      {
      xstrncpy (filter.sectionname, CMAXBUFFER, sectname);
      xstrncpy (filter.name, CMAXBUFFER, label);                                                         
      xstrncpy (filter.from, CMAXBUFFER, ConfSieve->getString (sectname, "from", "", CMAXBUFFER));
      xstrncpy (filter.to, CMAXBUFFER, ConfSieve->getString (sectname, "to", "", CMAXBUFFER));      
      xstrncpy (filter.subject, CMAXBUFFER, ConfSieve->getString (sectname, "subject", "", CMAXBUFFER));
      xstrncpy (filter.size, CMAXBUFFER, ConfSieve->getString (sectname, "size", "", CMAXBUFFER));
      xstrncpy (filter.header_name, CMAXBUFFER, ConfSieve->getString (sectname, "header_name", "", CMAXBUFFER));
      xstrncpy (filter.header_value, CMAXBUFFER, ConfSieve->getString (sectname, "header_value", "", CMAXBUFFER));
      xstrncpy (filter.folder, CMAXBUFFER, ConfSieve->getString (sectname, "folder", "", CMAXBUFFER));
      xstrncpy (filter.action, CMAXBUFFER, ConfSieve->getString (sectname, "action", "", CMAXBUFFER));
      xstrncpy (filter.rejecttext, CMAXBUFFER,  ConfSieve->getString (sectname, "rejecttext", "", CMAXBUFFER));
      XS = filter.rejecttext;
      XS.replace (SEPCR, "\n");  
      xstrncpy (filter.rejecttext, CMAXBUFFER, XS.cstr());
      FLAllFilters.Add (filter);  
      }
    ++i;
    xsnprintf (sectname, CMAXBUFFER, "filter_%d", i);
    xsnprintf (label, CMAXBUFFER, ConfSieve->getString (sectname, "name", "", CMAXBUFFER));
    }  
  }

bool ClientTIMSIEVED::saveFiltersToFile (const char *fncgi, const char *sectionname)      
  {
  XString XS;
  bool b;
  XFilter afilter;
  int size;
  
  initStr (ErrorMsg);

  if (IsEmpty (sectionname))
    {
    xsnprintf (afilter.sectionname, CMAXBUFFER, "filter_%d", ConfSieve->getFreeSlot("filter_%d", CMAXFILTERS));
    }
  else
    {
    xstrncpy (afilter.sectionname, CMAXBUFFER, sectionname);
    }

  cgienv_GetSimpleVarDef (fncgi, "filter_name", afilter.name, "");  
  if (IsEmpty(afilter.name)) {xstrncpy (ErrorMsg, CMAXBUFFER, "The field \"filter_name\" is empty."); return false;}   
  b = ConfSieve->setString (afilter.sectionname, "name", afilter.name, 500);

  cgienv_GetSimpleVarDef (fncgi, "filter_from", afilter.from, "");    
  b = ConfSieve->setString (afilter.sectionname, "from", afilter.from, 500);

  cgienv_GetSimpleVarDef (fncgi, "filter_to", afilter.to, "");      
  b = ConfSieve->setString (afilter.sectionname, "to", afilter.to, 500);

  cgienv_GetSimpleVarDef (fncgi, "filter_subject", afilter.subject, "");    
  b = ConfSieve->setString (afilter.sectionname, "subject", afilter.subject, 500);

  cgienv_GetSimpleVarDef (fncgi, "filter_size", afilter.size, "");   
  size = xatoidef (afilter.size, -1); 
  if ((size <= 0) && (!IsEmpty(afilter.size))) {xstrncpy(ErrorMsg, CMAXBUFFER, "Field Size must be numeric and greater than 0"); return false;}
  b = ConfSieve->setString (afilter.sectionname, "size", afilter.size, 50);

  cgienv_GetSimpleVarDef (fncgi, "filter_header_name", afilter.header_name, "");    
  b = ConfSieve->setString (afilter.sectionname, "header_name", afilter.header_name, 500);

  cgienv_GetSimpleVarDef (fncgi, "filter_header_value", afilter.header_value, "");    
  b = ConfSieve->setString (afilter.sectionname, "header_value", afilter.header_value, 500);

  cgienv_GetSimpleVarDef (fncgi, "filter_folder", afilter.folder, "");    
  b = ConfSieve->setString (afilter.sectionname, "folder", afilter.folder, 500);

  cgienv_GetSimpleVarDef (fncgi, "filter_action", afilter.action, "");        
  b = ConfSieve->setString (afilter.sectionname, "action", afilter.action, 500);

  xstrncpy (afilter.rejecttext, CMAXBUFFER,  cgienv_GetComplexVar (fncgi, "filter_rejecttext"));  
  XS = afilter.rejecttext;
  XS.replace ("\r\n", "\n");    
  XS.replace ("\n", SEPCR);  
  xstrncpy (afilter.rejecttext, CMAXBUFFER, XS.cstr());
  b = ConfSieve->setString (afilter.sectionname, "rejecttext", afilter.rejecttext, 500);

  b = ConfSieve->Sync ();
  
  loadFiltersFromFile();

  return true;
  }  

/*
   require ["fileinto"];
   
   if allof (header :contains  "X-Spam-Level" "xxxxx") {
        fileinto "INBOX.SPAM";
   }
   
   else {
        keep;
   }
*/  
bool ClientTIMSIEVED::saveAntiSpamFilterToFile (const char *fncgi, const char *spammailbox)
  {
  XString XS;
  bool b;
  XFilter afilter;
  
  initStr (ErrorMsg);

  xsnprintf (afilter.sectionname, CMAXBUFFER, "filter_%d", ConfSieve->getFreeSlot("filter_%d", CMAXFILTERS));

  xstrncpy (afilter.name, CMAXBUFFER, PREDEF_ANTISPAMFILTERNAME);
  b = ConfSieve->setString (afilter.sectionname, "name", afilter.name, 500);

  xstrncpy (afilter.header_name, CMAXBUFFER, "X-Spam-Level");    
  b = ConfSieve->setString (afilter.sectionname, "header_name", afilter.header_name, 500);

  xstrncpy (afilter.header_value, CMAXBUFFER, "xxxx");    
  b = ConfSieve->setString (afilter.sectionname, "header_value", afilter.header_value, 500);

  xstrncpy (afilter.folder, CMAXBUFFER, spammailbox);    
  b = ConfSieve->setString (afilter.sectionname, "folder", afilter.folder, 500);

  xstrncpy (afilter.action, CMAXBUFFER, "move");        
  b = ConfSieve->setString (afilter.sectionname, "action", afilter.action, 500);

  b = ConfSieve->Sync ();
  
  loadFiltersFromFile();

  return true;
  }  

bool ClientTIMSIEVED::upSection (const char *secname)
  {
  TBuffer abuf;
  int possection = -1;
  XFilter afilter1, afilter2;
  
  for (int i = 0; i < FLAllFilters.Count(); ++i)
    {
    afilter1 = FLAllFilters.elementAt(i);
    if (strcmp (afilter1.sectionname, secname) == 0) {possection = i; break;}
    }
  if (possection < 0) {xstrncpy(ErrorMsg, CMAXBUFFER, "Section not found!"); return false;}
  if (possection == 0) {return true;}

  afilter1 = FLAllFilters.elementAt(possection);
  afilter2 = FLAllFilters.elementAt(possection - 1);
 
  xstrncpy (abuf, CMAXBUFFER, FLAllFilters[possection - 1].sectionname);
  xstrncpy (FLAllFilters[possection - 1].sectionname, CMAXBUFFER, FLAllFilters[possection].sectionname);
  xstrncpy (FLAllFilters[possection].sectionname, CMAXBUFFER, abuf);
 
  FLAllFilters[possection]     = afilter2;
  FLAllFilters[possection - 1] = afilter1;
 
  return true;
  }
  
bool ClientTIMSIEVED::downSection (const char *secname)
  {
  TBuffer abuf;
  int possection = -1;
  XFilter afilter1, afilter2;
  
  for (int i = 0; i < FLAllFilters.Count(); ++i)
    {
    afilter1 = FLAllFilters.elementAt(i);
    if (strcmp (afilter1.sectionname, secname) == 0) {possection = i; break;}
    }
  if (possection < 0) {xstrncpy(ErrorMsg, CMAXBUFFER, "Section not found!"); return false;}
  if (possection == FLAllFilters.Count() - 1) {return true;}

  afilter1 = FLAllFilters.elementAt(possection);
  afilter2 = FLAllFilters.elementAt(possection + 1);
 
  xstrncpy (abuf, CMAXBUFFER, FLAllFilters[possection + 1].sectionname);
  xstrncpy (FLAllFilters[possection + 1].sectionname, CMAXBUFFER, FLAllFilters[possection].sectionname);
  xstrncpy (FLAllFilters[possection].sectionname, CMAXBUFFER, abuf);
 
  FLAllFilters[possection]     = afilter2;
  FLAllFilters[possection + 1] = afilter1;
 
  return true;
  }        
  
bool ClientTIMSIEVED::delFilters (StringList *SLFilters_section, int *contdel)
  {
  bool b;
  
  *contdel = 0;
  for (int i = 0; i < SLFilters_section->Count (); ++i)
    {
    b = ConfSieve->deleteSection (SLFilters_section->getString(i).cstr());
    if (b == true)
      {
      ++(*contdel);
      }
    }                

  b = ConfSieve->Sync ();
  
  loadFiltersFromFile();

  return true;
  }

bool ClientTIMSIEVED::getFilter (const char *secname, XFilter *filter)
  {
  XString XS;

  initFilter (filter);  
  if (!ConfSieve->IsThereSection(secname)) {return false;}

  xstrncpy (filter->sectionname, CMAXBUFFER, secname);
  xstrncpy (filter->name, CMAXBUFFER, ConfSieve->getString(secname, "name", "", CMAXBUFFER));
  xstrncpy (filter->from, CMAXBUFFER, ConfSieve->getString(secname, "from", "", CMAXBUFFER)); 
  xstrncpy (filter->to, CMAXBUFFER, ConfSieve->getString(secname, "to", "", CMAXBUFFER)); 
  xstrncpy (filter->subject, CMAXBUFFER, ConfSieve->getString(secname, "subject", "", CMAXBUFFER)); 
  xstrncpy (filter->size, CMAXBUFFER, ConfSieve->getString(secname, "size", "", CMAXBUFFER)); 
  xstrncpy (filter->header_name, CMAXBUFFER, ConfSieve->getString(secname, "header_name", "", CMAXBUFFER)); 
  xstrncpy (filter->header_value, CMAXBUFFER, ConfSieve->getString(secname, "header_value", "", CMAXBUFFER)); 
  xstrncpy (filter->folder, CMAXBUFFER, ConfSieve->getString(secname, "folder", "", CMAXBUFFER)); 
  xstrncpy (filter->action, CMAXBUFFER, ConfSieve->getString(secname, "action", "", CMAXBUFFER)); 
  XS = ConfSieve->getString(secname, "rejecttext", "", CMAXBUFFER);
  XS.replace (SEPCR, "\n");  
  xstrncpy (filter->rejecttext, CMAXBUFFER, XS.cstr()); 

  return true;
  }        
  
bool ClientTIMSIEVED::isValidSection (const char *secname)
  {
  initStr (ErrorMsg);
  if (IsEmpty (secname)) {xstrncpy (ErrorMsg, CMAXBUFFER, "No hay entradas seleccionadas"); return false;}
  if (!ConfSieve->IsThereSection(secname)) {xstrncpy (ErrorMsg, CMAXBUFFER, "Seccion no valida"); return false;}
  return true;  
  }

bool ClientTIMSIEVED::saveVacationToFile (const char *fncgi, PXVacation avacation)
  {  
  bool b;
  int num;
  XString XS;
  
  cgienv_GetSimpleVarDef (fncgi, "vacations_active", avacation->vacations_active, "false");        
  b = ConfSieve->setString (VACATIONSECTIONNAME, "vacations_active", avacation->vacations_active, 10);

  xstrncpy (avacation->vacations_msgtext, CMAXBUFFER,  cgienv_GetComplexVar (fncgi, "vacations_msgtext"));  
  XS = avacation->vacations_msgtext;
  XS.replace ("\r\n", "\n");    
  XS.replace ("\n", SEPCR);  
  b = ConfSieve->setString (VACATIONSECTIONNAME, "vacations_msgtext", XS.cstr(), 500);

  cgienv_GetSimpleVarDef (fncgi, "vacations_msgsubject", avacation->vacations_msgsubject, "");        
  b = ConfSieve->setString (VACATIONSECTIONNAME, "vacations_msgsubject", avacation->vacations_msgsubject, 100);

  cgienv_GetSimpleVarDef (fncgi, "vacations_days2repeat", avacation->vacations_days2repeat, "7");        
  num = xatoidef (avacation->vacations_days2repeat, -1); 
  if (num <= 0) {xstrncpy(ErrorMsg, CMAXBUFFER, "Field Days must be numeric and greater than 0"); return false;}
  b = ConfSieve->setString (VACATIONSECTIONNAME, "vacations_days2repeat", avacation->vacations_days2repeat, 3);

  xstrncpy (avacation->vacations_ausenstaddresses, CMAXBUFFER,  cgienv_GetComplexVar (fncgi, "vacations_ausenstaddresses"));  
  XS = avacation->vacations_ausenstaddresses;
  XS.replace ("\r\n", "\n");    
  XS.replace ("\n", SEPCR);  
  b = ConfSieve->setString (VACATIONSECTIONNAME, "vacations_ausenstaddresses", XS.cstr(), 500);

  b = ConfSieve->Sync ();

  return true;
  }
  
bool ClientTIMSIEVED::getVacationFromFile (void)
  {
  XString XS;
  initVacation (&vacation);
  xstrncpy ((&vacation)->vacations_active, CMAXBUFFER, ConfSieve->getString(VACATIONSECTIONNAME, "vacations_active", "false", CMAXBUFFER));
  XS = ConfSieve->getString(VACATIONSECTIONNAME, "vacations_msgtext", "", CMAXBUFFER);
  XS.replace (SEPCR, "\n");
  xstrncpy ((&vacation)->vacations_msgtext, CMAXBUFFER, XS.cstr());
  xstrncpy ((&vacation)->vacations_msgsubject, CMAXBUFFER, ConfSieve->getString(VACATIONSECTIONNAME, "vacations_msgsubject", CAUTOMATICRESPONSE, CMAXBUFFER));    
  xstrncpy ((&vacation)->vacations_days2repeat, CMAXBUFFER, ConfSieve->getString(VACATIONSECTIONNAME, "vacations_days2repeat", "7", CMAXBUFFER));
  XS = ConfSieve->getString(VACATIONSECTIONNAME, "vacations_ausenstaddresses", "", CMAXBUFFER);
  XS.replace (SEPCR, "\n");
  xstrncpy ((&vacation)->vacations_ausenstaddresses, CMAXBUFFER, XS.cstr());
  return true;
  }    

bool ClientTIMSIEVED::doSession (int sieve_cmd, TBuffer scriptname, StringList *SLRes, const char *data2put, TBuffer ErrorString)
  {  
  TBuffer buffer;
  int sock;
  XSocket *socket;
  bool b;

  SLRes->Clear();
  initStr (ErrorString);
  socket = new XSocket ();
  socket->ignore_pipe();
  sock = socket->do_client_inet (server, NULL, timsievedport, 240);
  if (sock == -1) {xstrncpy (ErrorString, CMAXBUFFER, L->get (ERR_SERVERISDOWN)); return false;}
  socket->SetSock (sock);
  
  /*LEO LAS LINEAS INICIALES*/
  /*    -1 by the possible buffer overflow resulting from the linefeed added below. */
  while ((b = socket->Gets (buffer, sizeof(buffer)-1)) == true)
    {
    if (b == false) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
    if (strcmp (buffer, "OK") == 0) break;
    else if (NCstrstr(buffer, "NO ") == 1) break;
    }
  if (NCstrstr(buffer, "NO ") == 1) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}

  /*ENVIO AUTH PLAIN*/
  snprintf (buffer, CMAXBUFFER, "AUTHENTICATE \"plain\" \"%s\"\n", base64);
  if (socket->Puts (buffer) == -1) {return false;}
  /*LEO LO RECIBIDO*/
  while ((b = socket->Gets (buffer, sizeof(buffer)-1)) == true)
    {
    if (b == false) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
    if (strcmp (buffer, "OK") == 0) break;
    else if (NCstrstr(buffer, "NO ") == 1) break;
    }
  if (NCstrstr(buffer, "NO ") == 1) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}
  
  switch (sieve_cmd)
    {
    case SIEVE_CMD_LISTSCRIPTS:
      {
      xstrncpy (buffer, CMAXBUFFER, "LISTSCRIPTS\n");
      if (socket->Puts (buffer) == -1) {return false;}
      //LEO LO RECIBIDO
      while ((b = socket->Gets (buffer, sizeof(buffer)-1)) == true)
        {
        if (b == false) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
        if (strcmp (buffer, "OK") == 0) break;
        else if (NCstrstr(buffer, "NO ") == 1) break;
        else SLRes->Add (buffer);
        }
      if (NCstrstr(buffer, "NO ") == 1) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}
      break;
      }
    case SIEVE_CMD_GETSCRIPT:
      {
      xsnprintf (buffer, CMAXBUFFER, "GETSCRIPT \"%s\"\n", scriptname);
      if (socket->Puts (buffer) == -1) {return false;}
      //LEO LO RECIBIDO
      while ((b = socket->Gets (buffer, sizeof(buffer)-1)) == true)
        {
        if (b == false) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
        if (strcmp (buffer, "OK") == 0) break;
        else if (NCstrstr(buffer, "NO ") == 1) break;
        else SLRes->Add (buffer);
        }
      if (NCstrstr(buffer, "NO ") == 1) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}
      break;
      }
    case SIEVE_CMD_DELETESCRIPT:
      {
      xsnprintf (buffer, CMAXBUFFER, "DELETESCRIPT \"%s\"\n", scriptname);
      if (socket->Puts (buffer) == -1) {return false;}
      //LEO LO RECIBIDO
      while ((b = socket->Gets (buffer, sizeof(buffer)-1)) == true)
        {
        if (b == false) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
        if (strcmp (buffer, "OK") == 0) break;
        else if (NCstrstr(buffer, "NO ") == 1) break;
        else SLRes->Add (buffer);
        }
      if (NCstrstr(buffer, "NO ") == 1) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}
      break;                           
      }                                      
    case SIEVE_CMD_SETACTIVE:
      {
      xsnprintf (buffer, CMAXBUFFER, "SETACTIVE \"%s\"\n", scriptname);
      if (socket->Puts (buffer) == -1) {return false;}
      //LEO LO RECIBIDO
      while ((b = socket->Gets (buffer, sizeof(buffer)-1)) == true)
        {
        if (b == false) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
        if (strcmp (buffer, "OK") == 0) break;
        else if (NCstrstr(buffer, "NO ") == 1) break;
        else SLRes->Add (buffer);
        }
      if (NCstrstr(buffer, "NO ") == 1) {xstrncpy (ErrorString, CMAXBUFFER, buffer); return false;}
      break;                           
      }  
    case SIEVE_CMD_PUTSCRIPT:    
      {
      xsnprintf (buffer, CMAXBUFFER, "PUTSCRIPT \"%s\" {%d+}\r\n", scriptname, strlen(data2put));
      if (socket->Puts (buffer) == -1) {return false;}
      
      xsnprintf (buffer, CMAXBUFFER, "%s\r\n", data2put);
      if (socket->Puts (buffer) == -1) {return false;}
      
      //LEO LO RECIBIDO
      while ((b = socket->Gets (buffer, sizeof(buffer)-1)) == true)
        {
        if (b == false) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
        if (strcmp (buffer, "OK") == 0) break;
        else if (NCstrstr(buffer, "NO ") == 1) 
          {
          if (strstr("{", buffer) != NULL) 
            {
            //READ THE SECOND ERROR LINE
            socket->Gets (buffer, sizeof(buffer)-1);
            xstrncpy (ErrorString, CMAXBUFFER, buffer); 
            return false;
            }
          break;
          }
        else SLRes->Add (buffer);
        }
      break;
      }    
    }  
  
  //ENVIO LOGOUT
  xstrncpy (buffer, CMAXBUFFER, "LOGOUT\n");
  if (socket->Puts (buffer) == -1) {/*NOTHING*/}
  //LEO LO RECIBIDO
  while ((b = socket->Gets (buffer, sizeof(buffer)-1)) == true)
    {
    if (b == false) {xstrncpy (ErrorString, CMAXBUFFER, "Socket error"); return false;}
    if (strcmp (buffer, "OK") == 0) break;
    else if (NCstrstr(buffer, "NO ") == 1) break;
    }
    
  delete socket;
    
  return true;
  }

void ClientTIMSIEVED::makeSieveScript (char *sieveprogram, int MAXLENGTH)
  {
  XString XS;
  StringList SL;
  int numfilter, totfilters;
  TBuffer tmp;
  XFilter filter;

  xstrncpy (sieveprogram, MAXLENGTH, "#CREATED BY POSTMAN 2.0\n");
  xstrncat (sieveprogram, MAXLENGTH, "require [\"fileinto\",\"reject\",\"vacation\",\"notify\",\"subaddress\",\"regex\"];\n");
  xstrncat (sieveprogram, MAXLENGTH, "\n");      
  
  //FILTERS
  totfilters = FLAllFilters.Count();
  if (totfilters > 0)
    {
    for (numfilter = 0; numfilter < totfilters; ++numfilter)
      {
      filter = FLAllFilters.elementAt(numfilter);
      xstrncat (sieveprogram, MAXLENGTH,   "#Name \"");  xstrncat (sieveprogram, MAXLENGTH, filter.name); xstrncat (sieveprogram, MAXLENGTH, "\"\n");
      if (numfilter == 0)
        {
        xstrncat (sieveprogram, MAXLENGTH,   "if allof \n");    
        }
      else if (numfilter == totfilters - 1)
        {
        xstrncat (sieveprogram, MAXLENGTH,   "elsif allof \n"); 
        }  
      else 
        {
        xstrncat (sieveprogram, MAXLENGTH,   "elsif allof \n"); 
        }  
       
      xstrncat (sieveprogram, MAXLENGTH,   "     (\n"); 
      if (IsEmpty (filter.from) == false)        
        {
        xsnprintf (tmp, CMAXBUFFER, "     address :contains [\"from\"] \"%s\",\n", filter.from);
        xstrncat (sieveprogram, MAXLENGTH, tmp);
        }
      if (IsEmpty (filter.to) == false)          
        {
        xsnprintf (tmp, CMAXBUFFER, "     address :contains [\"Cc\",\"CC\",\"To\",\"TO\"] \"%s\",\n", filter.to);
        xstrncat (sieveprogram, MAXLENGTH, tmp);
        }
      if (IsEmpty (filter.subject) == false)     
        {
        xsnprintf (tmp, CMAXBUFFER, "     header :contains \"subject\" \"%s\",\n", filter.subject);
        xstrncat (sieveprogram, MAXLENGTH, tmp);
        }
      if (IsEmpty (filter.size) == false)        
        {
        xsnprintf (tmp, CMAXBUFFER, "     size :over %sK,\n", filter.size);
        xstrncat (sieveprogram, MAXLENGTH, tmp);
        }
      if (IsEmpty (filter.header_name) == false) 
        {
        xsnprintf (tmp, CMAXBUFFER, "     header :contains \"%s\" \"%s\",\n", filter.header_name, filter.header_value);
        xstrncat (sieveprogram, MAXLENGTH, tmp);
        }

      if ((sieveprogram[strlen(sieveprogram) - 2] == ',') && (sieveprogram[strlen(sieveprogram) - 1] == '\n')) 
        {sieveprogram[strlen(sieveprogram) - 2] = '\n'; sieveprogram[strlen(sieveprogram) - 1] = '\0';}

      xstrncat (sieveprogram, MAXLENGTH,   "     )\n");
      xstrncat (sieveprogram, MAXLENGTH,   "   {\n");  
      if (strcasecmp (filter.action, "move") == 0)
        {
        xsnprintf (tmp, CMAXBUFFER, "   fileinto \"%s\";\n", filter.folder);
        xstrncat (sieveprogram, MAXLENGTH, tmp);
        xsnprintf (tmp, CMAXBUFFER, "   stop;\n");
        xstrncat (sieveprogram, MAXLENGTH, tmp);
        }
      else if (strcasecmp (filter.action, "reject") == 0)                    
        {
        xsnprintf (tmp, CMAXBUFFER, "   reject text:\n%s\n.\n;\n", filter.rejecttext);
        xstrncat (sieveprogram, MAXLENGTH, tmp);
        xsnprintf (tmp, CMAXBUFFER, "   stop;\n");
        xstrncat (sieveprogram, MAXLENGTH, tmp);
        }
      else if (strcasecmp (filter.action, "delete") == 0) 
        {
        xsnprintf (tmp, CMAXBUFFER, "   discard;\n");
        xstrncat (sieveprogram, MAXLENGTH, tmp);
        xsnprintf (tmp, CMAXBUFFER, "   stop;\n");
        xstrncat (sieveprogram, MAXLENGTH, tmp);
        }
      else 
        {
        xstrncat (sieveprogram, MAXLENGTH, "   keep;");
        }        

      xstrncat (sieveprogram, MAXLENGTH,   "   }\n");
      //from, to, subject, size, header_name, header_value, folder, action, rejecttext;
      }
    xstrncat (sieveprogram, MAXLENGTH,   "#default\n");
    xstrncat (sieveprogram, MAXLENGTH,   "else \n");
    xstrncat (sieveprogram, MAXLENGTH,   "  {\n");
    xstrncat (sieveprogram, MAXLENGTH,   "  keep;\n");        
    xstrncat (sieveprogram, MAXLENGTH,   "  }\n");                  
    xstrncat (sieveprogram, MAXLENGTH, "\n");      
    }
    
  //VACATIONS
  xstrncat (sieveprogram, MAXLENGTH, "#VACATIONS\n");
  if (strcasecmp (vacation.vacations_active, "true") == 0)
    {
    SeparaTokensEnStringList (vacation.vacations_ausenstaddresses, '\n', &SL);
    if (SL.Count() > 0)
      {
      initStr (vacation.vacations_ausenstaddresses);
      for (int j=0; j < SL.Count(); ++j)
        {                           
        xstrncat (vacation.vacations_ausenstaddresses, CMAXBUFFER, "\"");
        xstrncpy (tmp, CMAXBUFFER, SL.getString(j).cstr());
        QuitaRetornoCarroDeLinea (tmp);
        xstrncat (vacation.vacations_ausenstaddresses, CMAXBUFFER, tmp);
        xstrncat (vacation.vacations_ausenstaddresses, CMAXBUFFER, "\"");      
        if (j < SL.Count() - 1) {xstrncat (vacation.vacations_ausenstaddresses, CMAXBUFFER, ",");}
        }
      xsnprintf (tmp, CMAXBUFFER, "vacation :days %s :addresses [%s] :subject \"%s\" text:\n", 
                 vacation.vacations_days2repeat, vacation.vacations_ausenstaddresses, vacation.vacations_msgsubject);
      }
    else
      {                          
      xsnprintf (tmp, CMAXBUFFER, "vacation :days %s :subject \"%s\" text:\n", 
                 vacation.vacations_days2repeat, vacation.vacations_msgsubject);
      }
    xstrncat (sieveprogram, MAXLENGTH, tmp);     
    xstrncat (sieveprogram, MAXLENGTH, vacation.vacations_msgtext);
    xstrncat (sieveprogram, MAXLENGTH, "\n.\n;\n");
    }
  xstrncat (sieveprogram, MAXLENGTH, "\n");   
  XS = sieveprogram;
  XS.replace ("\r\n", "\n");
  xstrncpy (sieveprogram, MAXLENGTH, XS.cstr());

  //fprintf (stderr, "%s", sieveprogram);   
  }

bool ClientTIMSIEVED::saveSieveNetwork (void)
  {
  THBuffer sieveprogram;
  StringList SLRes;
  bool b;
  
  makeSieveScript (sieveprogram, CMAXHBUFFER);
  b = doSession (SIEVE_CMD_PUTSCRIPT, POSTMANSIEVEFILTERNAME, &SLRes, sieveprogram, ErrorMsg);
  if (b == false) {return false;};
  b = doSession (SIEVE_CMD_SETACTIVE, POSTMANSIEVEFILTERNAME, &SLRes, NULL, ErrorMsg);
  if (b == false) {return false;};
  return true;
  }

bool ClientTIMSIEVED::isThereFilter (const char *filtername)
  {
  XFilter afilter;  
  for (int i = 0; i < FLAllFilters.Count(); ++i)
    {
    afilter = FLAllFilters.elementAt(i);
    if (strcmp (afilter.name, filtername) == 0) {return true;}
    }
  return false;
  }
